/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.kudos.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.exoplatform.kudos.model.GlobalSettings;
import org.exoplatform.kudos.service.KudosService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/kudos/api/settings")
@Api(value="/kudos/api/settings", description="Manages Kudos global settings")
@RolesAllowed(value={"users"})
public class KudosSettingsREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(KudosSettingsREST.class);
    private KudosService kudosService;

    public KudosSettingsREST(KudosService kudosService) {
        this.kudosService = kudosService;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Get Kudos global settings", httpMethod="GET", response=Response.class, produces="application/json", notes="returns Kudos global settings object")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getSettings() {
        return Response.ok((Object)this.kudosService.getGlobalSettings().toString()).build();
    }

    @Path(value="save")
    @POST
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Saves Kudos global settings", httpMethod="POST", response=Response.class, consumes="application/json", notes="returns empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response saveSettings(GlobalSettings settings) {
        if (settings == null) {
            LOG.warn((Object)"Bad request sent to server with empty 'settings' parameter");
            return Response.status((int)400).build();
        }
        try {
            this.kudosService.saveGlobalSettings(settings);
            return Response.noContent().build();
        }
        catch (Exception e) {
            LOG.warn("Error saving kudos settings: {}", new Object[]{settings, e});
            return Response.serverError().build();
        }
    }
}

