/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.push.service.fcm;

import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.push.domain.Message;
import org.exoplatform.push.service.MessagePublisher;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class FCMLegacyAPIMessagePublisher
implements MessagePublisher {
    private static final Log LOG = ExoLogger.getLogger(FCMLegacyAPIMessagePublisher.class);
    private HttpClient httpClient;
    private String serverKey = null;
    private Integer fcmMessageExpirationTime = null;

    public FCMLegacyAPIMessagePublisher(InitParams initParams) {
        this(initParams, (HttpClient)HttpClientBuilder.create().build());
    }

    public FCMLegacyAPIMessagePublisher(InitParams initParams, HttpClient httpClient) {
        if (initParams != null) {
            ValueParam fcmMessageExpirationTimeValueParam;
            ValueParam serverKeyValueParam = initParams.getValueParam("serverKey");
            if (serverKeyValueParam != null) {
                this.serverKey = serverKeyValueParam.getValue();
            }
            if (StringUtils.isBlank((String)this.serverKey)) {
                LOG.error((Object)"Push notifications - Firebase Cloud Messaging serverKey is mandatory, please configure it with exo.push.fcm.serverKey property.");
            }
            if ((fcmMessageExpirationTimeValueParam = initParams.getValueParam("messageExpirationTime")) != null && StringUtils.isNotBlank((String)fcmMessageExpirationTimeValueParam.getValue())) {
                try {
                    this.fcmMessageExpirationTime = Integer.parseInt(fcmMessageExpirationTimeValueParam.getValue());
                }
                catch (NumberFormatException e) {
                    LOG.error((Object)("Push Notifications - FCM message expiration time is not a valid number (" + fcmMessageExpirationTimeValueParam.getValue() + "), using default value from FCM"), (Throwable)e);
                }
            }
        }
        this.httpClient = httpClient;
    }

    @Override
    public void send(Message message) throws Exception {
        if (StringUtils.isBlank((String)this.serverKey)) {
            return;
        }
        HttpPost post = new HttpPost("https://fcm.googleapis.com/fcm/send");
        post.setHeader("Authorization", "key=" + this.serverKey);
        post.setHeader("Content-Type", "application/json");
        StringBuilder requestBody = new StringBuilder().append("{").append("  \"to\":\"").append(message.getToken()).append("\",");
        if (this.fcmMessageExpirationTime != null) {
            requestBody.append("  \"time_to_live\":\"").append(this.fcmMessageExpirationTime).append("\",");
        }
        requestBody.append("  \"notification\": {").append("    \"title\": \"").append(message.getTitle()).append("\",").append("    \"body\": \"").append(message.getBody()).append("\"").append("  }").append("}").toString();
        post.setEntity((HttpEntity)new ByteArrayEntity(requestBody.toString().getBytes()));
        this.httpClient.execute((HttpUriRequest)post);
    }
}

