/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.oauth;

import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.api.oauth.BasicOAuthProviderImpl;
import org.gatein.api.oauth.OAuthProvider;
import org.gatein.api.oauth.OAuthProviderAccessor;
import org.gatein.security.oauth.spi.AccessTokenContext;
import org.gatein.security.oauth.spi.OAuthProviderType;
import org.gatein.security.oauth.spi.OAuthProviderTypeRegistry;
import org.gatein.security.oauth.spi.SocialNetworkService;

public class BasicOAuthProviderAccessorImpl
implements OAuthProviderAccessor {
    private final OAuthProviderTypeRegistry oauthProviderTypeRegistry;
    private final SocialNetworkService socialNetworkService;
    protected final Log log = ExoLogger.getLogger(this.getClass());

    public BasicOAuthProviderAccessorImpl(OAuthProviderTypeRegistry oauthProviderTypeRegistry, SocialNetworkService socialNetworkService) {
        this.oauthProviderTypeRegistry = oauthProviderTypeRegistry;
        this.socialNetworkService = socialNetworkService;
    }

    @Override
    public OAuthProvider getOAuthProvider(String oauthProviderKey) {
        OAuthProviderType<?> internalOAuthProvider = this.getInternalOAuthProvider(oauthProviderKey);
        if (internalOAuthProvider == null) {
            return null;
        }
        return new BasicOAuthProviderImpl(internalOAuthProvider, this.socialNetworkService);
    }

    protected OAuthProviderType<?> getInternalOAuthProvider(String oauthProviderKey) {
        OAuthProviderType oauthProviderType = this.oauthProviderTypeRegistry.getOAuthProvider(oauthProviderKey, AccessTokenContext.class);
        if (oauthProviderType == null && this.log.isTraceEnabled()) {
            this.log.trace((Object)("OAuthProvider '" + oauthProviderKey + "' not found"));
        }
        return oauthProviderType;
    }

    protected SocialNetworkService getSocialNetworkService() {
        return this.socialNetworkService;
    }
}

