/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.select;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.expression.Alias;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ItemsList;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import liquibase.repackaged.net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.FromItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.FromItemVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Pivot;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectBody;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.UnPivot;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.WithItem;

public class SubSelect
extends ASTNodeAccessImpl
implements Expression,
ItemsList,
FromItem {
    private SelectBody selectBody;
    private Alias alias;
    private boolean useBrackets = true;
    private List<WithItem> withItemsList;
    private Pivot pivot;
    private UnPivot unpivot;

    @Override
    public void accept(FromItemVisitor fromItemVisitor) {
        fromItemVisitor.visit(this);
    }

    public SelectBody getSelectBody() {
        return this.selectBody;
    }

    public void setSelectBody(SelectBody selectBody) {
        this.selectBody = selectBody;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    @Override
    public Alias getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(Alias alias) {
        this.alias = alias;
    }

    @Override
    public Pivot getPivot() {
        return this.pivot;
    }

    @Override
    public void setPivot(Pivot pivot) {
        this.pivot = pivot;
    }

    @Override
    public UnPivot getUnPivot() {
        return this.unpivot;
    }

    @Override
    public void setUnPivot(UnPivot unPivot) {
        this.unpivot = unPivot;
    }

    public boolean isUseBrackets() {
        return this.useBrackets;
    }

    public void setUseBrackets(boolean bl2) {
        this.useBrackets = bl2;
    }

    public List<WithItem> getWithItemsList() {
        return this.withItemsList;
    }

    public void setWithItemsList(List<WithItem> list) {
        this.withItemsList = list;
    }

    @Override
    public void accept(ItemsListVisitor itemsListVisitor) {
        itemsListVisitor.visit(this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.useBrackets) {
            stringBuilder.append("(");
        }
        if (this.withItemsList != null && !this.withItemsList.isEmpty()) {
            stringBuilder.append("WITH ");
            Iterator<WithItem> iterator = this.withItemsList.iterator();
            while (iterator.hasNext()) {
                WithItem withItem = iterator.next();
                stringBuilder.append(withItem);
                if (iterator.hasNext()) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(" ");
            }
        }
        stringBuilder.append(this.selectBody);
        if (this.useBrackets) {
            stringBuilder.append(")");
        }
        if (this.alias != null) {
            stringBuilder.append(this.alias.toString());
        }
        if (this.pivot != null) {
            stringBuilder.append(" ").append(this.pivot);
        }
        if (this.unpivot != null) {
            stringBuilder.append(" ").append(this.unpivot);
        }
        return stringBuilder.toString();
    }

    @Override
    public SubSelect withAlias(Alias alias) {
        this.setAlias(alias);
        return this;
    }

    public SubSelect withUseBrackets(boolean bl2) {
        this.setUseBrackets(bl2);
        return this;
    }

    public SubSelect withItemsList(List<WithItem> list) {
        this.setWithItemsList(list);
        return this;
    }

    public SubSelect withSelectBody(SelectBody selectBody) {
        this.setSelectBody(selectBody);
        return this;
    }

    @Override
    public SubSelect withPivot(Pivot pivot) {
        return (SubSelect)FromItem.super.withPivot(pivot);
    }

    @Override
    public SubSelect withUnPivot(UnPivot unPivot) {
        return (SubSelect)FromItem.super.withUnPivot(unPivot);
    }

    public SubSelect addWithItemsList(WithItem ... withItemArray) {
        List list = Optional.ofNullable(this.getWithItemsList()).orElseGet(ArrayList::new);
        Collections.addAll(list, withItemArray);
        return this.withItemsList(list);
    }

    public SubSelect addWithItemsList(Collection<? extends WithItem> collection) {
        List list = Optional.ofNullable(this.getWithItemsList()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withItemsList(list);
    }

    public <E extends SelectBody> E getSelectBody(Class<E> clazz) {
        return (E)((SelectBody)clazz.cast(this.getSelectBody()));
    }
}

