/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.account;

import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.ExpressionValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.PersonalNameValidator;
import org.exoplatform.webui.form.validator.ResourceValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;
import org.exoplatform.webui.form.validator.UserConfigurableValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={ResetActionListener.class}, phase=Event.Phase.DECODE)})
public class UIAccountProfiles
extends UIForm {
    public UIAccountProfiles() throws Exception {
        String username = Util.getPortalRequestContext().getRemoteUser();
        OrganizationService service = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        User useraccount = service.getUserHandler().findUserByName(username);
        UIFormStringInput userName = new UIFormStringInput("userName", "userName", username);
        userName.setReadOnly(true);
        this.addUIFormInput((UIFormInput)userName.addValidator(MandatoryValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{3, 30}).addValidator(ResourceValidator.class, new Object[0]).addValidator(ExpressionValidator.class, new Object[]{"^[\\p{L}][\\p{L}._\\-\\d]+$", "ResourceValidator.msg.Invalid-char"}));
        this.addUIFormInput((UIFormInput)new UIFormStringInput("firstName", "firstName", useraccount.getFirstName()).addValidator(StringLengthValidator.class, new Object[]{1, 45}).addValidator(MandatoryValidator.class, new Object[0]).addValidator(PersonalNameValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormStringInput("lastName", "lastName", useraccount.getLastName()).addValidator(StringLengthValidator.class, new Object[]{1, 45}).addValidator(MandatoryValidator.class, new Object[0]).addValidator(PersonalNameValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormStringInput("displayName", "displayName", useraccount.getDisplayName()).addValidator(StringLengthValidator.class, new Object[]{0, 90}).addValidator(UserConfigurableValidator.class, new Object[]{"displayname", "gatein.validators.displayname", false}));
        this.addUIFormInput((UIFormInput)new UIFormStringInput("email", "email", useraccount.getEmail()).addValidator(MandatoryValidator.class, new Object[0]).addValidator(UserConfigurableValidator.class, new Object[]{"email"}));
    }

    public static class SaveActionListener
    extends EventListener<UIAccountProfiles> {
        public void execute(Event<UIAccountProfiles> event) throws Exception {
            UIAccountProfiles uiForm = (UIAccountProfiles)((Object)event.getSource());
            OrganizationService service = (OrganizationService)uiForm.getApplicationComponent(OrganizationService.class);
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            UIApplication uiApp = context.getUIApplication();
            ConversationState state = ConversationState.getCurrent();
            String userName = ((User)state.getAttribute("UserProfile")).getUserName();
            User user = service.getUserHandler().findUserByName(userName);
            if (user != null) {
                String oldEmail = user.getEmail();
                String newEmail = (String)uiForm.getUIStringInput("email").getValue();
                Query query = new Query();
                query.setEmail(newEmail);
                if (service.getUserHandler().findUsers(query).getAll().size() > 0 && !oldEmail.equals(newEmail)) {
                    user.setEmail(oldEmail);
                    Object[] args = new Object[]{userName};
                    uiApp.addMessage(new ApplicationMessage("UIAccountInputSet.msg.email-exist", args));
                    return;
                }
                user.setFirstName((String)uiForm.getUIStringInput("firstName").getValue());
                user.setLastName((String)uiForm.getUIStringInput("lastName").getValue());
                user.setDisplayName((String)uiForm.getUIStringInput("displayName").getValue());
                user.setEmail(newEmail);
                uiApp.addMessage(new ApplicationMessage("UIAccountProfiles.msg.update.success", null));
                try {
                    service.getUserHandler().saveUser(user, true);
                }
                catch (Exception e) {
                    uiApp.addMessage(new ApplicationMessage("UIAccountProfiles.msg.update.fail", null, 0));
                    return;
                }
                state.setAttribute("UserProfile", (Object)user);
                UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)Util.getUIPortalApplication().getChild(UIWorkingWorkspace.class);
                uiWorkingWS.updatePortletsByName("UserInfoPortlet");
                uiWorkingWS.updatePortletsByName("OrganizationPortlet");
            } else {
                JavascriptManager jsManager = Util.getPortalRequestContext().getJavascriptManager();
                jsManager.require("SHARED/base").addScripts("if(confirm('" + Util.getPortalRequestContext().getApplicationResourceBundle().getString("UIAccountProfiles.msg.NotExistingAccount") + "')) {eXo.portal.logout();}");
            }
        }
    }

    public static class ResetActionListener
    extends EventListener<UIAccountProfiles> {
        public void execute(Event<UIAccountProfiles> event) throws Exception {
            UIAccountProfiles uiForm = (UIAccountProfiles)((Object)event.getSource());
            String userName = (String)uiForm.getUIStringInput("userName").getValue();
            OrganizationService service = (OrganizationService)uiForm.getApplicationComponent(OrganizationService.class);
            User user = service.getUserHandler().findUserByName(userName);
            uiForm.getUIStringInput("firstName").setValue((Object)user.getFirstName());
            uiForm.getUIStringInput("lastName").setValue((Object)user.getLastName());
            uiForm.getUIStringInput("displayName").setValue((Object)user.getDisplayName());
            uiForm.getUIStringInput("email").setValue((Object)user.getEmail());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }
}

