/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.reward.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.wallet.model.reward.RewardPeriod;
import org.exoplatform.wallet.model.reward.RewardPeriodType;
import org.exoplatform.wallet.model.reward.RewardPeriodWithFullDate;
import org.exoplatform.wallet.model.reward.RewardSettings;
import org.exoplatform.wallet.reward.service.RewardSettingsService;
import org.exoplatform.wallet.utils.RewardUtils;

@Path(value="/wallet/api/reward/settings")
@RolesAllowed(value={"rewarding"})
@Api(value="/wallet/api/reward/settings", description="Manage reward module settings")
public class RewardSettingsREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(RewardSettingsREST.class);
    private RewardSettingsService rewardSettingsService;

    public RewardSettingsREST(RewardSettingsService rewardSettingsService) {
        this.rewardSettingsService = rewardSettingsService;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"rewarding"})
    @ApiOperation(value="Get reward settings", httpMethod="GET", response=Response.class, produces="application/json", notes="returns reward settings object")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getSettings() {
        try {
            RewardSettings settings = this.rewardSettingsService.getSettings();
            return Response.ok((Object)(settings == null ? new RewardSettings() : settings)).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting reward settings", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="save")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"rewarding"})
    @ApiOperation(value="Get reward settings", httpMethod="POST", response=Response.class, produces="application/json", notes="returns reward settings object")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response saveSettings(@ApiParam(value="Reward settings object", required=true) RewardSettings rewardSettings) {
        if (rewardSettings == null) {
            LOG.warn((Object)"Bad request sent to server with empty settings");
            return Response.status((int)400).build();
        }
        try {
            this.rewardSettingsService.saveSettings(rewardSettings);
            LOG.info("{} saved reward settings '{}'", new Object[]{RewardUtils.getCurrentUserId(), rewardSettings.toString()});
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error saving reward settings", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @Path(value="getDates")
    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get dates corresponding to chosen period type and start date", httpMethod="GET", response=Response.class, produces="application/json", notes="returns reward period dates object")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getRewardDates(@ApiParam(value="A date with format yyyy-MM-dd", required=true) @QueryParam(value="date") String date) {
        if (StringUtils.isBlank((String)date)) {
            return Response.status((int)400).entity((Object)"Bad request sent to server with empty 'date' parameter").build();
        }
        RewardSettings settings = this.rewardSettingsService.getSettings();
        ZoneId zoneId = settings.zoneId();
        RewardPeriodType rewardPeriodType = settings.getPeriodType();
        ZonedDateTime zonedDateTime = RewardUtils.parseRFC3339ToZonedDateTime(date, zoneId);
        RewardPeriod rewardPeriod = rewardPeriodType.getPeriodOfTime(zonedDateTime);
        RewardPeriodWithFullDate periodWithFullDate = new RewardPeriodWithFullDate(rewardPeriod);
        return Response.ok((Object)periodWithFullDate).build();
    }
}

