/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileEventListener;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.settings.ProfilePropertySettingsService;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertySetting;
import org.exoplatform.social.core.storage.api.IdentityStorage;

public class SocialUserProfileEventListenerImpl
extends UserProfileEventListener {
    private static final Log LOG = ExoLogger.getLogger(SocialUserProfileEventListenerImpl.class);
    private final List<String> exlcudedAttributeList = List.of("authenticationAttempts", "latestAuthFailureTime");
    private final IdentityManager identityManager;
    private final ProfilePropertySettingsService profilePropertySettingsService;

    public SocialUserProfileEventListenerImpl(IdentityManager identityManager, ProfilePropertySettingsService profilePropertySettingsService) {
        this.identityManager = identityManager;
        this.profilePropertySettingsService = profilePropertySettingsService;
    }

    public void postSave(UserProfile userProfile, boolean isNew) throws Exception {
        Identity identity = this.identityManager.getOrCreateIdentity("organization", userProfile.getUserName());
        Profile profile = identity.getProfile();
        String uGender = userProfile.getAttribute(UserProfile.PERSONAL_INFO_KEYS[4]);
        String uPosition = userProfile.getAttribute(UserProfile.PERSONAL_INFO_KEYS[7]);
        String pGender = (String)profile.getProperty("gender");
        String pPosition = (String)profile.getProperty("position");
        AtomicBoolean hasUpdated = new AtomicBoolean(false);
        Map properties = userProfile.getUserInfoMap();
        this.exlcudedAttributeList.forEach(properties.keySet()::remove);
        properties.forEach((name, value) -> {
            this.updateProfilePropertySettings((String)name, this.profilePropertySettingsService);
            if (isNew) {
                profile.setProperty(name, value);
            } else if (!StringUtils.equals((CharSequence)((String)profile.getProperty(name)), (CharSequence)userProfile.getAttribute(name))) {
                profile.setProperty(name, value);
                hasUpdated.set(true);
            }
        });
        if (!StringUtils.equals((CharSequence)uGender, (CharSequence)pGender)) {
            profile.setProperty("gender", (Object)uGender);
            hasUpdated.set(true);
        }
        if (!StringUtils.equals((CharSequence)uPosition, (CharSequence)pPosition)) {
            profile.setProperty("position", (Object)uPosition);
            hasUpdated.set(true);
        }
        if (hasUpdated.get()) {
            ArrayList<Profile.UpdateType> updateTypes = new ArrayList<Profile.UpdateType>();
            updateTypes.add(Profile.UpdateType.CONTACT);
            profile.setListUpdateTypes(updateTypes);
        }
        if (hasUpdated.get() && !isNew) {
            IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
            identityManager.updateProfile(profile);
        }
        if (isNew) {
            IdentityStorage identityStorage = (IdentityStorage)CommonsUtils.getService(IdentityStorage.class);
            identityStorage.updateProfile(profile);
        }
    }

    private void updateProfilePropertySettings(String propertyName, ProfilePropertySettingsService profilePropertySettingsService) {
        ProfilePropertySetting propertySetting = profilePropertySettingsService.getProfileSettingByName(propertyName);
        if (propertySetting == null) {
            ProfilePropertySetting profilePropertySetting = new ProfilePropertySetting();
            profilePropertySetting.setPropertyName(propertyName);
            profilePropertySetting.setMultiValued(false);
            profilePropertySetting.setActive(true);
            profilePropertySetting.setEditable(false);
            profilePropertySetting.setVisible(true);
            profilePropertySetting.setParentId(null);
            try {
                profilePropertySettingsService.createPropertySetting(profilePropertySetting);
            }
            catch (ObjectAlreadyExistsException e) {
                LOG.error((Object)"Error while adding new profile setting property", (Throwable)e);
            }
        }
    }
}

