/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.profile;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.social.core.identity.model.Profile;

public class UserProfileComparator {
    private UserProfileComparator() {
    }

    public static boolean hasChanged(Profile profileToUpdate, Profile existingProfile, String ... keys) {
        if (keys != null && keys.length > 0) {
            for (String key : keys) {
                if (!UserProfileComparator.hasChanged(profileToUpdate, existingProfile, key)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasChanged(Profile profileToUpdate, Profile existingProfile, List<String> keys) {
        if (keys != null && !keys.isEmpty()) {
            for (String key : keys) {
                if (!UserProfileComparator.hasChanged(profileToUpdate, existingProfile, key)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasChanged(Profile profileToUpdate, Profile existingProfile, String key) {
        Object newValue = profileToUpdate.getProperty(key);
        Object oldValue = existingProfile.getProperty(key);
        if (oldValue == null) {
            return newValue != null && (newValue instanceof String && StringUtils.isNotBlank((CharSequence)newValue.toString()) || newValue instanceof List && !((List)newValue).isEmpty() || newValue instanceof Date);
        }
        if (oldValue instanceof String) {
            newValue = newValue == null ? "" : String.valueOf(newValue);
            return !StringUtils.equals((CharSequence)((String)oldValue), (CharSequence)((String)newValue));
        }
        if (oldValue instanceof List) {
            List oldValueList = (List)oldValue;
            List newValueList = (List)newValue;
            return !UserProfileComparator.isEquals(oldValueList, newValueList);
        }
        return !ObjectUtils.equals((Object)newValue, (Object)oldValue);
    }

    private static boolean isEquals(List<Map<String, Object>> list1, List<Map<String, Object>> list2) {
        if (list2 == null) {
            return true;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        int size = list1.size();
        for (int i = 0; i < size; ++i) {
            if (UserProfileComparator.isEqual(list1.get(i), list2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isEqual(Map<String, Object> m1, Map<String, Object> m2) {
        if (m1.size() != m2.size()) {
            return false;
        }
        Set<Map.Entry<String, Object>> entries = m1.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            Object val2;
            Object val1 = entry.getValue();
            if (val1 == null) {
                val1 = "";
            }
            if ((val2 = m2.get(entry.getKey())) == null) {
                val2 = "";
            }
            if (StringUtils.equals((CharSequence)val1.toString(), (CharSequence)val2.toString())) continue;
            return false;
        }
        return true;
    }
}

