/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.profile.settings;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertySetting;
import org.exoplatform.social.core.storage.api.ProfileSettingStorage;
import org.picocontainer.Startable;

public class ProfilePropertySettingsService
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(ProfilePropertySettingsService.class);
    private final ProfileSettingStorage profileSettingStorage;
    private final SettingService settingService;
    private static final String CREATE_PROFILE_DEFAULT_SETTING_KEY = "social.profile.default.settings";
    public static final String LABELS_OBJECT_TYPE = "profileProperty";
    private final List<String> predifinedSystemProperties = Arrays.asList("fullName", "firstName", "lastName", "email", "position", "company", "location", "department", "team", "profession", "country", "city", "phones", "phones.work", "phones.home", "phones.other", "ims", "ims.facebook", "ims.msn", "ims.jitsi", "ims.skype", "ims.other", "urls");
    private final List<String> synchronizedGroupDisabledProperties = Arrays.asList("fullName", "firstName", "lastName", "email", "phones", "phones.work", "phones.home", "phones.other", "ims", "ims.facebook", "ims.msn", "ims.jitsi", "ims.skype", "ims.other", "urls");

    public ProfilePropertySettingsService(ProfileSettingStorage profileSettingStorage, SettingService settingService) {
        this.profileSettingStorage = profileSettingStorage;
        this.settingService = settingService;
    }

    public List<ProfilePropertySetting> getPropertySettings() {
        return this.profileSettingStorage.getPropertySettings();
    }

    public List<ProfilePropertySetting> getSynchronizedPropertySettings() {
        return this.profileSettingStorage.getSynchronizedPropertySettings();
    }

    public ProfilePropertySetting getProfileSettingByName(String name) {
        return this.profileSettingStorage.findProfileSettingByName(name);
    }

    public ProfilePropertySetting createPropertySetting(ProfilePropertySetting profilePropertySetting) throws ObjectAlreadyExistsException {
        if (profilePropertySetting == null) {
            throw new IllegalArgumentException("Profile property setting Item Object is mandatory");
        }
        if (StringUtils.isBlank((String)profilePropertySetting.getPropertyName())) {
            throw new IllegalArgumentException("Profile property name is mandatory");
        }
        ProfilePropertySetting storedProfilePropertySetting = this.profileSettingStorage.findProfileSettingByName(profilePropertySetting.getPropertyName());
        if (storedProfilePropertySetting != null) {
            throw new ObjectAlreadyExistsException((Object)storedProfilePropertySetting, "A profile property with provided name already exist");
        }
        if (!this.isGroupSynchronizedEnabledProperty(profilePropertySetting)) {
            profilePropertySetting.setGroupSynchronized(false);
        }
        return this.profileSettingStorage.saveProfilePropertySetting(profilePropertySetting, true);
    }

    public void updatePropertySetting(ProfilePropertySetting profilePropertySetting) {
        if (!this.isGroupSynchronizedEnabledProperty(profilePropertySetting)) {
            profilePropertySetting.setGroupSynchronized(false);
        }
        this.profileSettingStorage.saveProfilePropertySetting(profilePropertySetting, false);
    }

    public void deleteProfilePropertySetting(Long id) {
        if (id <= 0L) {
            throw new IllegalArgumentException("Profile Property Setting Technical Identifier is mandatory");
        }
        this.profileSettingStorage.deleteProfilePropertySetting(id);
    }

    public boolean isGroupSynchronizedEnabledProperty(ProfilePropertySetting profilePropertySetting) {
        ProfilePropertySetting parent;
        if (this.synchronizedGroupDisabledProperties.contains(profilePropertySetting.getPropertyName())) {
            return false;
        }
        return profilePropertySetting.getParentId() == null || profilePropertySetting.getParentId() <= 0L || (parent = this.profileSettingStorage.getProfileSettingById(profilePropertySetting.getParentId())) == null || !this.synchronizedGroupDisabledProperties.contains(parent.getPropertyName());
    }

    public void start() {
        SettingValue settingsValue = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, CREATE_PROFILE_DEFAULT_SETTING_KEY);
        if (settingsValue == null) {
            LOG.info((Object)"Start Creation of default Profile properties Settings");
            int index = 1;
            int numCreated = 1;
            for (String propertyName : this.predifinedSystemProperties) {
                if (this.getProfileSettingByName(propertyName) == null) {
                    try {
                        ProfilePropertySetting parent;
                        Long parentId = null;
                        if (propertyName.contains(".") && (parent = this.getProfileSettingByName(propertyName.split("\\.")[0])) != null) {
                            parentId = parent.getId();
                        }
                        ProfilePropertySetting profilePropertySetting = new ProfilePropertySetting();
                        profilePropertySetting.setPropertyName(propertyName);
                        if (propertyName.equals("urls")) {
                            profilePropertySetting.setMultiValued(true);
                        } else {
                            profilePropertySetting.setMultiValued(false);
                        }
                        profilePropertySetting.setActive(true);
                        if (propertyName.equals("fullName")) {
                            profilePropertySetting.setEditable(false);
                        } else {
                            profilePropertySetting.setEditable(true);
                        }
                        profilePropertySetting.setOrder(Long.valueOf(index));
                        if (propertyName.equals("firstName") || propertyName.equals("lastName")) {
                            profilePropertySetting.setVisible(false);
                        } else {
                            profilePropertySetting.setVisible(true);
                        }
                        profilePropertySetting.setGroupSynchronized(false);
                        if (propertyName.equals("firstName") || propertyName.equals("lastName") || propertyName.equals("email") || propertyName.equals("position")) {
                            profilePropertySetting.setVisible(true);
                        } else {
                            profilePropertySetting.setRequired(false);
                        }
                        profilePropertySetting.setParentId(parentId);
                        this.createPropertySetting(profilePropertySetting);
                        ++numCreated;
                    }
                    catch (ObjectAlreadyExistsException e) {
                        LOG.warn((Object)"Property setting already exist");
                    }
                    catch (Exception e) {
                        LOG.warn("PException occured when trying to create {}  profile setting", new Object[]{propertyName});
                    }
                }
                ++index;
            }
            this.settingService.set(Context.GLOBAL, Scope.GLOBAL, CREATE_PROFILE_DEFAULT_SETTING_KEY, SettingValue.create((String)"Done"));
            LOG.info("End Of creation of {} default Profile properties Settings", new Object[]{numCreated});
        }
    }

    public void stop() {
    }
}

