/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jdbc.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.services.jdbc.DataSourceProvider;
import org.exoplatform.services.jdbc.impl.ManagedDataSource;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.transaction.TransactionService;

public class DataSourceProviderImpl
implements DataSourceProvider {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.component.common.DataSourceProviderImpl");
    protected static final String PARAM_CHECK_TX = "check-tx-active";
    protected static final String PARAM_ALWAYS_MANAGED = "always-managed";
    protected static final String PARAM_MANAGED_DS = "managed-data-sources";
    protected final TransactionManager tm;
    protected boolean checkIfTxActive = true;
    protected boolean alwaysManaged;
    protected final Set<String> managedDS = new HashSet<String>();

    public DataSourceProviderImpl(InitParams params) {
        this(params, null);
    }

    public DataSourceProviderImpl(InitParams params, TransactionService tService) {
        TransactionManager transactionManager = this.tm = tService == null ? null : tService.getTransactionManager();
        if (params != null) {
            ValueParam param = params.getValueParam(PARAM_CHECK_TX);
            if (param != null) {
                this.checkIfTxActive = Boolean.valueOf(param.getValue());
            }
            if ((param = params.getValueParam(PARAM_ALWAYS_MANAGED)) != null && Boolean.valueOf(param.getValue()).booleanValue()) {
                this.alwaysManaged = true;
                return;
            }
            ValuesParam vp = params.getValuesParam(PARAM_MANAGED_DS);
            if (vp != null && vp.getValues() != null) {
                for (Object oValue : vp.getValues()) {
                    String s = (String)oValue;
                    StringTokenizer st = new StringTokenizer(s, ",");
                    while (st.hasMoreTokens()) {
                        String dsName = st.nextToken().trim();
                        if (dsName.isEmpty()) continue;
                        this.managedDS.add(dsName);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSource getDataSource(String dataSourceName) throws NamingException {
        InitialContext ctx = new InitialContext();
        try {
            DataSource ds = (DataSource)ctx.lookup(dataSourceName);
            DataSource dataSource = this.isManaged(dataSourceName) ? new ManagedDataSource(ds, this.tm, this.checkIfTxActive) : ds;
            return dataSource;
        }
        finally {
            try {
                ctx.close();
            }
            catch (NamingException e) {
                LOG.warn((Object)"Failed to close naming context.", (Throwable)e);
            }
        }
    }

    @Override
    public boolean isManaged(String dataSourceName) {
        if (this.alwaysManaged) {
            return true;
        }
        if (this.managedDS.isEmpty()) {
            return false;
        }
        return this.managedDS.contains(dataSourceName);
    }
}

