/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2.segments;

import java.io.IOException;
import org.apache.pdfbox.jbig2.SegmentData;
import org.apache.pdfbox.jbig2.SegmentHeader;
import org.apache.pdfbox.jbig2.err.IntegerMaxValueException;
import org.apache.pdfbox.jbig2.err.InvalidHeaderValueException;
import org.apache.pdfbox.jbig2.io.SubInputStream;
import org.apache.pdfbox.jbig2.util.CombinationOperator;

public class RegionSegmentInformation
implements SegmentData {
    private SubInputStream subInputStream;
    private int bitmapWidth;
    private int bitmapHeight;
    private int xLocation;
    private int yLocation;
    private CombinationOperator combinationOperator;

    public RegionSegmentInformation(SubInputStream subInputStream) {
        this.subInputStream = subInputStream;
    }

    public RegionSegmentInformation() {
    }

    public void parseHeader() throws IOException {
        this.bitmapWidth = (int)(this.subInputStream.readBits(32) & 0xFFFFFFFFFFFFFFFFL);
        this.bitmapHeight = (int)(this.subInputStream.readBits(32) & 0xFFFFFFFFFFFFFFFFL);
        this.xLocation = (int)(this.subInputStream.readBits(32) & 0xFFFFFFFFFFFFFFFFL);
        this.yLocation = (int)(this.subInputStream.readBits(32) & 0xFFFFFFFFFFFFFFFFL);
        this.subInputStream.readBits(5);
        this.readCombinationOperator();
    }

    private void readCombinationOperator() throws IOException {
        this.combinationOperator = CombinationOperator.translateOperatorCodeToEnum((short)(this.subInputStream.readBits(3) & 0xFL));
    }

    @Override
    public void init(SegmentHeader segmentHeader, SubInputStream subInputStream) throws InvalidHeaderValueException, IntegerMaxValueException, IOException {
    }

    public void setBitmapWidth(int n) {
        this.bitmapWidth = n;
    }

    public int getBitmapWidth() {
        return this.bitmapWidth;
    }

    public void setBitmapHeight(int n) {
        this.bitmapHeight = n;
    }

    public int getBitmapHeight() {
        return this.bitmapHeight;
    }

    public int getXLocation() {
        return this.xLocation;
    }

    public int getYLocation() {
        return this.yLocation;
    }

    public CombinationOperator getCombinationOperator() {
        return this.combinationOperator;
    }
}

