/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.impl;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.DateTimeException;
import java.time.temporal.TemporalAccessor;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import javax.measure.IncommensurableException;
import javax.measure.UnitConverter;
import javax.measure.format.ParserException;
import org.apache.sis.internal.netcdf.DataType;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Dimension;
import org.apache.sis.internal.netcdf.Grid;
import org.apache.sis.internal.netcdf.NamedElement;
import org.apache.sis.internal.netcdf.Node;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.netcdf.impl.DimensionInfo;
import org.apache.sis.internal.netcdf.impl.GridInfo;
import org.apache.sis.internal.netcdf.impl.VariableInfo;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.StandardDateFormat;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.Units;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.parameter.InvalidParameterCardinalityException;

public final class ChannelDecoder
extends Decoder {
    public static final int MAGIC_NUMBER = 1128547840;
    public static final int MAX_VERSION = 2;
    private static final Charset NAME_ENCODING = StandardCharsets.UTF_8;
    static final Locale NAME_LOCALE = Locale.US;
    private static final int STREAMING = -1;
    private static final int DIMENSION = 10;
    private static final int VARIABLE = 11;
    private static final int ATTRIBUTE = 12;
    private final ChannelDataInput input;
    private final boolean is64bits;
    private final int numrecs;
    private Charset encoding;
    final VariableInfo[] variables;
    private final Map<String, VariableInfo> variableMap;
    private final Map<String, Object> attributeMap;
    private final Set<String> attributeNames;
    private Map<String, DimensionInfo> dimensionMap;
    private transient Grid[] gridGeometries;

    public ChannelDecoder(ChannelDataInput channelDataInput, Charset charset, GeometryLibrary geometryLibrary, StoreListeners storeListeners) throws IOException, DataStoreException {
        super(geometryLibrary, storeListeners);
        this.input = channelDataInput;
        this.encoding = charset != null ? charset : StandardCharsets.UTF_8;
        int n = channelDataInput.readInt();
        if ((n & 0xFFFFFF00) != 1128547840) {
            throw new DataStoreContentException(this.errors().getString((short)139, (Object)"netCDF", (Object)this.getFilename()));
        }
        switch (n &= 0xFF) {
            case 1: {
                this.is64bits = false;
                break;
            }
            case 2: {
                this.is64bits = true;
                break;
            }
            default: {
                throw new DataStoreContentException(this.errors().getString((short)159, (Object)"netCDF", (Object)n));
            }
        }
        this.numrecs = channelDataInput.readInt();
        DimensionInfo[] dimensionInfoArray = null;
        VariableInfo[] variableInfoArray = null;
        List<Map.Entry<String, Object>> list = Collections.emptyList();
        for (int i = 0; i < 3; ++i) {
            long l = channelDataInput.readLong();
            if (l == 0L) continue;
            int n2 = (int)(l >>> 32);
            int n3 = (int)l;
            this.ensureNonNegative(n3, n2);
            try {
                switch (n2) {
                    case 10: {
                        dimensionInfoArray = this.readDimensions(n3);
                        break;
                    }
                    case 11: {
                        variableInfoArray = this.readVariables(n3, dimensionInfoArray);
                        break;
                    }
                    case 12: {
                        list = this.readAttributes(n3);
                        break;
                    }
                    default: {
                        throw this.malformedHeader();
                    }
                }
                continue;
            }
            catch (InvalidParameterCardinalityException invalidParameterCardinalityException) {
                throw this.malformedHeader().initCause((Throwable)invalidParameterCardinalityException);
            }
        }
        this.attributeMap = CollectionsExt.toCaseInsensitiveNameMap(list, (Locale)NAME_LOCALE);
        this.attributeNames = ChannelDecoder.attributeNames(list, this.attributeMap);
        if (variableInfoArray != null) {
            this.variables = variableInfoArray;
            this.variableMap = ChannelDecoder.toCaseInsensitiveNameMap(variableInfoArray);
        } else {
            this.variables = new VariableInfo[0];
            this.variableMap = Collections.emptyMap();
        }
        this.initialize();
    }

    private static <E extends NamedElement> Map<String, E> toCaseInsensitiveNameMap(E[] EArray) {
        return CollectionsExt.toCaseInsensitiveNameMap((Collection)new AbstractList<Map.Entry<String, E>>((NamedElement[])EArray){
            final /* synthetic */ NamedElement[] val$elements;
            {
                this.val$elements = namedElementArray;
            }

            @Override
            public int size() {
                return this.val$elements.length;
            }

            @Override
            public Map.Entry<String, E> get(int n) {
                NamedElement namedElement = this.val$elements[n];
                return new AbstractMap.SimpleImmutableEntry<String, NamedElement>(namedElement.getName(), namedElement);
            }
        }, (Locale)NAME_LOCALE);
    }

    private static String tagName(int n) {
        short s;
        switch (n) {
            case 10: {
                s = 65;
                break;
            }
            case 11: {
                s = 217;
                break;
            }
            case 12: {
                s = 10;
                break;
            }
            default: {
                return Integer.toHexString(n);
            }
        }
        return Vocabulary.format((short)s);
    }

    final Errors errors() {
        return Errors.getResources((Locale)this.listeners.getLocale());
    }

    private DataStoreContentException malformedHeader() {
        return new DataStoreContentException(this.listeners.getLocale(), "netCDF", this.getFilename(), null);
    }

    private void ensureNonNegative(int n, int n2) throws DataStoreContentException {
        if (n < 0) {
            throw new DataStoreContentException(this.errors().getString((short)93, (Object)this.tagPath(ChannelDecoder.tagName(n2))));
        }
    }

    private String tagPath(String string) {
        return this.getFilename() + ':' + string;
    }

    private void align(int n) throws IOException {
        if ((n &= 3) != 0) {
            n = 4 - n;
            this.input.ensureBufferContains(n);
            this.input.buffer.position(this.input.buffer.position() + n);
        }
    }

    private long readOffset() throws IOException {
        return this.is64bits ? this.input.readLong() : this.input.readUnsignedInt();
    }

    private String readName() throws IOException, DataStoreContentException {
        int n = this.input.readInt();
        if (n < 0) {
            throw this.malformedHeader();
        }
        String string = this.input.readString(n, NAME_ENCODING);
        this.align(n);
        return string;
    }

    private Object readValues(DataType dataType, int n) throws IOException, DataStoreContentException {
        Object[] objectArray;
        if (n <= 0) {
            if (n == 0) {
                return null;
            }
            throw this.malformedHeader();
        }
        if (n == 1) {
            switch (dataType) {
                case BYTE: {
                    byte by = this.input.readByte();
                    this.align(1);
                    return by;
                }
                case UBYTE: {
                    short s = (short)this.input.readUnsignedByte();
                    this.align(1);
                    return s;
                }
                case SHORT: {
                    short s = this.input.readShort();
                    this.align(2);
                    return s;
                }
                case USHORT: {
                    int n2 = this.input.readUnsignedShort();
                    this.align(2);
                    return n2;
                }
                case INT: {
                    return this.input.readInt();
                }
                case INT64: {
                    return this.input.readLong();
                }
                case UINT: {
                    return this.input.readUnsignedInt();
                }
                case FLOAT: {
                    return Float.valueOf(this.input.readFloat());
                }
                case DOUBLE: {
                    return this.input.readDouble();
                }
            }
        }
        switch (dataType) {
            case CHAR: {
                String string = this.input.readString(n, this.encoding);
                this.align(n);
                return string.isEmpty() ? null : string;
            }
            case BYTE: 
            case UBYTE: {
                byte[] byArray = new byte[n];
                this.input.readFully(byArray);
                this.align(n);
                objectArray = byArray;
                break;
            }
            case SHORT: 
            case USHORT: {
                short[] sArray = new short[n];
                this.input.readFully(sArray, 0, n);
                this.align(n << 1);
                objectArray = sArray;
                break;
            }
            case INT: 
            case UINT: {
                int[] nArray = new int[n];
                this.input.readFully(nArray, 0, n);
                objectArray = nArray;
                break;
            }
            case INT64: 
            case UINT64: {
                long[] lArray = new long[n];
                this.input.readFully(lArray, 0, n);
                objectArray = lArray;
                break;
            }
            case FLOAT: {
                float[] fArray = new float[n];
                this.input.readFully(fArray, 0, n);
                return Vector.createForDecimal((float[])fArray);
            }
            case DOUBLE: {
                double[] dArray = new double[n];
                this.input.readFully(dArray, 0, n);
                float[] fArray = ArraysExt.copyAsFloatsIfLossless((double[])dArray);
                if (fArray != null) {
                    return Vector.createForDecimal((float[])fArray);
                }
                objectArray = dArray;
                break;
            }
            default: {
                throw this.malformedHeader();
            }
        }
        return Vector.create((Object)objectArray, (boolean)dataType.isUnsigned);
    }

    private DimensionInfo[] readDimensions(int n) throws IOException, DataStoreContentException {
        NamedElement[] namedElementArray = new DimensionInfo[n];
        for (int i = 0; i < n; ++i) {
            boolean bl;
            String string = this.readName();
            int n2 = this.input.readInt();
            boolean bl2 = bl = n2 == 0;
            if (bl && (n2 = this.numrecs) == -1) {
                throw new DataStoreContentException(this.errors().getString((short)89, (Object)this.tagPath("numrecs")));
            }
            namedElementArray[i] = new DimensionInfo(string, n2, bl);
        }
        this.dimensionMap = ChannelDecoder.toCaseInsensitiveNameMap((NamedElement[])namedElementArray);
        return namedElementArray;
    }

    private List<Map.Entry<String, Object>> readAttributes(int n) throws IOException, DataStoreException {
        ArrayList<Map.Entry<String, Object>> arrayList = new ArrayList<Map.Entry<String, Object>>(n);
        while (--n >= 0) {
            String string = this.readName();
            Object object = this.readValues(DataType.valueOf(this.input.readInt()), this.input.readInt());
            if (object == null) continue;
            arrayList.add(new AbstractMap.SimpleEntry<String, Object>(string, object));
            if (!string.equals("_Encoding")) continue;
            try {
                this.encoding = Charset.forName(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.listeners.warning(Errors.format((short)11, (Object)this.getFilename(), (Object)"_Encoding"), (Exception)illegalArgumentException);
            }
        }
        return arrayList;
    }

    private VariableInfo[] readVariables(int n, DimensionInfo[] dimensionInfoArray) throws IOException, DataStoreException {
        if (dimensionInfoArray == null) {
            throw this.malformedHeader();
        }
        VariableInfo[] variableInfoArray = new VariableInfo[n];
        for (int i = 0; i < n; ++i) {
            String string = this.readName();
            int n2 = this.input.readInt();
            DimensionInfo[] dimensionInfoArray2 = new DimensionInfo[n2];
            try {
                for (int j = 0; j < n2; ++j) {
                    dimensionInfoArray2[j] = dimensionInfoArray[this.input.readInt()];
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw this.malformedHeader().initCause((Throwable)indexOutOfBoundsException);
            }
            List<Map.Entry<String, Object>> list = Collections.emptyList();
            long l = this.input.readLong();
            if (l != 0L) {
                int n3 = (int)(l >>> 32);
                int n4 = (int)l;
                this.ensureNonNegative(n4, n3);
                switch (n3) {
                    case 12: {
                        Charset charset = this.encoding;
                        list = this.readAttributes(n4);
                        this.encoding = charset;
                        break;
                    }
                    default: {
                        throw this.malformedHeader();
                    }
                }
            }
            Map map = CollectionsExt.toCaseInsensitiveNameMap(list, (Locale)NAME_LOCALE);
            variableInfoArray[i] = new VariableInfo(this, this.input, string, dimensionInfoArray2, map, ChannelDecoder.attributeNames(list, map), DataType.valueOf(this.input.readInt()), this.input.readInt(), this.readOffset());
        }
        VariableInfo.complete(variableInfoArray);
        return variableInfoArray;
    }

    private static Set<String> attributeNames(List<Map.Entry<String, Object>> list, Map<String, ?> map) {
        if (list.size() >= map.size()) {
            return Collections.unmodifiableSet(map.keySet());
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Containers.hashMapCapacity((int)list.size()));
        list.forEach(entry -> linkedHashSet.add((String)entry.getKey()));
        return linkedHashSet;
    }

    @Override
    public final String getFilename() {
        return this.input.filename;
    }

    @Override
    public String[] getFormatDescription() {
        return new String[]{"NetCDF"};
    }

    @Override
    public void setSearchPath(String ... stringArray) {
    }

    @Override
    public String[] getSearchPath() {
        return new String[1];
    }

    @Override
    protected Dimension findDimension(String string) {
        String string2;
        DimensionInfo dimensionInfo = this.dimensionMap.get(string);
        if (dimensionInfo == null && (string2 = string.toLowerCase(NAME_LOCALE)) != string) {
            dimensionInfo = this.dimensionMap.get(string2);
        }
        return dimensionInfo;
    }

    private VariableInfo findVariableInfo(String string) {
        String string2;
        VariableInfo variableInfo = this.variableMap.get(string);
        if (variableInfo == null && string != null && (string2 = string.toLowerCase(NAME_LOCALE)) != string) {
            variableInfo = this.variableMap.get(string2);
        }
        return variableInfo;
    }

    @Override
    protected Variable findVariable(String string) {
        return this.findVariableInfo(string);
    }

    @Override
    protected Node findNode(String string) {
        return this.findVariableInfo(string);
    }

    private Object findAttribute(String string) {
        String string2;
        String string3;
        Object object = this.attributeMap.get(string);
        if (object == null && string != null && ((string3 = string.toLowerCase(NAME_LOCALE)) == string || (object = this.attributeMap.get(string3)) == null) && (string2 = this.convention().mapAttributeName(string)) != string && (object = this.attributeMap.get(string2)) == null && (string3 = string.toLowerCase(NAME_LOCALE)) != string2) {
            object = this.attributeMap.get(string3);
        }
        return object;
    }

    @Override
    public Collection<String> getAttributeNames() {
        return Collections.unmodifiableSet(this.attributeNames);
    }

    @Override
    public String stringValue(String string) {
        Object object = this.findAttribute(string);
        return object != null ? object.toString() : null;
    }

    @Override
    public Number numericValue(String string) {
        Object object = this.findAttribute(string);
        if (object instanceof Number) {
            return (Number)object;
        }
        if (object instanceof String) {
            return this.parseNumber(string, (String)object);
        }
        if (object instanceof Vector) {
            return ((Vector)object).get(0);
        }
        return null;
    }

    @Override
    public Date dateValue(String string) {
        Object object = this.findAttribute(string);
        if (object instanceof CharSequence) {
            try {
                return StandardDateFormat.toDate((TemporalAccessor)StandardDateFormat.FORMAT.parse((CharSequence)object));
            }
            catch (ArithmeticException | DateTimeException runtimeException) {
                this.listeners.warning((Exception)runtimeException);
            }
        }
        return null;
    }

    @Override
    public Date[] numberToDate(String string, Number ... numberArray) {
        Date[] dateArray = new Date[numberArray.length];
        Matcher matcher = Variable.TIME_UNIT_PATTERN.matcher(string);
        if (matcher.matches()) {
            try {
                UnitConverter unitConverter = Units.valueOf((String)matcher.group(1)).getConverterToAny(Units.MILLISECOND);
                long l = StandardDateFormat.toDate((TemporalAccessor)StandardDateFormat.FORMAT.parse(matcher.group(2))).getTime();
                for (int i = 0; i < numberArray.length; ++i) {
                    Number number = numberArray[i];
                    if (number == null) continue;
                    dateArray[i] = new Date(l + Math.round(unitConverter.convert(number.doubleValue())));
                }
            }
            catch (ArithmeticException | DateTimeException | IncommensurableException | ParserException throwable) {
                this.listeners.warning((Exception)throwable);
            }
        }
        return dateArray;
    }

    final Charset getEncoding() {
        return this.encoding;
    }

    @Override
    public Variable[] getVariables() {
        return this.variables;
    }

    private boolean listAxes(CharSequence[] charSequenceArray, Set<VariableInfo> set, Set<DimensionInfo> set2) {
        if (charSequenceArray == null || charSequenceArray.length == 0) {
            return false;
        }
        for (CharSequence charSequence : charSequenceArray) {
            VariableInfo variableInfo = this.findVariableInfo(charSequence.toString());
            if (variableInfo == null) {
                set2.clear();
                set.clear();
                break;
            }
            set.add(variableInfo);
            set2.addAll(Arrays.asList(variableInfo.dimensions));
        }
        return true;
    }

    @Override
    public Grid[] getGridCandidates() {
        if (this.gridGeometries == null) {
            IdentityHashMap identityHashMap = new IdentityHashMap();
            block4: for (VariableInfo variableInfoArray : this.variables) {
                switch (variableInfoArray.getRole()) {
                    case COVERAGE: 
                    case DISCRETE_COVERAGE: {
                        variableInfoArray.isCoordinateSystemAxis = false;
                        continue block4;
                    }
                    case AXIS: {
                        variableInfoArray.isCoordinateSystemAxis = true;
                        DimensionInfo[] dimensionInfoArray = variableInfoArray.dimensions;
                        int n = dimensionInfoArray.length;
                        for (int i = 0; i < n; ++i) {
                            DimensionInfo n2 = dimensionInfoArray[i];
                            CollectionsExt.addToMultiValuesMap(identityHashMap, (Object)n2, (Object)variableInfoArray);
                        }
                        continue block4;
                    }
                }
            }
            LinkedHashSet linkedHashSet = new LinkedHashSet(8);
            HashSet<DimensionInfo> hashSet = new HashSet<DimensionInfo>(8);
            LinkedHashMap<GridInfo, GridInfo> linkedHashMap = new LinkedHashMap<GridInfo, GridInfo>();
            block6: for (VariableInfo variableInfo : this.variables) {
                NamedElement namedElement;
                if (variableInfo.isCoordinateSystemAxis || variableInfo.dimensions.length == 0) continue;
                linkedHashSet.clear();
                hashSet.clear();
                if (!this.listAxes(variableInfo.getCoordinateVariables(), linkedHashSet, hashSet)) {
                    this.listAxes(this.convention().namesOfAxisVariables(variableInfo), linkedHashSet, hashSet);
                }
                int namedElement2 = variableInfo.dimensions.length;
                while (--namedElement2 >= 0) {
                    namedElement = variableInfo.dimensions[namedElement2];
                    if (!hashSet.add((DimensionInfo)namedElement)) continue;
                    List list = (List)identityHashMap.get(namedElement);
                    if (list == null) continue block6;
                    linkedHashSet.addAll(list);
                }
                NamedElement namedElement3 = new GridInfo(variableInfo.dimensions, linkedHashSet.toArray(new VariableInfo[linkedHashSet.size()]));
                namedElement = linkedHashMap.putIfAbsent((GridInfo)namedElement3, (GridInfo)namedElement3);
                if (namedElement != null) {
                    namedElement3 = namedElement;
                }
                variableInfo.grid = namedElement3;
            }
            this.gridGeometries = linkedHashMap.values().toArray(new Grid[linkedHashMap.size()]);
        }
        return this.gridGeometries;
    }

    @Override
    public void close() throws IOException {
        this.input.channel.close();
    }

    @Override
    public void addAttributesTo(TreeTable.Node node) {
        for (VariableInfo variableInfo : this.variables) {
            TreeTable.Node node2 = node.newChild();
            node2.setValue(TableColumn.NAME, (Object)variableInfo.getName());
            variableInfo.addAttributesTo(node2);
        }
        VariableInfo.addAttributesTo(node, this.attributeNames, this.attributeMap);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SIS driver: \u201c").append(this.getFilename()).append('\u201d');
        if (!this.input.channel.isOpen()) {
            stringBuilder.append(" (closed)");
        }
        return stringBuilder.toString();
    }
}

