/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.Body;
import com.github.sommeri.less4j.core.ast.BodyOwner;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class BodiesStorage {
    private List<Body> originalBodies = new ArrayList<Body>();
    private List<ASTCssNode> keepChilds = new ArrayList<ASTCssNode>();
    private List<BodyOwner<Body>> originalBodiesParents = new ArrayList<BodyOwner<Body>>();

    BodiesStorage() {
    }

    private void store(Body body, BodyOwner<Body> parent) {
        this.originalBodies.add(body);
        this.originalBodiesParents.add(parent);
    }

    private void replaceBody(BodyOwner<Body> bodyOwner, Body body) {
        bodyOwner.getBody().setParent(null);
        bodyOwner.setBody(body);
        body.setParent((ASTCssNode)((Object)bodyOwner));
    }

    public Body storeAndReplaceBySingleMemberClone(Body body, ASTCssNode keepChild) {
        Body newBody = body.emptyClone();
        BodyOwner bodyOwner = (BodyOwner)((Object)body.getParent());
        this.store(body, bodyOwner);
        this.replaceBody(bodyOwner, newBody);
        this.keepChilds.add(keepChild);
        this.moveToBody(newBody, keepChild);
        return newBody;
    }

    private void moveToBody(Body body, ASTCssNode child) {
        if (child != null) {
            if (!body.getChilds().contains(child)) {
                body.addMember(child);
            }
            child.setParent(body);
        }
    }

    public void restore() {
        Iterator<Body> bodiesIterator = this.originalBodies.iterator();
        Iterator<BodyOwner<Body>> parentsIterator = this.originalBodiesParents.iterator();
        Iterator<ASTCssNode> keepChildsIterator = this.keepChilds.iterator();
        while (bodiesIterator.hasNext()) {
            BodyOwner<Body> bodyOwner = parentsIterator.next();
            Body body = bodiesIterator.next();
            ASTCssNode keepChild = keepChildsIterator.next();
            bodyOwner.getBody().setParent(null);
            this.replaceBody(bodyOwner, body);
            this.moveToBody(body, keepChild);
        }
    }
}

