/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.storage;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addons.gamification.entities.domain.configuration.DomainEntity;
import org.exoplatform.addons.gamification.service.dto.configuration.DomainDTO;
import org.exoplatform.addons.gamification.service.dto.configuration.DomainFilter;
import org.exoplatform.addons.gamification.service.mapper.DomainMapper;
import org.exoplatform.addons.gamification.storage.dao.DomainDAO;
import org.exoplatform.addons.gamification.storage.dao.RuleDAO;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;

public class DomainStorage {
    private static final String FILE_API_NAME_SPACE = "gamification";
    private final DomainDAO domainDAO;
    private final RuleDAO ruleDAO;
    private final FileService fileService;
    private final UploadService uploadService;

    public DomainStorage(DomainDAO domainDAO, FileService fileService, UploadService uploadService, RuleDAO ruleDAO) {
        this.domainDAO = domainDAO;
        this.fileService = fileService;
        this.uploadService = uploadService;
        this.ruleDAO = ruleDAO;
    }

    public DomainDTO saveDomain(DomainDTO domainDTO) {
        DomainEntity domainEntity = DomainMapper.domainDTOToDomainEntity(domainDTO);
        if (StringUtils.isNotBlank((CharSequence)domainDTO.getCoverUploadId())) {
            Long coverFileId = this.saveDomainCover(domainDTO.getCoverUploadId());
            domainEntity.setCoverFileId(coverFileId);
        }
        if (CollectionUtils.isEmpty(domainEntity.getOwners())) {
            domainEntity.setOwners(new HashSet<Long>());
        } else {
            domainEntity.setOwners(new HashSet<Long>(domainEntity.getOwners()));
        }
        if (domainEntity.getId() == null || domainEntity.getId() == 0L) {
            domainEntity.setId(null);
            domainEntity = (DomainEntity)this.domainDAO.create(domainEntity);
        } else {
            domainEntity = (DomainEntity)this.domainDAO.update(domainEntity);
        }
        return DomainMapper.domainEntityToDomainDTO(domainEntity);
    }

    public DomainDTO getDomainByTitle(String domainTitle) {
        return DomainMapper.domainEntityToDomainDTO(this.domainDAO.getDomainByTitle(domainTitle));
    }

    public List<Long> findHighestBudgetDomainIdsBySpacesIds(List<Long> spacesIds, int offset, int limit) {
        if (CollectionUtils.isNotEmpty(spacesIds)) {
            return this.ruleDAO.findHighestBudgetDomainIdsBySpacesIds(spacesIds, offset, limit);
        }
        return this.ruleDAO.findHighestBudgetDomainIds(offset, limit);
    }

    public List<Long> getDomainsByFilter(DomainFilter filter, int offset, int limit) {
        return this.domainDAO.getDomainsByFilter(offset, limit, filter);
    }

    public int countDomains(DomainFilter domainFilter) {
        return this.domainDAO.countAllDomains(domainFilter);
    }

    public List<DomainDTO> getEnabledDomains() {
        return DomainMapper.domainsToDomainDTOs(this.domainDAO.getEnabledDomains());
    }

    public DomainDTO getDomainById(Long id) {
        DomainEntity domainEntity = (DomainEntity)this.domainDAO.find(id);
        return DomainMapper.domainEntityToDomainDTO(domainEntity);
    }

    public void clearCache() {
    }

    private Long saveDomainCover(String uploadId) {
        if (uploadId == null || uploadId.isBlank()) {
            throw new IllegalArgumentException("uploadId is mandatory");
        }
        UploadResource uploadResource = this.uploadService.getUploadResource(uploadId);
        if (uploadResource == null) {
            throw new IllegalStateException("Can't find uploaded resource with id : " + uploadId);
        }
        try {
            FileInputStream inputStream = new FileInputStream(uploadResource.getStoreLocation());
            FileItem fileItem = new FileItem(null, uploadResource.getFileName(), uploadResource.getMimeType(), FILE_API_NAME_SPACE, (long)uploadResource.getUploadedSize(), new Date(), IdentityConstants.SYSTEM, false, (InputStream)inputStream);
            fileItem = this.fileService.writeFile(fileItem);
            Long l = fileItem != null && fileItem.getFileInfo() != null ? fileItem.getFileInfo().getId() : null;
            return l;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while saving domain cover file", e);
        }
        finally {
            this.uploadService.removeUploadResource(uploadResource.getUploadId());
        }
    }
}

