/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.template.metamodel;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.lang.model.element.Element;
import juzu.impl.common.JSON;
import juzu.impl.common.Name;
import juzu.impl.common.Path;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.compiler.MessageCode;
import juzu.impl.metamodel.Key;
import juzu.impl.metamodel.MetaModelEvent;
import juzu.impl.metamodel.MetaModelObject;
import juzu.impl.plugin.template.metamodel.AbstractContainerMetaModel;
import juzu.impl.plugin.template.metamodel.ElementMetaModel;
import juzu.impl.plugin.template.metamodel.Template;
import juzu.impl.plugin.template.metamodel.TemplateRefMetaModel;
import juzu.impl.template.spi.TemplateModel;

public class TemplateMetaModel
extends TemplateRefMetaModel
implements Template {
    public static final MessageCode CANNOT_WRITE_TEMPLATE_STUB = new MessageCode("CANNOT_WRITE_TEMPLATE_STUB", "The template stub %1$s cannot be written");
    public static final MessageCode CANNOT_WRITE_TEMPLATE_CLASS = new MessageCode("CANNOT_WRITE_TEMPLATE_CLASS", "The template class %1$s cannot be written");
    public static final MessageCode CANNOT_WRITE_APPLICATION = new MessageCode("CANNOT_WRITE_APPLICATION", "The application %1$s cannot be written");
    public static final MessageCode TEMPLATE_NOT_RESOLVED = new MessageCode("TEMPLATE_NOT_RESOLVED", "The template %1$s cannot be resolved");
    public static final MessageCode TEMPLATE_SYNTAX_ERROR = new MessageCode("TEMPLATE_SYNTAX_ERROR", "Template syntax error");
    public static final MessageCode TEMPLATE_VALIDATION_ERROR = new MessageCode("TEMPLATE_VALIDATION_ERROR", "Template validation error");
    public static final MessageCode TEMPLATE_ILLEGAL_PATH = new MessageCode("TEMPLATE_ILLEGAL_PATH", "The reference to the template %1$s is malformed");
    public static final MessageCode CANNOT_WRITE_TEMPLATE_SCRIPT = new MessageCode("CANNOT_WRITE_TEMPLATE_SCRIPT", "The template script %1$s cannot be written");
    public static final MessageCode TEMPLATE_CYCLE = new MessageCode("TEMPLATE_CYCLE", "Detected a template cycle when registering %1$s conflicting with %2$s");
    public static final MessageCode CONTROLLER_NOT_RESOLVED = new MessageCode("CONTROLLER_NOT_RESOLVED", "Controller %1$s not found in template %2$s at (%3$s,%4$s)");
    public static final MessageCode UNKNOWN_TAG = new MessageCode("UNKNOWN_TAG", "Tag %1$ does not exists");
    public static final Key<TemplateMetaModel> KEY = Key.of(TemplateMetaModel.class);
    final AbstractContainerMetaModel container;
    final Path.Absolute path;
    TemplateModel<?> templateModel;

    public TemplateMetaModel(AbstractContainerMetaModel container, Path.Absolute path) {
        this.path = path;
        this.container = container;
        this.templateModel = null;
    }

    public AbstractContainerMetaModel getContainer() {
        return this.container;
    }

    public Element[] getReferencingElements() {
        LinkedHashSet<Name> types = new LinkedHashSet<Name>();
        for (ElementMetaModel ref : this.getElementReferences()) {
            ElementHandle.Field handle = ref.getElement();
            types.add(handle.getTypeName());
        }
        Element[] elements = new Element[types.size()];
        int index = 0;
        for (Name type : types) {
            elements[index++] = this.container.application.getProcessingContext().getTypeElement(type);
        }
        return elements;
    }

    public Collection<ElementMetaModel> getElementReferences() {
        Collection<TemplateRefMetaModel> refs = this.getReferences();
        Iterator<TemplateRefMetaModel> i = refs.iterator();
        while (i.hasNext()) {
            if (!(i.next() instanceof TemplateMetaModel)) continue;
            i.remove();
        }
        return refs;
    }

    public Collection<TemplateRefMetaModel> getReferences() {
        HashSet<TemplateRefMetaModel> refs = new HashSet<TemplateRefMetaModel>();
        this.buildReferences(refs);
        return refs;
    }

    private void buildReferences(HashSet<TemplateRefMetaModel> refs) {
        for (MetaModelObject parent : this.getParents()) {
            TemplateRefMetaModel parentRef;
            if (!(parent instanceof TemplateRefMetaModel) || refs.contains(parentRef = (TemplateRefMetaModel)parent)) continue;
            refs.add(parentRef);
            if (!(parentRef instanceof TemplateMetaModel)) continue;
            TemplateMetaModel parentTemplate = (TemplateMetaModel)parentRef;
            parentTemplate.buildReferences(refs);
        }
    }

    public Path.Absolute getPath() {
        return this.path;
    }

    @Override
    public void add(TemplateMetaModel template) {
        Key<TemplateMetaModel> key = Key.of(template.getPath(), TemplateMetaModel.class);
        if (this.getChild(key) == null) {
            this.addChild(key, template);
        }
    }

    @Override
    public JSON toJSON() {
        JSON json = new JSON();
        json.set("path", this.path.getCanonical());
        return json;
    }

    @Override
    protected void postConstruct() {
        this.container.templates.put(this.path, this);
        this.queue(MetaModelEvent.createAdded(this));
    }

    @Override
    protected void preRemove() {
        ElementHandle.Package handle = this.container.application.getHandle();
        this.container.templates.remove(this.path);
        this.queue(MetaModelEvent.createRemoved(this, handle));
    }
}

