/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.service.setting.badge.model;

import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;

public class BadgeConfig
extends BaseComponentPlugin {
    private String title;
    private String description;
    private String icon;
    private int neededScore;
    private boolean enable;

    public BadgeConfig(InitParams params) throws Exception {
        ValueParam enableParam;
        ValueParam neededScoreParam;
        ValueParam iconParam;
        ValueParam titleParam = params.getValueParam("badge-title");
        if (titleParam == null) {
            throw new ConfigurationException("No 'badge-title' parameter found");
        }
        this.title = titleParam.getValue();
        ValueParam descriptionParam = params.getValueParam("badge-description");
        if (descriptionParam != null) {
            this.description = descriptionParam.getValue();
        }
        if ((iconParam = params.getValueParam("badge-icon")) != null) {
            this.icon = iconParam.getValue();
        }
        if ((neededScoreParam = params.getValueParam("badge-neededScore")) != null) {
            this.neededScore = Integer.parseInt(neededScoreParam.getValue());
        }
        if ((enableParam = params.getValueParam("badge-enable")) != null) {
            this.enable = Boolean.parseBoolean(enableParam.getValue());
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIcon() {
        return this.icon;
    }

    public int getNeededScore() {
        return this.neededScore;
    }

    public boolean isEnable() {
        return this.enable;
    }
}

