/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.trigger.change;

import com.datical.liquibase.ext.license.LicenseValidationChange;
import com.datical.liquibase.ext.storedlogic.trigger.change.RenameTriggerStatement;
import com.datical.liquibase.ext.util.RefactoringUtils;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.CockroachDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="renameTrigger", description="Rename Trigger", priority=1)
public class RenameTriggerChange
extends LicenseValidationChange {
    private String catalogName;
    private String schemaName;
    private String oldTriggerName;
    private String newTriggerName;
    private String tableName;

    @Override
    public ValidationErrors validate(Database database) {
        if (database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof AbstractDb2Database || database instanceof PostgresDatabase && !(database instanceof CockroachDatabase)) {
            return super.validate(database);
        }
        return RefactoringUtils.createValidationErrors(database, this);
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/pro";
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String string) {
        this.catalogName = string;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = string;
    }

    public String getOldTriggerName() {
        return this.oldTriggerName;
    }

    public void setOldTriggerName(String string) {
        this.oldTriggerName = string;
    }

    public String getNewTriggerName() {
        return this.newTriggerName;
    }

    public void setNewTriggerName(String string) {
        this.newTriggerName = string;
    }

    @Override
    public String getConfirmationMessage() {
        return "Trigger has been renamed";
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    @Override
    protected Change[] createInverses() {
        RenameTriggerChange renameTriggerChange = new RenameTriggerChange();
        renameTriggerChange.setSchemaName(this.getSchemaName());
        renameTriggerChange.setOldTriggerName(this.getNewTriggerName());
        renameTriggerChange.setNewTriggerName(this.getOldTriggerName());
        renameTriggerChange.setTableName(this.getTableName());
        return new Change[]{renameTriggerChange};
    }

    @Override
    public SqlStatement[] generateStatements(Database object) {
        object = new RenameTriggerStatement(this.getCatalogName(), this.getSchemaName(), this.getOldTriggerName(), this.getNewTriggerName());
        ((RenameTriggerStatement)object).setTableName(this.getTableName());
        return new SqlStatement[]{object};
    }
}

