/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import opennlp.tools.dictionary.serializer.Attributes;
import opennlp.tools.dictionary.serializer.DictionaryEntryPersistor;
import opennlp.tools.dictionary.serializer.Entry;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.StringList;

public class DetokenizationDictionary {
    private final Map<String, Operation> operationTable = new HashMap<String, Operation>();

    public DetokenizationDictionary(String[] tokens, Operation[] operations) {
        if (tokens.length != operations.length) {
            throw new IllegalArgumentException("tokens and ops must have the same length: tokens=" + tokens.length + ", operations=" + operations.length + "!");
        }
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            Operation operation = operations[i];
            if (token == null) {
                throw new IllegalArgumentException("token at index " + i + " must not be null!");
            }
            if (operation == null) {
                throw new IllegalArgumentException("operation at index " + i + " must not be null!");
            }
            this.operationTable.put(token, operation);
        }
    }

    public DetokenizationDictionary(InputStream in) throws IOException {
        this.init(in);
    }

    public DetokenizationDictionary(File file) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            this.init(in);
        }
    }

    private void init(InputStream in) throws IOException {
        DictionaryEntryPersistor.create(in, entry -> {
            String operationString = entry.getAttributes().getValue("operation");
            StringList word = entry.getTokens();
            if (word.size() != 1) {
                throw new InvalidFormatException("Each entry must have exactly one token! " + word);
            }
            Operation operation = Operation.parse(operationString);
            if (operation == null) {
                throw new InvalidFormatException("Unknown operation type: " + operationString);
            }
            this.operationTable.put(word.getToken(0), operation);
        });
    }

    Operation getOperation(String token) {
        return this.operationTable.get(token);
    }

    public void serialize(OutputStream out) throws IOException {
        Iterator<Entry> entries = new Iterator<Entry>(){
            Iterator<String> iterator;
            {
                this.iterator = DetokenizationDictionary.this.operationTable.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Entry next() {
                String token = this.iterator.next();
                Attributes attributes = new Attributes();
                attributes.setValue("operation", DetokenizationDictionary.this.getOperation(token).toString());
                return new Entry(new StringList(token), attributes);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        DictionaryEntryPersistor.serialize(out, entries, false);
    }

    public static enum Operation {
        MOVE_RIGHT,
        MOVE_LEFT,
        MOVE_BOTH,
        RIGHT_LEFT_MATCHING;


        public static Operation parse(String operation) {
            if (MOVE_RIGHT.toString().equals(operation)) {
                return MOVE_RIGHT;
            }
            if (MOVE_LEFT.toString().equals(operation)) {
                return MOVE_LEFT;
            }
            if (MOVE_BOTH.toString().equals(operation)) {
                return MOVE_BOTH;
            }
            if (RIGHT_LEFT_MATCHING.toString().equals(operation)) {
                return RIGHT_LEFT_MATCHING;
            }
            return null;
        }
    }
}

