/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.api;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.localization.LocalizationFilter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.rest.ApplicationContext;
import org.exoplatform.services.rest.impl.ApplicationContextImpl;
import org.exoplatform.services.rest.impl.provider.JsonEntityProvider;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.binding.model.GroupSpaceBinding;
import org.exoplatform.social.core.binding.model.GroupSpaceBindingOperationReport;
import org.exoplatform.social.core.binding.spi.GroupSpaceBindingService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.processor.I18NActivityProcessor;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.favorite.FavoriteService;
import org.exoplatform.social.metadata.favorite.model.Favorite;
import org.exoplatform.social.notification.service.SpaceWebNotificationService;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.entity.ActivityEntity;
import org.exoplatform.social.rest.entity.BaseEntity;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.CommentEntity;
import org.exoplatform.social.rest.entity.DataEntity;
import org.exoplatform.social.rest.entity.ExperienceEntity;
import org.exoplatform.social.rest.entity.GroupNodeEntity;
import org.exoplatform.social.rest.entity.GroupSpaceBindingEntity;
import org.exoplatform.social.rest.entity.GroupSpaceBindingOperationReportEntity;
import org.exoplatform.social.rest.entity.IMEntity;
import org.exoplatform.social.rest.entity.IdentityEntity;
import org.exoplatform.social.rest.entity.LinkEntity;
import org.exoplatform.social.rest.entity.MetadataItemEntity;
import org.exoplatform.social.rest.entity.PhoneEntity;
import org.exoplatform.social.rest.entity.ProfileEntity;
import org.exoplatform.social.rest.entity.RelationshipEntity;
import org.exoplatform.social.rest.entity.SpaceEntity;
import org.exoplatform.social.rest.entity.SpaceMembershipEntity;
import org.exoplatform.social.rest.entity.URLEntity;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.ws.frameworks.json.JsonHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonDefaultHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonParserImpl;
import org.exoplatform.ws.frameworks.json.impl.ObjectBuilder;
import org.exoplatform.ws.frameworks.json.value.JsonValue;

public class EntityBuilder {
    private static final int DEFAULT_LIKERS_LIMIT = 4;
    private static final String GROUP_BINDING_DATE_FORMAT = "dd/MM/yyyy HH:mm:ss";
    private static final Log LOG = ExoLogger.getLogger(EntityBuilder.class);
    public static final String GROUP_SPACE_BINDING_REPORT_OPERATIONS_TYPE = "groupSpaceBindingReportOperations";
    public static final String USERS_TYPE = "users";
    public static final String USERS_RELATIONSHIP_TYPE = "usersRelationships";
    public static final String USER_ACTIVITY_TYPE = "user";
    public static final String IDENTITIES_TYPE = "identities";
    public static final String SPACES_TYPE = "spaces";
    public static final String SPACES_MEMBERSHIP_TYPE = "spacesMemberships";
    public static final String SPACE_ACTIVITY_TYPE = "space";
    public static final String ACTIVITIES_TYPE = "activities";
    public static final String ACTIVITY_IDS_TYPE = "activityIds";
    public static final String COMMENTS_TYPE = "comments";
    public static final String COMMENTS_PREVIEW_TYPE = "commentsPreview";
    public static final int COMMENTS_PREVIEW_LIMIT = 2;
    public static final String LIKES_TYPE = "likes";
    public static final String LIKES_COUNT_TYPE = "likesCount";
    public static final String COMMENTS_COUNT_TYPE = "commentsCount";
    public static final String KEY = "key";
    public static final String VALUE = "value";
    private static final String NEXT_ACTION = "next";
    private static final String PREV_ACTION = "prev";
    private static final String FIRST_ACTION = "first";
    private static final String LAST_ACTION = "last";
    private static final String LINK = "Link";
    public static final String GROUP_SPACE_BINDING_TYPE = "groupSpaceBindings";
    public static final String ORGANIZATION_GROUP_TYPE = "childGroups";
    public static final String MANAGER_MEMBERSHIP = "manager";
    public static final String REDACTOR_MEMBERSHIP = "redactor";
    public static final String PUBLISHER_MEMBERSHIP = "publisher";
    public static final CacheControl NO_CACHE_CC = new CacheControl();
    private static final JsonEntityProvider JSON_ENTITY_PROVIDER = new JsonEntityProvider();
    private static SpaceService spaceService;
    private static OrganizationService organizationService;
    private static RelationshipManager relationshipManager;
    private static IdentityManager identityManager;
    private static ActivityManager activityManager;

    private EntityBuilder() {
    }

    public static IdentityEntity buildEntityIdentity(Identity identity, String restPath, String expand) {
        IdentityEntity identityEntity = new IdentityEntity(identity.getId());
        identityEntity.setHref(RestUtils.getRestUrl(IDENTITIES_TYPE, identity.getId(), restPath));
        identityEntity.setProviderId(identity.getProviderId());
        identityEntity.setGlobalId(identity.getGlobalId());
        identityEntity.setRemoteId(identity.getRemoteId());
        identityEntity.setDeleted(identity.isDeleted());
        if (SPACE_ACTIVITY_TYPE.equals(identity.getProviderId())) {
            ConversationState conversationState = ConversationState.getCurrent();
            String currentUserId = conversationState.getIdentity().getUserId();
            Space space = EntityBuilder.getSpaceService().getSpaceByPrettyName(identity.getRemoteId());
            identityEntity.setSpace(EntityBuilder.buildEntityFromSpace(space, currentUserId, restPath, expand));
        } else {
            identityEntity.setProfile(EntityBuilder.buildEntityProfile(identity.getProfile(), restPath, expand));
        }
        EntityBuilder.updateCachedEtagValue(EntityBuilder.getEtagValue(identity.getId()));
        return identityEntity;
    }

    public static IdentityEntity buildEntityIdentity(String userName, String restPath, String expand) {
        IdentityManager identityManager = EntityBuilder.getIdentityManager();
        Identity userIdentity = identityManager.getOrCreateIdentity("organization", userName);
        return EntityBuilder.buildEntityIdentity(userIdentity, restPath, expand);
    }

    public static ProfileEntity buildEntityProfile(Space space, Profile profile, String path, String expand) {
        List<Object> expandAttributes;
        ProfileEntity entity = EntityBuilder.buildEntityProfile(profile, path, expand);
        String userId = profile.getIdentity().getRemoteId();
        entity.setIsManager(spaceService.isManager(space, userId));
        entity.setIsSpaceRedactor(spaceService.isRedactor(space, userId));
        entity.setIsSpacePublisher(spaceService.isPublisher(space, userId));
        entity.setIsMember(spaceService.isMember(space, userId));
        entity.setIsInvited(spaceService.isInvitedUser(space, userId));
        entity.setIsPending(spaceService.isPendingUser(space, userId));
        String[] expandArray = StringUtils.split((String)expand, (String)",");
        List<Object> list = expandAttributes = expandArray == null ? Collections.emptyList() : Arrays.asList(expandArray);
        if (expandAttributes.contains("binding") || expandAttributes.contains("all")) {
            GroupSpaceBindingService spaceBindingService = (GroupSpaceBindingService)CommonsUtils.getService(GroupSpaceBindingService.class);
            entity.setIsGroupBound(spaceBindingService.countUserBindings(space.getId(), userId) > 0L);
        }
        return entity;
    }

    public static ProfileEntity buildEntityProfile(Profile profile, String restPath, String expand) {
        Identity currentUserIdentity;
        String currentUser;
        ConversationState conversationState;
        List<Object> expandAttributes;
        ProfileEntity userEntity = new ProfileEntity(profile.getId());
        userEntity.setHref(RestUtils.getRestUrl(USERS_TYPE, profile.getIdentity().getRemoteId(), restPath));
        userEntity.setIdentity(RestUtils.getRestUrl(IDENTITIES_TYPE, profile.getIdentity().getId(), restPath));
        userEntity.setUsername(profile.getIdentity().getRemoteId());
        userEntity.setFirstname((String)profile.getProperty("firstName"));
        userEntity.setLastname((String)profile.getProperty("lastName"));
        userEntity.setFullname(profile.getFullName());
        userEntity.setGender(profile.getGender());
        userEntity.setPosition(profile.getPosition());
        userEntity.setEmail(profile.getEmail());
        userEntity.setAboutMe((String)profile.getProperty("aboutMe"));
        userEntity.setAvatar(profile.getAvatarUrl());
        userEntity.setBanner(profile.getBannerUrl());
        if (profile.getProperty("enrollmentDate") != null) {
            userEntity.setEnrollmentDate(profile.getProperty("enrollmentDate").toString());
        }
        if (profile.getProperty("synchronizedDate") != null) {
            userEntity.setSynchronizedDate((String)profile.getProperty("synchronizedDate"));
        }
        try {
            OrganizationService organizationService = EntityBuilder.getOrganizationService();
            User user = organizationService.getUserHandler().findUserByName(userEntity.getUsername(), UserStatus.ANY);
            if (user != null) {
                userEntity.setIsInternal(user.isInternalStore());
                if (user.getCreatedDate() != null) {
                    userEntity.setCreatedDate(String.valueOf(user.getCreatedDate().getTime()));
                }
                if (user.getLastLoginTime() != null && !user.getCreatedDate().equals(user.getLastLoginTime())) {
                    userEntity.setLastLoginTime(String.valueOf(user.getLastLoginTime().getTime()));
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Error when searching user {}", new Object[]{userEntity.getUsername(), e});
        }
        EntityBuilder.buildPhoneEntities(profile, userEntity);
        EntityBuilder.buildImEntities(profile, userEntity);
        EntityBuilder.buildUrlEntities(profile, userEntity);
        EntityBuilder.buildExperienceEntities(profile, userEntity);
        userEntity.setDeleted(profile.getIdentity().isDeleted());
        userEntity.setEnabled(profile.getIdentity().isEnable());
        if (profile.getProperty("external") != null) {
            userEntity.setIsExternal((String)profile.getProperty("external"));
        }
        userEntity.setCompany((String)profile.getProperty("company"));
        userEntity.setLocation((String)profile.getProperty("location"));
        userEntity.setDepartment((String)profile.getProperty("department"));
        userEntity.setTeam((String)profile.getProperty("team"));
        userEntity.setProfession((String)profile.getProperty("profession"));
        userEntity.setCountry((String)profile.getProperty("country"));
        userEntity.setCity((String)profile.getProperty("city"));
        String[] expandArray = StringUtils.split((String)expand, (String)",");
        List<Object> list = expandAttributes = expandArray == null ? Collections.emptyList() : Arrays.asList(expandArray);
        if (expandAttributes.contains("connectionsCount")) {
            ListAccess connections = EntityBuilder.getRelationshipManager().getConnections(profile.getIdentity());
            try {
                userEntity.setConnectionsCount(String.valueOf(connections.getSize()));
            }
            catch (Exception e) {
                LOG.warn((Object)"Error while getting connections count of user", (Throwable)e);
            }
        }
        if (expandAttributes.contains("spacesCount")) {
            ListAccess spaces = EntityBuilder.getSpaceService().getMemberSpaces(profile.getIdentity().getRemoteId());
            try {
                userEntity.setSpacesCount(String.valueOf(spaces.getSize()));
            }
            catch (Exception e) {
                LOG.warn((Object)"Error while getting spaces count of user", (Throwable)e);
            }
        }
        if (expandAttributes.contains("connectionsInCommonCount") && (conversationState = ConversationState.getCurrent()) != null) {
            currentUser = conversationState.getIdentity().getUserId();
            if (!StringUtils.equals((CharSequence)profile.getIdentity().getRemoteId(), (CharSequence)currentUser)) {
                currentUserIdentity = EntityBuilder.getIdentityManager().getOrCreateIdentity("organization", currentUser);
                try {
                    userEntity.setConnectionsInCommonCount(String.valueOf(EntityBuilder.getRelationshipManager().getConnectionsInCommonCount(currentUserIdentity, profile.getIdentity())));
                }
                catch (Exception e) {
                    LOG.warn((Object)"Error while getting spaces count of user", (Throwable)e);
                }
            }
        }
        if (expandAttributes.contains("relationshipStatus") && (conversationState = ConversationState.getCurrent()) != null) {
            currentUser = conversationState.getIdentity().getUserId();
            currentUserIdentity = EntityBuilder.getIdentityManager().getOrCreateIdentity("organization", currentUser);
            try {
                Relationship relationship = EntityBuilder.getRelationshipManager().get(currentUserIdentity, profile.getIdentity());
                if (relationship != null) {
                    Relationship.Type status = relationship.getStatus();
                    if (status == Relationship.Type.PENDING) {
                        Relationship.Type relationshipStatus = StringUtils.equals((CharSequence)relationship.getSender().getRemoteId(), (CharSequence)currentUser) ? Relationship.Type.OUTGOING : Relationship.Type.INCOMING;
                        userEntity.setRelationshipStatus(relationshipStatus.name());
                    } else {
                        userEntity.setRelationshipStatus(relationship.getStatus().name());
                    }
                }
            }
            catch (Exception e) {
                LOG.warn((Object)"Error while getting spaces count of user", (Throwable)e);
            }
        }
        return userEntity;
    }

    public static void buildPhoneEntities(Profile profile, ProfileEntity userEntity) {
        List phones = profile.getPhones();
        if (phones != null && !phones.isEmpty()) {
            ArrayList<PhoneEntity> phoneEntities = new ArrayList<PhoneEntity>();
            for (Map phone : phones) {
                phoneEntities.add(new PhoneEntity((String)phone.get(KEY), (String)phone.get(VALUE)));
            }
            userEntity.setPhones(phoneEntities);
        }
    }

    public static void buildImEntities(Profile profile, ProfileEntity userEntity) {
        List ims = (List)profile.getProperty("ims");
        if (ims != null && !ims.isEmpty()) {
            ArrayList<IMEntity> imEntities = new ArrayList<IMEntity>();
            for (Map im : ims) {
                imEntities.add(new IMEntity((String)im.get(KEY), (String)im.get(VALUE)));
            }
            userEntity.setIms(imEntities);
        }
    }

    public static void buildUrlEntities(Profile profile, ProfileEntity userEntity) {
        List urls = (List)profile.getProperty("urls");
        if (urls != null && !urls.isEmpty()) {
            ArrayList<URLEntity> urlEntities = new ArrayList<URLEntity>();
            for (Map url : urls) {
                urlEntities.add(new URLEntity((String)url.get(VALUE)));
            }
            userEntity.setUrls(urlEntities);
        }
    }

    public static void buildExperienceEntities(Profile profile, ProfileEntity userEntity) {
        List experiences = (List)profile.getProperty("experiences");
        if (experiences != null && !experiences.isEmpty()) {
            ArrayList<ExperienceEntity> experienceEntities = new ArrayList<ExperienceEntity>();
            for (Map experience : experiences) {
                String id = (String)experience.get("id");
                String company = (String)experience.get("company");
                String description = (String)experience.get("description");
                String position = (String)experience.get("position");
                String skills = (String)experience.get("skills");
                Boolean isCurrent = (Boolean)experience.get("isCurrent");
                String startDate = (String)experience.get("startDate");
                String endDate = (String)experience.get("endDate");
                if ((isCurrent == null || !isCurrent.booleanValue()) && StringUtils.isBlank((CharSequence)endDate)) {
                    isCurrent = true;
                }
                experienceEntities.add(new ExperienceEntity(id, company, description, position, skills, isCurrent, startDate, endDate));
            }
            userEntity.setExperiences(experienceEntities);
        }
    }

    public static ProfileEntity buildEntityProfile(String userName, String restPath, String expand) {
        IdentityManager identityManager = EntityBuilder.getIdentityManager();
        Identity userIdentity = identityManager.getOrCreateIdentity("organization", userName);
        return EntityBuilder.buildEntityProfile(userIdentity.getProfile(), restPath, expand);
    }

    public static List<DataEntity> buildEntityProfiles(String[] userNames, String restPath, String expand) {
        if (userNames == null || userNames.length == 0) {
            return new ArrayList<DataEntity>();
        }
        ArrayList<DataEntity> userEntities = new ArrayList<DataEntity>();
        for (int i = 0; i < userNames.length; ++i) {
            userEntities.add(EntityBuilder.buildEntityProfile(userNames[i], restPath, expand).getDataEntity());
        }
        return userEntities;
    }

    public static SpaceEntity buildEntityFromSpace(Space space, String userId, String restPath, String expand) {
        SpaceEntity spaceEntity = new SpaceEntity(space.getId());
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            boolean isManager;
            IdentityManager identityManager = EntityBuilder.getIdentityManager();
            SpaceService spaceService = EntityBuilder.getSpaceService();
            GroupSpaceBindingService groupSpaceBindingService = (GroupSpaceBindingService)CommonsUtils.getService(GroupSpaceBindingService.class);
            if (ArrayUtils.contains((Object[])space.getMembers(), (Object)userId) || spaceService.isSuperManager(userId)) {
                Identity userIdentity;
                spaceEntity.setHref(RestUtils.getRestUrl(SPACES_TYPE, space.getId(), restPath));
                Identity spaceIdentity = identityManager.getOrCreateIdentity(SPACE_ACTIVITY_TYPE, space.getPrettyName());
                List<Object> expandFields = StringUtils.isBlank((CharSequence)expand) ? Collections.emptyList() : Arrays.asList(expand.split(","));
                LinkEntity identity = expandFields.contains("identity") ? new LinkEntity(EntityBuilder.buildEntityIdentity(spaceIdentity, restPath, null)) : new LinkEntity(RestUtils.getRestUrl(IDENTITIES_TYPE, spaceIdentity.getId(), restPath));
                spaceEntity.setIdentity(identity);
                spaceEntity.setTotalBoundUsers(groupSpaceBindingService.countBoundUsers(space.getId()));
                spaceEntity.setApplications(EntityBuilder.getSpaceApplications(space));
                boolean hasBindings = groupSpaceBindingService.isBoundSpace(space.getId());
                spaceEntity.setHasBindings(hasBindings);
                if (hasBindings) {
                    spaceEntity.setIsUserBound(groupSpaceBindingService.countUserBindings(space.getId(), userId) > 0L);
                }
                LinkEntity managers = expandFields.contains("managers") ? new LinkEntity(EntityBuilder.buildEntityProfiles(space.getManagers(), restPath, expand)) : new LinkEntity(Util.getMembersSpaceRestUrl(space.getId(), MANAGER_MEMBERSHIP, restPath));
                spaceEntity.setManagers(managers);
                LinkEntity redactors = expandFields.contains("redactors") ? new LinkEntity(EntityBuilder.buildEntityProfiles(space.getRedactors(), restPath, expand)) : new LinkEntity(Util.getMembersSpaceRestUrl(space.getId(), REDACTOR_MEMBERSHIP, restPath));
                spaceEntity.setRedactors(redactors);
                LinkEntity publishers = expandFields.contains("publishers") ? new LinkEntity(EntityBuilder.buildEntityProfiles(space.getPublishers(), restPath, expand)) : new LinkEntity(Util.getMembersSpaceRestUrl(space.getId(), PUBLISHER_MEMBERSHIP, restPath));
                spaceEntity.setPublishers(publishers);
                LinkEntity members = expandFields.contains("members") ? new LinkEntity(EntityBuilder.buildEntityProfiles(space.getMembers(), restPath, expand)) : new LinkEntity(Util.getMembersSpaceRestUrl(space.getId(), null, restPath));
                spaceEntity.setMembers(members);
                if ("membersCount".equals(expand)) {
                    spaceEntity.setMembersCount(space.getMembers().length);
                }
                if (expandFields.contains("pending")) {
                    LinkEntity pending = new LinkEntity(EntityBuilder.buildEntityProfiles(space.getPendingUsers(), restPath, expand));
                    spaceEntity.setPending(pending);
                }
                if (expandFields.contains("favorite")) {
                    userIdentity = identityManager.getOrCreateUserIdentity(userId);
                    FavoriteService favoriteService = (FavoriteService)ExoContainerContext.getService(FavoriteService.class);
                    boolean isFavorite = favoriteService.isFavorite(new Favorite(SPACE_ACTIVITY_TYPE, space.getId(), null, Long.parseLong(userIdentity.getId())));
                    spaceEntity.setIsFavorite(String.valueOf(isFavorite));
                }
                if (expandFields.contains("unread")) {
                    userIdentity = identityManager.getOrCreateUserIdentity(userId);
                    SpaceWebNotificationService spaceWebNotificationService = (SpaceWebNotificationService)ExoContainerContext.getService(SpaceWebNotificationService.class);
                    Map unreadItems = spaceWebNotificationService.countUnreadItemsByApplication(Long.parseLong(userIdentity.getId()), Long.parseLong(space.getId()));
                    if (MapUtils.isNotEmpty((Map)unreadItems)) {
                        spaceEntity.setUnreadItems(unreadItems);
                    }
                }
            }
            boolean canEdit = (isManager = spaceService.isManager(space, userId)) || spaceService.isSuperManager(userId);
            spaceEntity.setIsPending(spaceService.isPendingUser(space, userId));
            spaceEntity.setIsInvited(spaceService.isInvitedUser(space, userId));
            spaceEntity.setIsMember(spaceService.isMember(space, userId));
            spaceEntity.setCanEdit(canEdit);
            spaceEntity.setIsManager(isManager);
            spaceEntity.setIsRedactor(spaceService.isRedactor(space, userId));
            spaceEntity.setIsPublisher(spaceService.isPublisher(space, userId));
        }
        spaceEntity.setDisplayName(space.getDisplayName());
        spaceEntity.setLastUpdatedTime(space.getLastUpdatedTime());
        spaceEntity.setCreatedTime(String.valueOf(space.getCreatedTime()));
        spaceEntity.setTemplate(space.getTemplate());
        spaceEntity.setPrettyName(space.getPrettyName());
        spaceEntity.setGroupId(space.getGroupId());
        spaceEntity.setDescription(StringEscapeUtils.unescapeHtml((String)space.getDescription()));
        spaceEntity.setUrl(LinkProvider.getSpaceUri((String)space.getPrettyName()));
        spaceEntity.setAvatarUrl(space.getAvatarUrl());
        spaceEntity.setBannerUrl(space.getBannerUrl());
        spaceEntity.setVisibility(space.getVisibility());
        spaceEntity.setSubscription(space.getRegistration());
        spaceEntity.setMembersCount(space.getMembers() == null ? 0 : space.getMembers().length);
        spaceEntity.setManagersCount(space.getManagers() == null ? 0 : space.getManagers().length);
        spaceEntity.setRedactorsCount(space.getRedactors() == null ? 0 : space.getRedactors().length);
        spaceEntity.setPublishersCount(space.getPublishers() == null ? 0 : space.getPublishers().length);
        return spaceEntity;
    }

    public static SpaceMembershipEntity buildEntityFromSpaceMembership(Space space, String userId, String type, String restPath, String expand) {
        EntityBuilder.updateCachedEtagValue(EntityBuilder.getEtagValue(type));
        String id = space.getPrettyName() + ":" + userId + ":" + type;
        SpaceMembershipEntity spaceMembership = new SpaceMembershipEntity(id);
        spaceMembership.setHref(RestUtils.getRestUrl(SPACES_MEMBERSHIP_TYPE, id, restPath));
        List<Object> expandFields = StringUtils.isBlank((CharSequence)expand) ? Collections.emptyList() : Arrays.asList(expand.split(","));
        LinkEntity userEntity = expandFields.contains(USERS_TYPE) ? new LinkEntity(EntityBuilder.buildEntityProfile(userId, restPath, expand)) : new LinkEntity(RestUtils.getRestUrl(USERS_TYPE, userId, restPath));
        spaceMembership.setDataUser(userEntity);
        LinkEntity spaceEntity = expandFields.contains(SPACES_TYPE) ? new LinkEntity(EntityBuilder.buildEntityProfile(userId, restPath, expand)) : new LinkEntity(RestUtils.getRestUrl(SPACES_TYPE, space.getId(), restPath));
        spaceMembership.setDataSpace(spaceEntity);
        spaceMembership.setRole(type);
        switch (type) {
            case "invited": {
                spaceMembership.setStatus("invited");
                break;
            }
            case "pending": {
                spaceMembership.setStatus("pending");
                break;
            }
            case "ignored": {
                spaceMembership.setStatus("ignored");
                break;
            }
            default: {
                spaceMembership.setStatus("approved");
            }
        }
        return spaceMembership;
    }

    public static ActivityEntity buildEntityFromActivity(ExoSocialActivity activity, Identity authentiatedUser, String restPath, String expand) {
        Map<String, List<MetadataItemEntity>> activityMetadatasToPublish;
        ExoSocialActivity originalActivity;
        String originalActivityId;
        LinkEntity commentLink;
        if (activity.isComment() || activity.getParentId() != null) {
            CommentEntity commentEntity = EntityBuilder.buildEntityFromComment(activity, authentiatedUser, restPath, expand, false);
            DataEntity as = EntityBuilder.getActivityStream(activityManager.getParentActivity(activity), restPath, authentiatedUser);
            commentEntity.setActivityStream(as);
            return commentEntity;
        }
        List<Object> expandFields = StringUtils.isBlank((CharSequence)expand) ? Collections.emptyList() : Arrays.asList(expand.split(","));
        if (activity.getTitleId() != null) {
            Locale userLocale = LocalizationFilter.getCurrentLocale();
            I18NActivityProcessor i18NActivityProcessor = (I18NActivityProcessor)ExoContainerContext.getService(I18NActivityProcessor.class);
            activity = i18NActivityProcessor.process(activity, userLocale);
        }
        Identity poster = EntityBuilder.getIdentityManager().getIdentity(activity.getPosterId());
        ActivityEntity activityEntity = new ActivityEntity(activity);
        activityEntity.setHref(RestUtils.getRestUrl(ACTIVITIES_TYPE, activity.getId(), restPath));
        LinkEntity identityLink = expandFields.contains("identity") ? new LinkEntity(EntityBuilder.buildEntityIdentity(poster, restPath, expand)) : new LinkEntity(RestUtils.getRestUrl(IDENTITIES_TYPE, activity.getPosterId(), restPath));
        activityEntity.setIdentity(identityLink);
        activityEntity.setOwner(EntityBuilder.getActivityOwner(poster, restPath, activity.getSpaceId()));
        activityEntity.setMentions(EntityBuilder.getActivityMentions(activity, restPath));
        activityEntity.setAttachments(new ArrayList<DataEntity>());
        boolean canEdit = EntityBuilder.getActivityManager().isActivityEditable(activity, ConversationState.getCurrent().getIdentity());
        activityEntity.setCanEdit(canEdit);
        boolean canDelete = EntityBuilder.getActivityManager().isActivityDeletable(activity, ConversationState.getCurrent().getIdentity());
        activityEntity.setCanDelete(canDelete);
        boolean canPin = activityManager.canPinActivity(activity, authentiatedUser);
        activityEntity.setCanPin(canPin);
        if (expandFields.contains(COMMENTS_TYPE)) {
            commentsEntity = EntityBuilder.buildEntityFromComment(activity, authentiatedUser, restPath, "", false, 0, 20);
            listAccess = activityManager.getCommentsWithListAccess(activity, true);
            commentLink = new LinkEntity(commentsEntity);
            activityEntity.setCommentsCount(listAccess.getSize());
        } else if (expandFields.contains(COMMENTS_PREVIEW_TYPE)) {
            commentsEntity = EntityBuilder.buildEntityFromComment(activity, authentiatedUser, restPath, expand, true, 0, 2);
            listAccess = activityManager.getCommentsWithListAccess(activity, true);
            commentLink = new LinkEntity(commentsEntity);
            activityEntity.setCommentsCount(listAccess.getSize());
        } else {
            commentLink = new LinkEntity(EntityBuilder.getCommentsActivityRestUrl(activity.getId(), restPath));
            activityEntity.setCommentsCount(activity.getCommentedIds() == null ? 0 : activity.getCommentedIds().length);
        }
        activityEntity.setComments(commentLink);
        if (expandFields.contains(LIKES_TYPE)) {
            List<DataEntity> likesEntity = EntityBuilder.buildEntityFromLike(activity, restPath, "", 0, 4);
            activityEntity.setLikes(new LinkEntity(likesEntity));
        } else {
            activityEntity.setLikes(new LinkEntity(EntityBuilder.getLikesActivityRestUrl(activity.getId(), restPath)));
        }
        activityEntity.setLikesCount(activity.getLikeIdentityIds() == null ? 0 : activity.getLikeIdentityIds().length);
        activityEntity.setHasLiked(ArrayUtils.contains((Object[])activity.getLikeIdentityIds(), (Object)authentiatedUser.getId()));
        activityEntity.setHasCommented(ArrayUtils.contains((Object[])activity.getCommentedIds(), (Object)authentiatedUser.getId()));
        activityEntity.setCreateDate(RestUtils.formatISO8601(new Date(activity.getPostedTime())));
        activityEntity.setUpdateDate(RestUtils.formatISO8601(activity.getUpdated()));
        activityEntity.setPinned(activity.isPinned());
        activityEntity.setPinDate(activity.getPinDate());
        activityEntity.setPinAuthorId(activity.getPinAuthorId());
        DataEntity as = EntityBuilder.getActivityStream(activity, restPath, authentiatedUser);
        activityEntity.setActivityStream(as);
        EntityBuilder.updateCachedLastModifiedValue(activity.getUpdated());
        if (expandFields.contains("shared") && activity.getTemplateParams() != null && activity.getTemplateParams().containsKey("originalActivityId") && StringUtils.isNotBlank((CharSequence)(originalActivityId = (String)activity.getTemplateParams().get("originalActivityId"))) && (originalActivity = EntityBuilder.getActivityManager().getActivity(originalActivityId)) != null) {
            ActivityEntity originalActivityEntity = EntityBuilder.buildEntityFromActivity(originalActivity, authentiatedUser, restPath, expand.replace("shared", ""));
            activityEntity.setOriginalActivity(originalActivityEntity.getDataEntity());
        }
        if (activity.getLinkedProcessedEntities() != null) {
            activityEntity.getDataEntity().putAll(activity.getLinkedProcessedEntities());
        }
        if (MapUtils.isNotEmpty(activityMetadatasToPublish = EntityBuilder.retrieveMetadataItems(activity, authentiatedUser))) {
            activityEntity.setMetadatas(activityMetadatasToPublish);
        }
        return activityEntity;
    }

    public static Map<String, List<MetadataItemEntity>> retrieveMetadataItems(ExoSocialActivity activity, Identity authentiatedUser) {
        Map activityMetadatas = activity.getMetadatas();
        if (MapUtils.isEmpty((Map)activityMetadatas)) {
            return null;
        }
        long authentiatedUserId = Long.parseLong(authentiatedUser.getId());
        Identity owner = EntityBuilder.getStreamOwnerIdentity(activity);
        long streamOwnerId = owner == null ? 0L : Long.parseLong(owner.getId());
        HashMap<String, List<MetadataItemEntity>> activityMetadatasToPublish = new HashMap<String, List<MetadataItemEntity>>();
        Set metadataEntries = activityMetadatas.entrySet();
        for (Map.Entry metadataEntry : metadataEntries) {
            List activityMetadataEntities;
            String metadataType = (String)metadataEntry.getKey();
            List metadataItems = (List)metadataEntry.getValue();
            if (!MapUtils.isNotEmpty((Map)activityMetadatas) || !CollectionUtils.isNotEmpty(activityMetadataEntities = metadataItems.stream().filter(metadataItem -> metadataItem.getMetadata().getAudienceId() == 0L || metadataItem.getMetadata().getAudienceId() == streamOwnerId || metadataItem.getMetadata().getAudienceId() == authentiatedUserId).map(metadataItem -> new MetadataItemEntity(metadataItem.getId(), metadataItem.getMetadata().getName(), metadataItem.getObjectType(), metadataItem.getObjectId(), metadataItem.getParentObjectId(), metadataItem.getCreatorId(), metadataItem.getMetadata().getAudienceId(), metadataItem.getProperties())).collect(Collectors.toList()))) continue;
            activityMetadatasToPublish.put(metadataType, activityMetadataEntities);
        }
        return activityMetadatasToPublish;
    }

    public static void buildActivityFromEntity(ActivityEntity model, ExoSocialActivity activity) {
        if (model.getTitle() != null && !model.getTitle().equals(activity.getTitle())) {
            activity.setTitle(model.getTitle());
        }
        if (model.getBody() != null && !model.getBody().equals(activity.getBody())) {
            activity.setBody(model.getBody());
        }
        if (StringUtils.isNotBlank((CharSequence)model.getType())) {
            activity.setType(model.getType());
        }
        DataEntity templateParams = model.getTemplateParams();
        EntityBuilder.buildActivityParamsFromEntity(activity, templateParams);
    }

    public static void buildActivityParamsFromEntity(ExoSocialActivity activity, Map<String, ?> templateParams) {
        HashMap currentTemplateParams;
        HashMap hashMap = currentTemplateParams = activity.getTemplateParams() == null ? new HashMap() : new HashMap(activity.getTemplateParams());
        if (templateParams != null) {
            templateParams.forEach((name, value) -> currentTemplateParams.put(name, (String)value));
        }
        for (Map.Entry entry : currentTemplateParams.entrySet()) {
            if (entry == null || !StringUtils.isBlank((CharSequence)((CharSequence)entry.getValue())) && !StringUtils.equals((CharSequence)((CharSequence)entry.getValue()), (CharSequence)"-")) continue;
            entry.setValue("");
        }
        activity.setTemplateParams(currentTemplateParams);
    }

    public static boolean expandSubComments(String expand) {
        if (StringUtils.isNotEmpty((CharSequence)expand)) {
            List<String> expandFields = Arrays.asList(expand.split(","));
            return expandFields.contains("subComments");
        }
        return false;
    }

    public static CommentEntity buildEntityFromComment(ExoSocialActivity comment, Identity authentiatedUser, String restPath, String expand, boolean isBuildList) {
        Identity poster = EntityBuilder.getIdentityManager().getIdentity(comment.getPosterId());
        if (comment.getTitleId() != null) {
            Locale userLocale = LocalizationFilter.getCurrentLocale();
            I18NActivityProcessor i18NActivityProcessor = (I18NActivityProcessor)ExoContainerContext.getService(I18NActivityProcessor.class);
            comment = i18NActivityProcessor.process(comment, userLocale);
        }
        CommentEntity commentEntity = new CommentEntity(comment);
        commentEntity.setHref(RestUtils.getRestUrl(ACTIVITIES_TYPE, comment.getId(), restPath));
        List<Object> expandFields = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)expand)) {
            expandFields = Arrays.asList(expand.split(","));
        }
        LinkEntity identityLink = expandFields.contains("identity") ? new LinkEntity(EntityBuilder.buildEntityIdentity(poster, restPath, null)) : new LinkEntity(RestUtils.getRestUrl(IDENTITIES_TYPE, comment.getPosterId(), restPath));
        commentEntity.setIdentity(identityLink);
        if (poster != null) {
            commentEntity.setPoster(poster.getRemoteId());
            commentEntity.setOwner(EntityBuilder.getActivityOwner(poster, restPath, activityManager.getParentActivity(comment).getSpaceId()));
        }
        if (comment.getBody() == null) {
            commentEntity.setBody(comment.getTitle());
        }
        commentEntity.setParentCommentId(comment.getParentCommentId());
        commentEntity.setMentions(EntityBuilder.getActivityMentions(comment, restPath));
        if (expandFields.contains(LIKES_TYPE)) {
            commentEntity.setLikes(new LinkEntity(EntityBuilder.buildEntityFromLike(comment, restPath, null, 0, 500)));
        } else {
            commentEntity.setLikes(new LinkEntity(RestUtils.getBaseRestUrl() + "/v1/social/comments/" + comment.getId() + "/likes"));
        }
        commentEntity.setCreateDate(RestUtils.formatISO8601(new Date(comment.getPostedTime())));
        commentEntity.setUpdateDate(RestUtils.formatISO8601(comment.getUpdated()));
        commentEntity.setActivity(RestUtils.getRestUrl(ACTIVITIES_TYPE, comment.getParentId(), restPath));
        commentEntity.setActivityId(comment.getParentId());
        boolean canEdit = EntityBuilder.getActivityManager().isActivityEditable(comment, ConversationState.getCurrent().getIdentity());
        commentEntity.setCanEdit(canEdit);
        boolean canDelete = EntityBuilder.getActivityManager().isActivityDeletable(comment, ConversationState.getCurrent().getIdentity());
        commentEntity.setCanDelete(canDelete);
        commentEntity.setLikesCount(comment.getLikeIdentityIds() == null ? 0 : comment.getLikeIdentityIds().length);
        commentEntity.setCommentsCount(comment.getCommentedIds() == null ? 0 : comment.getCommentedIds().length);
        commentEntity.setHasCommented(ArrayUtils.contains((Object[])comment.getCommentedIds(), (Object)authentiatedUser.getId()));
        commentEntity.setHasLiked(ArrayUtils.contains((Object[])comment.getLikeIdentityIds(), (Object)authentiatedUser.getId()));
        if (!isBuildList) {
            EntityBuilder.updateCachedLastModifiedValue(comment.getUpdated());
        }
        return commentEntity;
    }

    public static List<DataEntity> buildEntityFromComment(ExoSocialActivity activity, Identity authentiatedUser, String restPath, String expand, boolean sortDescending, int offset, int limit) {
        ArrayList<DataEntity> commentsEntity = new ArrayList<DataEntity>();
        boolean expandSubComments = EntityBuilder.expandSubComments(expand);
        RealtimeListAccess listAccess = EntityBuilder.getActivityManager().getCommentsWithListAccess(activity, expandSubComments, sortDescending);
        List comments = listAccess.loadAsList(offset, limit);
        if (expandSubComments) {
            for (ExoSocialActivity comment : comments) {
                if (!StringUtils.isBlank((CharSequence)comment.getParentCommentId())) continue;
                Set<String> commenters = comments.stream().filter(tmpComment -> StringUtils.equals((CharSequence)tmpComment.getParentCommentId(), (CharSequence)comment.getId())).map(ExoSocialActivity::getPosterId).collect(Collectors.toSet());
                comment.setCommentedIds(commenters.toArray(new String[commenters.size()]));
            }
        }
        for (ExoSocialActivity comment : comments) {
            CommentEntity commentInfo = EntityBuilder.buildEntityFromComment(comment, authentiatedUser, restPath, expand, true);
            commentsEntity.add(commentInfo.getDataEntity());
        }
        return commentsEntity;
    }

    public static List<DataEntity> buildEntityFromLike(ExoSocialActivity activity, String restPath, String expand, int offset, int limit) {
        int toIndex;
        ArrayList<DataEntity> likesEntity = new ArrayList<DataEntity>();
        List<String> likerIds = Arrays.asList(activity.getLikeIdentityIds());
        int startIndex = offset;
        if (offset >= likerIds.size()) {
            int n = startIndex = likerIds.isEmpty() ? 0 : likerIds.size() - 1;
        }
        if ((toIndex = startIndex + limit) > likerIds.size()) {
            toIndex = likerIds.size();
        }
        if (toIndex > startIndex) {
            likerIds = likerIds.subList(startIndex, toIndex);
        }
        IdentityManager identityManager = EntityBuilder.getIdentityManager();
        for (String likerId : likerIds) {
            ProfileEntity likerInfo = EntityBuilder.buildEntityProfile(identityManager.getIdentity(likerId).getRemoteId(), restPath, expand);
            likesEntity.add(likerInfo.getDataEntity());
        }
        return likesEntity;
    }

    public static RelationshipEntity buildEntityRelationship(Relationship relationship, String restPath, String expand, boolean isSymetric) {
        if (relationship == null) {
            return new RelationshipEntity();
        }
        RelationshipEntity relationshipEntity = new RelationshipEntity(relationship.getId());
        relationshipEntity.setHref(RestUtils.getRestUrl(USERS_RELATIONSHIP_TYPE, relationship.getId(), restPath));
        List<Object> expandFields = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)expand)) {
            expandFields = Arrays.asList(expand.split(","));
        }
        LinkEntity sender = expandFields.contains("sender") ? new LinkEntity(EntityBuilder.buildEntityProfile(relationship.getSender().getProfile(), restPath, expand)) : new LinkEntity(RestUtils.getRestUrl(USERS_TYPE, relationship.getSender().getRemoteId(), restPath));
        relationshipEntity.setDataSender(sender);
        LinkEntity receiver = expandFields.contains("receiver") ? new LinkEntity(EntityBuilder.buildEntityProfile(relationship.getReceiver().getProfile(), restPath, expand)) : new LinkEntity(RestUtils.getRestUrl(USERS_TYPE, relationship.getReceiver().getRemoteId(), restPath));
        relationshipEntity.setDataReceiver(receiver);
        relationshipEntity.setStatus(relationship.getStatus().name());
        if (isSymetric) {
            relationshipEntity.setSymetric(relationship.isSymetric());
        }
        EntityBuilder.updateCachedEtagValue(EntityBuilder.getEtagValue(relationship.getId()));
        return relationshipEntity;
    }

    public static List<DataEntity> buildRelationshipEntities(List<Relationship> relationships, UriInfo uriInfo) {
        ArrayList<DataEntity> infos = new ArrayList<DataEntity>();
        for (Relationship relationship : relationships) {
            infos.add(EntityBuilder.buildEntityRelationship(relationship, uriInfo.getPath(), RestUtils.getQueryParam(uriInfo, "expand"), true).getDataEntity());
        }
        return infos;
    }

    public static SpaceMembershipEntity createSpaceMembershipForIgnoredStatus(Space space, String userId, String type, String restPath, String expand) {
        String id = space.getPrettyName() + ":" + userId + ":" + type;
        SpaceMembershipEntity spaceMembership = new SpaceMembershipEntity(id);
        spaceMembership.setHref(RestUtils.getRestUrl(SPACES_MEMBERSHIP_TYPE, id, restPath));
        List<Object> expandFields = StringUtils.isBlank((CharSequence)expand) ? Collections.emptyList() : Arrays.asList(expand.split(","));
        LinkEntity userEntity = expandFields.contains(USERS_TYPE) ? new LinkEntity(EntityBuilder.buildEntityProfile(userId, restPath, expand)) : new LinkEntity(RestUtils.getRestUrl(USERS_TYPE, userId, restPath));
        spaceMembership.setDataUser(userEntity);
        LinkEntity spaceEntity = expandFields.contains(SPACES_TYPE) ? new LinkEntity(EntityBuilder.buildEntityProfile(userId, restPath, expand)) : new LinkEntity(RestUtils.getRestUrl(SPACES_TYPE, space.getId(), restPath));
        spaceMembership.setDataSpace(spaceEntity);
        spaceMembership.setRole(type);
        spaceMembership.setStatus("ignored");
        return spaceMembership;
    }

    private static DataEntity getActivityOwner(Identity owner, String restPath, String spaceId) {
        BaseEntity mentionEntity = new BaseEntity(owner.getId());
        mentionEntity.setHref(RestUtils.getRestUrl(EntityBuilder.getIdentityType(owner), EntityBuilder.getIdentityId(owner), restPath));
        if (spaceId != null && !spaceId.isEmpty()) {
            SpaceService spaceService = EntityBuilder.getSpaceService();
            Space space = spaceService.getSpaceById(spaceId);
            boolean isMember = spaceService.isMember(space, owner.getRemoteId());
            mentionEntity.setProperty("isMember", isMember);
        }
        return mentionEntity.getDataEntity();
    }

    private static String getIdentityType(Identity owner) {
        return "organization".equals(owner.getProviderId()) ? USERS_TYPE : SPACES_TYPE;
    }

    private static String getIdentityId(Identity identity) {
        if ("organization".equals(identity.getProviderId())) {
            return identity.getRemoteId();
        }
        String spacePrettyName = identity.getRemoteId();
        SpaceService spaceService = EntityBuilder.getSpaceService();
        Space space = spaceService.getSpaceByPrettyName(spacePrettyName);
        return space.getId();
    }

    private static List<DataEntity> getActivityMentions(ExoSocialActivity activity, String restPath) {
        ArrayList<DataEntity> mentions = new ArrayList<DataEntity>();
        IdentityManager identityManager = EntityBuilder.getIdentityManager();
        for (String mentionner : activity.getMentionedIds()) {
            String mentionnerId = mentionner.split("@")[0];
            mentions.add(EntityBuilder.getActivityOwner(identityManager.getIdentity(mentionnerId), restPath, null));
        }
        return mentions;
    }

    private static DataEntity getActivityStream(ExoSocialActivity activity, String restPath, Identity authentiatedUser) {
        if (activity.isComment() || activity.getParentId() != null) {
            activity = activityManager.getParentActivity(activity);
        }
        DataEntity as = new DataEntity();
        Identity owner = EntityBuilder.getStreamOwnerIdentity(activity);
        if (owner != null) {
            if (owner.isUser()) {
                as.put("type", USER_ACTIVITY_TYPE);
            } else if (owner.isSpace()) {
                as.put("type", SPACE_ACTIVITY_TYPE);
                Space space = EntityBuilder.getSpaceService().getSpaceByPrettyName(owner.getRemoteId());
                as.put(SPACE_ACTIVITY_TYPE, EntityBuilder.buildEntityFromSpace(space, authentiatedUser.getRemoteId(), restPath, "favorite"));
            }
            as.put("id", owner.getRemoteId());
        }
        return as;
    }

    private static Identity getStreamOwnerIdentity(ExoSocialActivity activity) {
        String streamOwner = activity.getStreamOwner();
        Identity owner = EntityBuilder.getIdentityManager().getOrCreateUserIdentity(streamOwner);
        if (owner == null) {
            owner = identityManager.getOrCreateSpaceIdentity(activity.getStreamOwner());
        }
        return owner;
    }

    private static List<DataEntity> getSpaceApplications(Space space) {
        ArrayList<DataEntity> spaceApplications = new ArrayList<DataEntity>();
        String installedApps = space.getApp();
        if (installedApps != null) {
            String[] appStatuses;
            for (String appStatus : appStatuses = installedApps.split(",")) {
                String[] apps = appStatus.split(":");
                BaseEntity app = new BaseEntity(apps[0]);
                app.setProperty("displayName", apps.length > 1 ? apps[1] : "");
                spaceApplications.add(app.getDataEntity());
            }
        }
        return spaceApplications;
    }

    private static void updateCachedEtagValue(int etagValue) {
        ApplicationContext ac = ApplicationContextImpl.getCurrent();
        Map properties = ac.getProperties();
        ConcurrentHashMap props = new ConcurrentHashMap(properties);
        if (props.containsKey("ETag")) {
            props.remove("ETag");
        }
        if (props.containsKey("updateDate")) {
            props.remove("updateDate");
        }
        ac.setProperty("ETag", String.valueOf(etagValue));
        ApplicationContextImpl.setCurrent((ApplicationContext)ac);
    }

    private static void updateCachedLastModifiedValue(Date lastModifiedDate) {
        ApplicationContext ac = ApplicationContextImpl.getCurrent();
        Map properties = ac.getProperties();
        ConcurrentHashMap props = new ConcurrentHashMap(properties);
        if (props.containsKey("updateDate")) {
            props.remove("updateDate");
        }
        if (props.containsKey("ETag")) {
            props.remove("ETag");
        }
        ac.setProperty("updateDate", String.valueOf(lastModifiedDate.getTime()));
        ApplicationContextImpl.setCurrent((ApplicationContext)ac);
    }

    private static int getEtagValue(String ... properties) {
        int prime = 31;
        int result = 0;
        for (String prop : properties) {
            if (prop == null) continue;
            result = 31 * result + prop.hashCode();
        }
        return result;
    }

    public static String getCommentsActivityRestUrl(String activityId, String restPath) {
        return new StringBuffer(RestUtils.getRestUrl(ACTIVITIES_TYPE, activityId, restPath)).append("/").append(COMMENTS_TYPE).toString();
    }

    public static String getLikesActivityRestUrl(String activityId, String restPath) {
        return new StringBuffer(RestUtils.getRestUrl(ACTIVITIES_TYPE, activityId, restPath)).append("/").append(LIKES_TYPE).toString();
    }

    public static Response.ResponseBuilder getResponseBuilder(Object entity, UriInfo uriInfo, MediaType mediaType, Response.Status status) {
        if (entity instanceof BaseEntity) {
            entity = ((BaseEntity)entity).getDataEntity();
        }
        Response.ResponseBuilder responseBuilder = Response.created((URI)uriInfo.getAbsolutePath()).entity(entity).type(mediaType.toString() + "; charset=utf-8").status(status).cacheControl(NO_CACHE_CC);
        if (EntityBuilder.hasPaging(entity)) {
            responseBuilder.header(LINK, EntityBuilder.buildLinkForHeader(entity, uriInfo.getAbsolutePath().toString()));
        }
        return responseBuilder;
    }

    public static Response getResponse(Object entity, UriInfo uriInfo, MediaType mediaType, Response.Status status) {
        Response.ResponseBuilder responseBuilder = EntityBuilder.getResponseBuilder(entity, uriInfo, mediaType, status);
        return responseBuilder.build();
    }

    private static boolean hasPaging(Object entity) {
        if (!(entity instanceof CollectionEntity)) {
            return false;
        }
        CollectionEntity rc = (CollectionEntity)entity;
        int size = rc.getSize();
        int offset = rc.getOffset();
        int limit = rc.getLimit();
        return size > 0 && limit != 0 && offset <= size && size > limit;
    }

    public static Object buildLinkForHeader(Object entity, String requestPath) {
        CollectionEntity rc = (CollectionEntity)entity;
        int size = rc.getSize();
        int offset = rc.getOffset();
        int limit = rc.getLimit();
        StringBuilder linkHeader = new StringBuilder();
        if (EntityBuilder.hasNext(size, offset, limit)) {
            int nextOS = offset + limit;
            linkHeader.append(EntityBuilder.createLinkHeader(requestPath, nextOS, limit, NEXT_ACTION));
        }
        if (EntityBuilder.hasPrevious(offset, limit)) {
            int preOS = offset - limit;
            EntityBuilder.appendCommaIfNecessary(linkHeader);
            linkHeader.append(EntityBuilder.createLinkHeader(requestPath, preOS, limit, PREV_ACTION));
        }
        if (EntityBuilder.hasFirst(offset, limit)) {
            EntityBuilder.appendCommaIfNecessary(linkHeader);
            linkHeader.append(EntityBuilder.createLinkHeader(requestPath, 0, limit, FIRST_ACTION));
        }
        if (EntityBuilder.hasLast(size, offset, limit)) {
            int pages = (int)Math.ceil((double)size / (double)limit);
            int lastOS = (pages - 1) * limit;
            EntityBuilder.appendCommaIfNecessary(linkHeader);
            linkHeader.append(EntityBuilder.createLinkHeader(requestPath, lastOS, limit, LAST_ACTION));
        }
        return linkHeader.toString();
    }

    private static boolean hasNext(int size, int offset, int limit) {
        return size > offset + limit;
    }

    private static boolean hasPrevious(int offset, int limit) {
        if (offset == 0) {
            return false;
        }
        return offset >= limit;
    }

    private static boolean hasFirst(int offset, int limit) {
        return EntityBuilder.hasPrevious(offset, limit);
    }

    private static boolean hasLast(int size, int offset, int limit) {
        if (offset + limit == size) {
            return false;
        }
        return EntityBuilder.hasNext(size, offset, limit);
    }

    private static void appendCommaIfNecessary(StringBuilder linkHeader) {
        if (linkHeader.length() > 0) {
            linkHeader.append(", ");
        }
    }

    private static String createLinkHeader(String uri, int offset, int limit, String rel) {
        return "<" + uri + "?offset=" + offset + "&limit=" + limit + ">; rel=\"" + rel + "\"";
    }

    public static GroupSpaceBindingEntity buildEntityFromGroupSpaceBinding(GroupSpaceBinding binding) {
        GroupSpaceBindingEntity groupSpaceBindingEntity = new GroupSpaceBindingEntity();
        groupSpaceBindingEntity.setId(Long.toString(binding.getId()));
        groupSpaceBindingEntity.setSpaceId(binding.getSpaceId());
        groupSpaceBindingEntity.setGroup(binding.getGroup());
        return groupSpaceBindingEntity;
    }

    public static GroupNodeEntity buildEntityFromGroup(Group group) {
        GroupNodeEntity groupNodeEntity = new GroupNodeEntity();
        groupNodeEntity.setId(group.getId());
        String groupName = group.getLabel() != null ? group.getLabel() : group.getGroupName();
        groupNodeEntity.setGroupName(groupName);
        String parentId = group.getParentId() == null ? "root" : group.getParentId();
        groupNodeEntity.setParentId(parentId);
        groupNodeEntity.setBound(false);
        groupNodeEntity.setChildGroupNodesEntities(new ArrayList<DataEntity>());
        return groupNodeEntity;
    }

    public static GroupNodeEntity buildEntityFromGroupId(String group) {
        GroupNodeEntity groupNodeEntity = new GroupNodeEntity();
        groupNodeEntity.setId(group);
        groupNodeEntity.setGroupName(group);
        groupNodeEntity.setParentId("");
        groupNodeEntity.setChildGroupNodesEntities(new ArrayList<DataEntity>());
        return groupNodeEntity;
    }

    public static GroupSpaceBindingOperationReportEntity buildEntityFromGroupSpaceBindingOperationReport(GroupSpaceBindingOperationReport bindingOperationReport) {
        GroupSpaceBindingOperationReportEntity operationReportEntity = new GroupSpaceBindingOperationReportEntity();
        operationReportEntity.setOperationType(bindingOperationReport.getAction());
        operationReportEntity.setBindingId(Long.toString(bindingOperationReport.getGroupSpaceBindingId()));
        operationReportEntity.setAddedUsersCount(Long.toString(bindingOperationReport.getAddedUsers()));
        operationReportEntity.setRemovedUsersCount(Long.toString(bindingOperationReport.getRemovedUsers()));
        Date startDate = bindingOperationReport.getStartDate();
        Date endDate = bindingOperationReport.getEndDate();
        operationReportEntity.setStartDate(startDate != null ? RestUtils.formatISO8601(startDate) : "null");
        operationReportEntity.setEndDate(endDate != null ? RestUtils.formatISO8601(endDate) : "null");
        return operationReportEntity;
    }

    public static final <T> T fromJsonString(String value, Class<T> resultClass) {
        try {
            if (StringUtils.isBlank((CharSequence)value)) {
                return null;
            }
            JsonDefaultHandler jsonDefaultHandler = new JsonDefaultHandler();
            new JsonParserImpl().parse((InputStream)new ByteArrayInputStream(value.getBytes()), (JsonHandler)jsonDefaultHandler);
            return (T)ObjectBuilder.createObject(resultClass, (JsonValue)jsonDefaultHandler.getJsonObject());
        }
        catch (JsonException e) {
            throw new IllegalStateException("Error creating object from string : " + value, e);
        }
    }

    public static String toJsonString(Object object) {
        if (object == null) {
            return "{}";
        }
        try {
            ByteArrayOutputStream entityStream = new ByteArrayOutputStream();
            JSON_ENTITY_PROVIDER.writeTo(object, object.getClass(), object.getClass(), null, MediaType.APPLICATION_JSON_TYPE, null, (OutputStream)entityStream);
            return entityStream.toString(Charset.defaultCharset().name());
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to transform object " + object, e);
        }
    }

    public static ActivityManager getActivityManager() {
        if (activityManager == null) {
            activityManager = (ActivityManager)ExoContainerContext.getService(ActivityManager.class);
        }
        return activityManager;
    }

    public static IdentityManager getIdentityManager() {
        if (identityManager == null) {
            identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        }
        return identityManager;
    }

    public static SpaceService getSpaceService() {
        if (spaceService == null) {
            spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        }
        return spaceService;
    }

    public static OrganizationService getOrganizationService() {
        if (organizationService == null) {
            organizationService = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
        }
        return organizationService;
    }

    public static RelationshipManager getRelationshipManager() {
        if (relationshipManager == null) {
            relationshipManager = (RelationshipManager)CommonsUtils.getService(RelationshipManager.class);
        }
        return relationshipManager;
    }

    static {
        NO_CACHE_CC.setNoCache(true);
        NO_CACHE_CC.setNoStore(true);
    }
}

