/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.model.reward;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.HashSet;
import java.util.Set;
import org.exoplatform.wallet.model.reward.RewardPeriodType;
import org.exoplatform.wallet.model.reward.RewardPluginSettings;

public class RewardSettings
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -8650247964730374760L;
    private RewardPeriodType periodType = RewardPeriodType.DEFAULT;
    private String timeZone = ZoneId.systemDefault().getId();
    private Set<RewardPluginSettings> pluginSettings;

    public ZoneId zoneId() {
        return ZoneId.of(this.timeZone);
    }

    public RewardSettings clone() {
        try {
            return (RewardSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            Set clonedPluginSettings = this.pluginSettings == null ? null : (Set)new HashSet<RewardPluginSettings>(this.pluginSettings).clone();
            return new RewardSettings(this.periodType, this.timeZone, clonedPluginSettings);
        }
    }

    public RewardPeriodType getPeriodType() {
        return this.periodType;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public Set<RewardPluginSettings> getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPeriodType(RewardPeriodType periodType) {
        this.periodType = periodType;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public void setPluginSettings(Set<RewardPluginSettings> pluginSettings) {
        this.pluginSettings = pluginSettings;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RewardSettings)) {
            return false;
        }
        RewardSettings other = (RewardSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RewardPeriodType this$periodType = this.getPeriodType();
        RewardPeriodType other$periodType = other.getPeriodType();
        if (this$periodType == null ? other$periodType != null : !((Object)((Object)this$periodType)).equals((Object)other$periodType)) {
            return false;
        }
        String this$timeZone = this.getTimeZone();
        String other$timeZone = other.getTimeZone();
        if (this$timeZone == null ? other$timeZone != null : !this$timeZone.equals(other$timeZone)) {
            return false;
        }
        Set<RewardPluginSettings> this$pluginSettings = this.getPluginSettings();
        Set<RewardPluginSettings> other$pluginSettings = other.getPluginSettings();
        return !(this$pluginSettings == null ? other$pluginSettings != null : !((Object)this$pluginSettings).equals(other$pluginSettings));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RewardSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RewardPeriodType $periodType = this.getPeriodType();
        result = result * 59 + ($periodType == null ? 43 : ((Object)((Object)$periodType)).hashCode());
        String $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : $timeZone.hashCode());
        Set<RewardPluginSettings> $pluginSettings = this.getPluginSettings();
        result = result * 59 + ($pluginSettings == null ? 43 : ((Object)$pluginSettings).hashCode());
        return result;
    }

    public String toString() {
        return "RewardSettings(periodType=" + this.getPeriodType() + ", timeZone=" + this.getTimeZone() + ", pluginSettings=" + this.getPluginSettings() + ")";
    }

    public RewardSettings() {
    }

    public RewardSettings(RewardPeriodType periodType, String timeZone, Set<RewardPluginSettings> pluginSettings) {
        this.periodType = periodType;
        this.timeZone = timeZone;
        this.pluginSettings = pluginSettings;
    }
}

