/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.gamification.github.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.gamification.github.services.GithubHooksManagement;
import org.exoplatform.gamification.github.utils.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;

@Path(value="/gamification/connectors/github/")
public class GithubWebHookRest
implements ResourceContainer {
    private static final String PULL_REQUEST_REVIEW_NODE_NAME = "review";
    private static final String PULL_REQUEST_REVIEW_EVENT_NAME = "pull_request_review";
    private static final String PULL_REQUEST_REVIEW_COMMENT_EVENT_NAME = "pull_request_review_comment";
    private static final String PUSH_EVENT_NAME = "push";
    private static final String GITHUB_USERNAME = "login";
    private static final String PULL_REQUEST_EVENT_NAME = "pull_request";
    private static final Log LOG = ExoLogger.getLogger(GithubWebHookRest.class);
    private GithubHooksManagement githubHooksManagement;

    public GithubWebHookRest(GithubHooksManagement githubHooksManagement) {
        this.githubHooksManagement = githubHooksManagement;
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="webhooks")
    public Response githubEvent(@HeaderParam(value="x-github-event") String event, @HeaderParam(value="x-hub-signature") String signature, String obj) {
        if (Utils.verifySignature(obj, signature, this.githubHooksManagement.getSecret())) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode infoNode = objectMapper.readTree(obj);
                String ruleTitle = "";
                String senderId = "";
                String receiverId = "";
                String object = "";
                String githubId = "";
                switch (event) {
                    case "push": {
                        Identity socialIdentity;
                        ruleTitle = "pushCode";
                        githubId = infoNode.get("pusher").get("name").textValue();
                        senderId = this.githubHooksManagement.getUserByGithubId(githubId);
                        if (senderId == null || (socialIdentity = this.getUserSocialId(senderId)) == null) break;
                        receiverId = senderId;
                        object = infoNode.get("head_commit").get("url").textValue();
                        this.githubHooksManagement.broadcastGithubEvent(ruleTitle, senderId, receiverId, object);
                        break;
                    }
                    case "pull_request": {
                        Identity socialIdentity;
                        githubId = infoNode.get("sender").get(GITHUB_USERNAME).textValue();
                        senderId = this.githubHooksManagement.getUserByGithubId(githubId);
                        if (!infoNode.get("action").textValue().equals("opened")) break;
                        ruleTitle = "creatPullRequest";
                        if (senderId == null || (socialIdentity = this.getUserSocialId(senderId)) == null) break;
                        receiverId = senderId;
                        object = infoNode.get(PULL_REQUEST_EVENT_NAME).get("html_url").textValue();
                        this.githubHooksManagement.broadcastGithubEvent(ruleTitle, senderId, receiverId, object);
                        break;
                    }
                    case "pull_request_review_comment": {
                        Identity socialIdentity;
                        ruleTitle = "commentPullRequest";
                        githubId = infoNode.get("comment").get("user").get(GITHUB_USERNAME).textValue();
                        senderId = this.githubHooksManagement.getUserByGithubId(githubId);
                        if (senderId == null || (socialIdentity = this.getUserSocialId(senderId)) == null) break;
                        receiverId = senderId;
                        object = infoNode.get("comment").get("_links").get("html").get("href").textValue();
                        this.githubHooksManagement.broadcastGithubEvent(ruleTitle, senderId, receiverId, object);
                        break;
                    }
                    case "pull_request_review": {
                        Identity socialIdentity;
                        ruleTitle = "reviewPullRequest";
                        githubId = infoNode.get(PULL_REQUEST_REVIEW_NODE_NAME).get("user").get(GITHUB_USERNAME).textValue();
                        senderId = this.githubHooksManagement.getUserByGithubId(githubId);
                        if (senderId == null || (socialIdentity = this.getUserSocialId(senderId)) == null) break;
                        receiverId = senderId;
                        object = infoNode.get(PULL_REQUEST_REVIEW_NODE_NAME).get("html_url").textValue();
                        if (!infoNode.get(PULL_REQUEST_REVIEW_NODE_NAME).get("state").textValue().equals("commented")) {
                            this.githubHooksManagement.broadcastGithubEvent(ruleTitle, senderId, receiverId, object);
                        }
                        if (!infoNode.get(PULL_REQUEST_REVIEW_NODE_NAME).get("state").textValue().equals("approved")) break;
                        receiverId = this.githubHooksManagement.getUserByGithubId(infoNode.get(PULL_REQUEST_EVENT_NAME).get("user").get(GITHUB_USERNAME).textValue());
                        ruleTitle = "pullRequestValidated";
                        this.githubHooksManagement.broadcastGithubEvent(ruleTitle, receiverId, senderId, object);
                        break;
                    }
                }
                return Response.ok().build();
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
            }
        }
        LOG.warn((Object)"Github hook Rest invoked with wrong secret key");
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    public Identity getUserSocialId(String userName) {
        IdentityManager identityManager = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
        return identityManager.getOrCreateUserIdentity(userName);
    }
}

