/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.NewPortalConfig;
import org.exoplatform.portal.config.NewPortalConfigListener;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.description.DescriptionService;
import org.exoplatform.portal.mop.importer.ImportMode;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NavigationState;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageService;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserPortalContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.picocontainer.Startable;

public class UserPortalConfigService
implements Startable {
    private static final Scope HOME_PAGE_URI_PREFERENCE_SCOPE = Scope.PORTAL.id("HOME");
    private static final String HOME_PAGE_URI_PREFERENCE_KEY = "HOME_PAGE_URI";
    public static final String DEFAULT_GLOBAL_PORTAL = "global";
    public static final String DEFAULT_GROUP_SITE_TEMPLATE = "group";
    public static final String DEFAULT_USER_SITE_TEMPLATE = "user";
    DataStorage storage_;
    UserACL userACL_;
    OrganizationService orgService_;
    private SettingService settingService;
    private NewPortalConfigListener newPortalConfigListener_;
    final NavigationService navService;
    final DescriptionService descriptionService;
    final PageService pageService;
    boolean createUserPortal;
    boolean destroyUserPortal;
    String globalPortal_;
    String defaultGroupSiteTemplate;
    String defaultUserSiteTemplate;
    private final ImportMode defaultImportMode;
    private PortalConfig defaultPortalConfig;
    private Log log = ExoLogger.getLogger((String)"Portal:UserPortalConfigService");
    private static final UserPortalContext NULL_CONTEXT = new UserPortalContext(){

        @Override
        public ResourceBundle getBundle(UserNavigation navigation) {
            return null;
        }

        @Override
        public Locale getUserLocale() {
            return Locale.ENGLISH;
        }
    };

    public UserPortalConfigService(UserACL userACL, DataStorage storage, OrganizationService orgService, NavigationService navService, DescriptionService descriptionService, PageService pageService, SettingService settingService, InitParams params) throws Exception {
        ValueParam createUserPortalParam = params == null ? null : params.getValueParam("create.user.portal");
        boolean createUserPortal = createUserPortalParam == null || createUserPortalParam.getValue().toLowerCase().trim().equals("true");
        ValueParam destroyUserPortalParam = params == null ? null : params.getValueParam("destroy.user.portal");
        boolean destroyUserPortal = destroyUserPortalParam == null || destroyUserPortalParam.getValue().toLowerCase().trim().equals("true");
        ValueParam defaultImportModeParam = params == null ? null : params.getValueParam("default.import.mode");
        ImportMode defaultImportMode = defaultImportModeParam == null ? ImportMode.CONSERVE : ImportMode.valueOf((String)defaultImportModeParam.getValue().toUpperCase().trim());
        ValueParam globalPortalParam = params == null ? null : params.getValueParam("global.portal");
        this.globalPortal_ = globalPortalParam == null ? DEFAULT_GLOBAL_PORTAL : globalPortalParam.getValue();
        ValueParam defaultGroupSiteTemplateParam = params == null ? null : params.getValueParam("default.groupSite.template");
        String defaultGroupSiteTemplate = defaultGroupSiteTemplateParam == null ? DEFAULT_GROUP_SITE_TEMPLATE : defaultGroupSiteTemplateParam.getValue();
        ValueParam defaultUserSiteTemplateParam = params == null ? null : params.getValueParam("default.userSite.template");
        String defaultUserSiteTemplate = defaultUserSiteTemplateParam == null ? DEFAULT_USER_SITE_TEMPLATE : defaultUserSiteTemplateParam.getValue();
        this.storage_ = storage;
        this.orgService_ = orgService;
        this.settingService = settingService;
        this.userACL_ = userACL;
        this.navService = navService;
        this.pageService = pageService;
        this.descriptionService = descriptionService;
        this.createUserPortal = createUserPortal;
        this.destroyUserPortal = destroyUserPortal;
        this.defaultImportMode = defaultImportMode;
        this.defaultGroupSiteTemplate = defaultGroupSiteTemplate;
        this.defaultUserSiteTemplate = defaultUserSiteTemplate;
    }

    public PageService getPageService() {
        return this.pageService;
    }

    public DataStorage getDataStorage() {
        return this.storage_;
    }

    public ImportMode getDefaultImportMode() {
        return this.defaultImportMode;
    }

    public boolean getCreateUserPortal() {
        return this.createUserPortal;
    }

    public void setCreateUserPortal(boolean createUserPortal) {
        this.createUserPortal = createUserPortal;
    }

    public boolean getDestroyUserPortal() {
        return this.destroyUserPortal;
    }

    public void setDestroyUserPortal(boolean destroyUserPortal) {
        this.destroyUserPortal = destroyUserPortal;
    }

    public String getDefaultGroupSiteTemplate() {
        return this.defaultGroupSiteTemplate;
    }

    public void setDefaultGroupSiteTemplate(String defaultGroupSiteTemplate) {
        this.defaultGroupSiteTemplate = defaultGroupSiteTemplate;
    }

    public String getDefaultUserSiteTemplate() {
        return this.defaultUserSiteTemplate;
    }

    public void setDefaultUserSiteTemplate(String defaultUserSiteTemplate) {
        this.defaultUserSiteTemplate = defaultUserSiteTemplate;
    }

    public NavigationService getNavigationService() {
        return this.navService;
    }

    public DescriptionService getDescriptionService() {
        return this.descriptionService;
    }

    public UserACL getUserACL() {
        return this.userACL_;
    }

    public OrganizationService getOrganizationService() {
        return this.orgService_;
    }

    @Deprecated
    public UserPortalConfig getUserPortalConfig(String portalName, String accessUser) throws Exception {
        return this.getUserPortalConfig(portalName, accessUser, NULL_CONTEXT);
    }

    public UserPortalConfig getUserPortalConfig(String portalName, String accessUser, UserPortalContext userPortalContext) throws Exception {
        PortalConfig portal = this.storage_.getPortalConfig(portalName);
        if (portal == null || !this.userACL_.hasPermission(portal)) {
            return null;
        }
        return new UserPortalConfig(portal, this, portalName, accessUser, userPortalContext);
    }

    public List<String> getMakableNavigations(String remoteUser, boolean withSite) throws Exception {
        Collection groups = remoteUser.equals(this.userACL_.getSuperUser()) ? this.orgService_.getGroupHandler().getAllGroups() : this.orgService_.getGroupHandler().resolveGroupByMembership(remoteUser, this.userACL_.getMakableMT());
        ArrayList<String> list = new ArrayList<String>();
        if (groups != null) {
            HashSet<String> existingNames = null;
            if (withSite) {
                existingNames = new HashSet<String>();
                Query q = new Query(DEFAULT_GROUP_SITE_TEMPLATE, null, PortalConfig.class);
                LazyPageList lpl = this.storage_.find(q);
                for (PortalConfig groupSite : lpl.getAll()) {
                    existingNames.add(groupSite.getName());
                }
            }
            for (Group group : groups) {
                String groupId = group.getId().trim();
                if (existingNames != null && !existingNames.contains(groupId)) continue;
                list.add(groupId);
            }
        }
        return list;
    }

    public boolean hasMakableNavigations(String remoteUser, boolean withSite) throws Exception {
        boolean hasNav = false;
        if (remoteUser == null) {
            hasNav = false;
        } else if (remoteUser.equals(this.userACL_.getSuperUser())) {
            hasNav = true;
        } else {
            Collection groups = this.orgService_.getGroupHandler().resolveGroupByMembership(remoteUser, this.userACL_.getMakableMT());
            if (groups != null && groups.size() > 0) {
                if (withSite) {
                    for (Group group : groups) {
                        PortalConfig cfg = this.storage_.getPortalConfig(PortalConfig.GROUP_TYPE, group.getId());
                        if (cfg == null) continue;
                        hasNav = true;
                        break;
                    }
                } else {
                    hasNav = true;
                }
            }
        }
        return hasNav;
    }

    public void createUserSite(String userName) throws Exception {
        SiteKey key;
        NavigationContext nav;
        this.createUserPortalConfig(PortalConfig.USER_TYPE, userName, this.getDefaultUserSiteTemplate());
        PortalConfig cfg = this.storage_.getPortalConfig(PortalConfig.USER_TYPE, userName);
        if (cfg == null) {
            cfg = new PortalConfig(PortalConfig.USER_TYPE, userName);
            cfg.useDefaultPortalLayout();
            this.storage_.create(cfg);
        }
        if ((nav = this.navService.loadNavigation(key = SiteKey.user((String)userName))) == null) {
            nav = new NavigationContext(key, new NavigationState(Integer.valueOf(5)));
            this.navService.saveNavigation(nav);
        }
    }

    public void createGroupSite(String groupId) throws Exception {
        this.createUserPortalConfig(PortalConfig.GROUP_TYPE, groupId, this.getDefaultGroupSiteTemplate());
        PortalConfig cfg = this.storage_.getPortalConfig(PortalConfig.GROUP_TYPE, groupId);
        if (cfg == null) {
            cfg = new PortalConfig(PortalConfig.GROUP_TYPE, groupId);
            cfg.useDefaultPortalLayout();
            this.storage_.create(cfg);
        }
    }

    public void createUserPortalConfig(String siteType, String siteName, String template) throws Exception {
        NewPortalConfig portalConfig = null;
        if (StringUtils.isBlank((String)template)) {
            portalConfig = new NewPortalConfig();
            portalConfig.setUseDefaultPortalLayout(true);
        } else {
            String templatePath = this.newPortalConfigListener_.getTemplateConfig(siteType, template);
            portalConfig = new NewPortalConfig(templatePath);
            portalConfig.setTemplateName(template);
        }
        portalConfig.setOwnerType(siteType);
        this.newPortalConfigListener_.createPortalConfig(portalConfig, siteName);
        this.newPortalConfigListener_.createPage(portalConfig, siteName);
        this.newPortalConfigListener_.createPageNavigation(portalConfig, siteName);
    }

    public void removeUserPortalConfig(String portalName) throws Exception {
        this.removeUserPortalConfig(PortalConfig.PORTAL_TYPE, portalName);
    }

    public void removeUserPortalConfig(String ownerType, String ownerId) throws Exception {
        PortalConfig config = this.storage_.getPortalConfig(ownerType, ownerId);
        if (config != null) {
            this.storage_.remove(config);
        }
    }

    public PageContext getPage(PageKey pageRef) {
        if (pageRef == null) {
            return null;
        }
        PageContext page = this.pageService.loadPage(pageRef);
        if (page == null || !this.userACL_.hasPermission(page)) {
            return null;
        }
        return page;
    }

    public Page createPageTemplate(String temp, String ownerType, String ownerId) throws Exception {
        Page page = this.newPortalConfigListener_.createPageFromTemplate(ownerType, ownerId, temp);
        this.updateOwnership((ModelObject)page, ownerType, ownerId);
        return page;
    }

    public List<String> getAllPortalNames() throws Exception {
        return this.getAllSiteNames(SiteType.PORTAL);
    }

    public List<String> getAllGroupNames() throws Exception {
        return this.getAllSiteNames(SiteType.GROUP);
    }

    public String getGlobalPortal() {
        return this.globalPortal_;
    }

    private List<String> getAllSiteNames(SiteType siteType) throws Exception {
        List list;
        switch (siteType) {
            case PORTAL: {
                list = this.storage_.getAllPortalNames();
                if (!StringUtils.isNotBlank((String)this.globalPortal_)) break;
                list.remove(this.globalPortal_);
                break;
            }
            case GROUP: {
                list = this.storage_.getAllGroupNames();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        Iterator i = list.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            PortalConfig config = this.storage_.getPortalConfig(siteType.getName(), name);
            if (config != null && this.userACL_.hasPermission(config)) continue;
            i.remove();
        }
        return list;
    }

    private void updateOwnership(ModelObject object, String ownerType, String ownerId) {
        Application application;
        TransientApplicationState applicationState;
        if (object instanceof Container) {
            Container container = (Container)object;
            if (container instanceof Page) {
                Page page = (Page)container;
                page.setOwnerType(ownerType);
                page.setOwnerId(ownerId);
            }
            for (ModelObject child : container.getChildren()) {
                this.updateOwnership(child, ownerType, ownerId);
            }
        } else if (object instanceof Application && (applicationState = (TransientApplicationState)(application = (Application)object).getState()) != null && (applicationState.getOwnerType() == null || applicationState.getOwnerId() == null)) {
            applicationState.setOwnerType(ownerType);
            applicationState.setOwnerId(ownerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initListener(ComponentPlugin listener) {
        if (listener instanceof NewPortalConfigListener) {
            UserPortalConfigService userPortalConfigService = this;
            synchronized (userPortalConfigService) {
                if (this.newPortalConfigListener_ == null) {
                    this.newPortalConfigListener_ = (NewPortalConfigListener)listener;
                } else {
                    this.newPortalConfigListener_.mergePlugin((NewPortalConfigListener)listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteListenerElements(ComponentPlugin listener) {
        if (listener instanceof NewPortalConfigListener) {
            UserPortalConfigService userPortalConfigService = this;
            synchronized (userPortalConfigService) {
                if (this.newPortalConfigListener_ != null) {
                    this.newPortalConfigListener_.deleteListenerElements((NewPortalConfigListener)listener);
                }
            }
        }
    }

    public void start() {
        try {
            if (this.newPortalConfigListener_ == null) {
                return;
            }
            this.newPortalConfigListener_.run();
        }
        catch (Exception e) {
            this.log.error((Object)"Could not import initial data", (Throwable)e);
        }
        this.loadDefaultPortalConfig();
    }

    public void stop() {
    }

    public String getDefaultPortal() {
        return this.newPortalConfigListener_.getDefaultPortal();
    }

    public String getUserHomePage(String username) {
        SettingValue homePageSettingValue = this.settingService.get(Context.USER.id(username), HOME_PAGE_URI_PREFERENCE_SCOPE, HOME_PAGE_URI_PREFERENCE_KEY);
        if (homePageSettingValue != null && homePageSettingValue.getValue() != null) {
            return homePageSettingValue.getValue().toString();
        }
        return PropertyManager.getProperty((String)"exo.portal.user.defaultHome");
    }

    public void saveUserHomePage(String username, String uri) {
        if (StringUtils.isBlank((String)uri)) {
            this.settingService.remove(Context.USER.id(username), HOME_PAGE_URI_PREFERENCE_SCOPE, HOME_PAGE_URI_PREFERENCE_KEY);
        } else {
            this.settingService.set(Context.USER.id(username), HOME_PAGE_URI_PREFERENCE_SCOPE, HOME_PAGE_URI_PREFERENCE_KEY, SettingValue.create((String)uri));
        }
    }

    public String getDefaultPortalTemplate() {
        return this.newPortalConfigListener_.getDefaultPortalTemplate();
    }

    public Set<String> getPortalTemplates() {
        return this.newPortalConfigListener_.getTemplateConfigs(PortalConfig.PORTAL_TYPE);
    }

    public PortalConfig getPortalConfigFromTemplate(String templateName) {
        return this.newPortalConfigListener_.getPortalConfigFromTemplate(PortalConfig.PORTAL_TYPE, templateName);
    }

    public String getDefaultPortalSkinName() {
        return this.defaultPortalConfig != null && StringUtils.isNotBlank((String)this.defaultPortalConfig.getSkin()) ? this.defaultPortalConfig.getSkin() : null;
    }

    public PortalConfig getDefaultPortalConfig() {
        return this.defaultPortalConfig;
    }

    public void setDefaultPortalConfig(PortalConfig defaultPortalConfig) {
        this.defaultPortalConfig = defaultPortalConfig;
    }

    protected void loadDefaultPortalConfig() {
        String defaultPortal = this.getDefaultPortal();
        if (defaultPortal != null) {
            try {
                RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
                this.defaultPortalConfig = this.getDataStorage().getPortalConfig(defaultPortal);
            }
            catch (Exception e) {
                this.log.error((Object)("Cannot retrieve data of portal " + defaultPortal), (Throwable)e);
            }
            finally {
                RequestLifeCycle.end();
            }
        }
    }

    public void reloadConfig(String ownerType, String predefinedOwner, String location, String importMode, boolean overrideMode) {
        this.newPortalConfigListener_.reloadConfig(ownerType, predefinedOwner, location, importMode, overrideMode);
    }
}

