/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.rest.CollectionEntity;
import org.exoplatform.portal.rest.UserFieldValidator;
import org.exoplatform.portal.rest.model.MembershipRestEntity;
import org.exoplatform.portal.rest.model.UserRestEntity;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.organization.search.UserSearchService;
import org.exoplatform.services.rest.http.PATCH;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.web.login.recovery.ChangePasswordConnector;
import org.exoplatform.web.login.recovery.PasswordRecoveryService;

@Path(value="v1/users")
@Tag(name="v1/users", description="Manage User operations")
public class UserRestResourcesV1
implements ResourceContainer {
    public static final int DEFAULT_LIMIT = 10;
    public static final String PASSWORD_UNKNOWN_ERROR_CODE = "PASSWORD_UNKNOWN_ERROR";
    public static final String USER_NOT_FOUND_ERROR_CODE = "USER_NOT_FOUND";
    public static final String WRONG_USER_PASSWORD_ERROR_CODE = "WRONG_USER_PASSWORD";
    public static final String CHANGE_PASSWORD_NOT_ALLOWED = "CHANGE_PASSWORD_NOT_ALLOWED";
    private static final String ADMINISTRATOR_GROUP = "/platform/administrators";
    private static final String DELEGATED_GROUP = "/platform/delegated";
    public static final String UNCHANGED_NEW_PASSWORD_ERROR_CODE = "UNCHANGED_NEW_PASSWORD";
    public static final UserFieldValidator USERNAME_VALIDATOR = new UserFieldValidator("userName", true, false);
    public static final UserFieldValidator EMAIL_VALIDATOR = new UserFieldValidator("emailAddress", false, false);
    public static final UserFieldValidator LASTNAME_VALIDATOR = new UserFieldValidator("lastName", false, true);
    public static final UserFieldValidator FIRSTNAME_VALIDATOR = new UserFieldValidator("firstName", false, true);
    public static final UserFieldValidator PASSWORD_VALIDATOR = new UserFieldValidator("password", false, false, 8, 255);
    private OrganizationService organizationService;
    private UserSearchService userSearchService;
    private UserACL userACL;
    private PasswordRecoveryService passwordRecoveryService;

    public UserRestResourcesV1(OrganizationService organizationService, UserSearchService userSearchService, UserACL userACL, PasswordRecoveryService passwordRecoveryService) {
        this.organizationService = organizationService;
        this.userSearchService = userSearchService;
        this.userACL = userACL;
        this.passwordRecoveryService = passwordRecoveryService;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Gets all users", description="Gets all users", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error due to data encoding")})
    public Response getUsers(@Parameter(description="User name information to filter, ex: user name, last name, first name or full name", required=false) @QueryParam(value="q") String q, @Parameter(description="User status : ANY, ENABLED or DISABLED", required=false) @Schema(defaultValue="ANY") @QueryParam(value="status") String status, @Parameter(description="Offset", required=false) @Schema(defaultValue="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit", required=false) @Schema(defaultValue="10") @QueryParam(value="limit") int limit, @Parameter(description="Returning the number of users found or not") @Schema(defaultValue="false") @QueryParam(value="returnSize") boolean returnSize) throws Exception {
        User[] users;
        offset = offset > 0 ? offset : 0;
        limit = limit > 0 ? limit : 10;
        UserStatus userStatus = StringUtils.isBlank((CharSequence)status) || StringUtils.equalsIgnoreCase((CharSequence)"ALL", (CharSequence)status) || StringUtils.equalsIgnoreCase((CharSequence)"ANY", (CharSequence)status) ? UserStatus.ANY : UserStatus.valueOf((String)status.toUpperCase());
        int totalSize = 0;
        if (StringUtils.isBlank((CharSequence)q)) {
            ListAccess allUsersListAccess = this.organizationService.getUserHandler().findAllUsers(userStatus);
            totalSize = allUsersListAccess.getSize();
            if (totalSize < offset + (limitToFetch = limit)) {
                limitToFetch = totalSize - offset;
            }
            if (limitToFetch <= 0) {
                users = new User[]{};
            } else {
                users = (User[])allUsersListAccess.load(offset, limitToFetch);
                if (!returnSize) {
                    totalSize = 0;
                }
            }
        } else {
            ListAccess usersListAccess = this.userSearchService.searchUsers(q, userStatus);
            totalSize = usersListAccess.getSize();
            if (totalSize < offset + (limitToFetch = limit)) {
                limitToFetch = totalSize - offset;
            }
            if (limitToFetch <= 0) {
                users = new User[]{};
            } else {
                users = (User[])usersListAccess.load(offset, limitToFetch);
                if (!returnSize) {
                    totalSize = 0;
                }
            }
        }
        List userEntities = Arrays.stream(users).map(this::toEntity).collect(Collectors.toList());
        CollectionEntity result = new CollectionEntity(userEntities, offset, limit, totalSize);
        return Response.ok(result).build();
    }

    @POST
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Create new user", description="Create new user", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error due to data encoding")})
    public Response createUser(@Context HttpServletRequest request, @RequestBody(description="User Object") UserRestEntity userEntity) throws Exception {
        if (userEntity == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"empty user object").build();
        }
        String userName = userEntity.getUserName();
        String email = userEntity.getEmail();
        String firstName = userEntity.getFirstName();
        String lastName = userEntity.getLastName();
        String password = userEntity.getPassword();
        Locale locale = request == null ? Locale.ENGLISH : request.getLocale();
        String errorMessage = USERNAME_VALIDATOR.validate(locale, userName);
        if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("USERNAME:" + errorMessage)).build();
        }
        errorMessage = PASSWORD_VALIDATOR.validate(locale, password);
        if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("PASSWORD:" + errorMessage)).build();
        }
        errorMessage = LASTNAME_VALIDATOR.validate(locale, lastName);
        if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("LASTNAME:" + errorMessage)).build();
        }
        errorMessage = FIRSTNAME_VALIDATOR.validate(locale, firstName);
        if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("FIRSTNAME:" + errorMessage)).build();
        }
        errorMessage = EMAIL_VALIDATOR.validate(locale, email);
        if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("EMAIL:" + errorMessage)).build();
        }
        User user = this.organizationService.getUserHandler().findUserByName(userName, UserStatus.ANY);
        if (user != null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"USERNAME:ALREADY_EXISTS").build();
        }
        Query query = new Query();
        query.setEmail(email);
        if (this.organizationService.getUserHandler().findUsersByQuery(query, UserStatus.ANY).getSize() > 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"EMAIL:ALREADY_EXISTS").build();
        }
        user = this.organizationService.getUserHandler().createUserInstance(userName);
        user.setEmail(email);
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.setPassword(password);
        try {
            this.organizationService.getUserHandler().createUser(user, true);
        }
        catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"USERNAME:ALREADY_EXISTS_AS_DELETED").build();
        }
        if (!user.isEnabled()) {
            this.organizationService.getUserHandler().setEnabled(userName, false, true);
        }
        return Response.noContent().build();
    }

    @PUT
    @RolesAllowed(value={"users"})
    @Operation(summary="Update an existing user", description="Update an existing user", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error due to data encoding")})
    public Response updateUser(@Context HttpServletRequest request, @RequestBody(description="User Object") UserRestEntity userEntity) throws Exception {
        String errorMessage;
        Locale locale;
        if (!this.userACL.isUserInGroup(DELEGATED_GROUP) && !this.userACL.isUserInGroup(ADMINISTRATOR_GROUP)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        if (userEntity == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"empty user object").build();
        }
        String userName = userEntity.getUserName();
        String email = userEntity.getEmail();
        String firstName = userEntity.getFirstName();
        String lastName = userEntity.getLastName();
        String password = userEntity.getPassword();
        boolean enabled = userEntity.isEnabled();
        Locale locale2 = locale = request == null ? Locale.ENGLISH : request.getLocale();
        if (StringUtils.isNotBlank((CharSequence)password) && StringUtils.isNotBlank((CharSequence)(errorMessage = PASSWORD_VALIDATOR.validate(locale, password)))) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("PASSWORD:" + errorMessage)).build();
        }
        User user = this.organizationService.getUserHandler().findUserByName(userName, UserStatus.ANY);
        if (user == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        String errorMessage2 = LASTNAME_VALIDATOR.validate(locale, lastName);
        if (StringUtils.isNotBlank((CharSequence)errorMessage2)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("LASTNAME:" + errorMessage2)).build();
        }
        errorMessage2 = FIRSTNAME_VALIDATOR.validate(locale, firstName);
        if (StringUtils.isNotBlank((CharSequence)errorMessage2)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("FIRSTNAME:" + errorMessage2)).build();
        }
        errorMessage2 = EMAIL_VALIDATOR.validate(locale, email);
        if (StringUtils.isNotBlank((CharSequence)errorMessage2)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("EMAIL:" + errorMessage2)).build();
        }
        Query query = new Query();
        query.setEmail(email);
        if (!StringUtils.equals((CharSequence)user.getEmail(), (CharSequence)email) && this.organizationService.getUserHandler().findUsersByQuery(query, UserStatus.ANY).getSize() > 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"EMAIL:ALREADY_EXISTS").build();
        }
        if (!(StringUtils.equals((CharSequence)email, (CharSequence)user.getEmail()) && StringUtils.equals((CharSequence)lastName, (CharSequence)user.getLastName()) && StringUtils.equals((CharSequence)firstName, (CharSequence)user.getFirstName()))) {
            user.setEmail(email);
            user.setFirstName(firstName);
            user.setLastName(lastName);
            user.setPassword(password);
            user.setDisplayName(firstName + " " + lastName);
            this.organizationService.getUserHandler().saveUser(user, true);
        }
        if (StringUtils.isNotBlank((CharSequence)password)) {
            this.passwordRecoveryService.getActiveChangePasswordConnector().changePassword(userName, password);
        }
        if (user.isEnabled() != enabled) {
            if (!enabled) {
                String currentUsername = UserRestResourcesV1.getCurrentUsername();
                if (StringUtils.equals((CharSequence)currentUsername, (CharSequence)user.getUserName())) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"SelfDisable").build();
                }
                if (StringUtils.equals((CharSequence)this.userACL.getSuperUser(), (CharSequence)user.getUserName())) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"DisableSuperUser").build();
                }
            }
            this.organizationService.getUserHandler().setEnabled(userName, enabled, true);
        }
        return Response.noContent().build();
    }

    @DELETE
    @RolesAllowed(value={"administrators"})
    @Path(value="{id}")
    @Operation(summary="Deletes a user identified by its id", description="Deletes a user identified by its id", method="DELETE")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="401", description="User not authorized to call this endpoint"), @ApiResponse(responseCode="404", description="User not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteUser(@Parameter(description="User name identifier", required=true) @PathParam(value="id") String userName) throws Exception {
        User user = this.organizationService.getUserHandler().findUserByName(userName, UserStatus.ANY);
        if (user == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        String currentUsername = UserRestResourcesV1.getCurrentUsername();
        if (StringUtils.equals((CharSequence)currentUsername, (CharSequence)user.getUserName())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"SelfDelete").build();
        }
        if (StringUtils.equals((CharSequence)this.userACL.getSuperUser(), (CharSequence)user.getUserName())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"DeleteSuperUser").build();
        }
        this.organizationService.getUserHandler().removeUser(userName, true);
        return Response.noContent().build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="{id}")
    @Operation(summary="Gets a user identified by its id", description="Gets a user identified by its id", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="User not authorized to call this endpoint"), @ApiResponse(responseCode="404", description="User not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getUser(@Context UriInfo uriInfo, @Parameter(description="User name identifier", required=true) @PathParam(value="id") String id) throws Exception {
        if (!(this.userACL.isSuperUser() || this.userACL.isUserInGroup(this.userACL.getAdminGroups()) || ConversationState.getCurrent().getIdentity().getUserId().equals(id))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        User user = this.organizationService.getUserHandler().findUserByName(id, UserStatus.ANY);
        if (user == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        UserRestEntity userRestEntity = this.toEntity(user);
        Collection memberships = this.organizationService.getMembershipHandler().findMembershipsByUser(id);
        if (memberships != null) {
            userRestEntity.setPlatformAdministrator(memberships.stream().anyMatch(membership -> membership.getGroupId().equals(this.userACL.getAdminGroups())));
        }
        return Response.ok((Object)userRestEntity, (String)"application/json").build();
    }

    @PATCH
    @RolesAllowed(value={"users"})
    @Path(value="{id}/changePassword")
    @Operation(summary="Changes user password", description="Changes user password", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="User not authorized to call this endpoint"), @ApiResponse(responseCode="404", description="User not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response changePassword(@Context HttpServletRequest request, @Parameter(description="username to change his password", required=true) @PathParam(value="id") String username, @Parameter(description="Current user password", required=true) @FormParam(value="currentPassword") String currentPassword, @Parameter(description="New user password", required=true) @FormParam(value="newPassword") String newPassword) {
        boolean isAdmin = this.userACL.isSuperUser() || this.userACL.isUserInGroup(this.userACL.getAdminGroups());
        boolean isSameUser = ConversationState.getCurrent().getIdentity().getUserId().equals(username);
        if (!isAdmin && !isSameUser) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            UserHandler userHandler = this.organizationService.getUserHandler();
            User user = userHandler.findUserByName(username, UserStatus.ANY);
            if (user == null) {
                return Response.serverError().entity((Object)USER_NOT_FOUND_ERROR_CODE).build();
            }
            if (!this.passwordRecoveryService.allowChangePassword(user.getUserName())) {
                return Response.serverError().entity((Object)CHANGE_PASSWORD_NOT_ALLOWED).build();
            }
            if (isSameUser && !userHandler.authenticate(username, currentPassword)) {
                return Response.serverError().entity((Object)WRONG_USER_PASSWORD_ERROR_CODE).build();
            }
            if (isSameUser && userHandler.authenticate(username, newPassword)) {
                return Response.serverError().entity((Object)UNCHANGED_NEW_PASSWORD_ERROR_CODE).build();
            }
            Locale locale = request.getLocale();
            String errorMessage = PASSWORD_VALIDATOR.validate(locale, newPassword);
            if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
                return Response.serverError().entity((Object)errorMessage).build();
            }
            ChangePasswordConnector activeChangePasswordConnector = this.passwordRecoveryService.getActiveChangePasswordConnector();
            activeChangePasswordConnector.changePassword(user.getUserName(), newPassword);
            return Response.noContent().build();
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)("PASSWORD_UNKNOWN_ERROR:" + e.getMessage())).build();
        }
    }

    @GET
    @Path(value="{id}/memberships")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Gets User memberships list", description="Gets User memberships list", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="User not found"), @ApiResponse(responseCode="500", description="Internal server error due to data encoding")})
    public Response getUserMemberships(@Parameter(description="User name identifier", required=true) @PathParam(value="id") String userName, @Parameter(description="Offset", required=false) @Schema(defaultValue="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit", required=false) @Schema(defaultValue="20") @QueryParam(value="limit") int limit, @Parameter(description="Returning the number of users found or not") @Schema(defaultValue="false") @QueryParam(value="returnSize") boolean returnSize) throws Exception {
        int limitToFetch;
        offset = offset > 0 ? offset : 0;
        limit = limit > 0 ? limit : 10;
        User user = this.organizationService.getUserHandler().findUserByName(userName, UserStatus.ANY);
        if (user == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        ListAccess membershipsByUser = this.organizationService.getMembershipHandler().findAllMembershipsByUser(user);
        int totalSize = membershipsByUser.getSize();
        if (totalSize < offset + (limitToFetch = limit)) {
            limitToFetch = totalSize - offset;
        }
        ArrayList<MembershipRestEntity> membershipEntities = new ArrayList<MembershipRestEntity>();
        if (limitToFetch > 0) {
            Membership[] memberships;
            for (Membership membership : memberships = (Membership[])membershipsByUser.load(offset, limitToFetch)) {
                Group group = this.organizationService.getGroupHandler().findGroupById(membership.getGroupId());
                membershipEntities.add(new MembershipRestEntity(membership, group, user));
            }
            if (!returnSize) {
                totalSize = 0;
            }
        }
        return Response.ok(new CollectionEntity(membershipEntities, offset, limit, totalSize)).build();
    }

    @GET
    @Path(value="isSuperUser")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Check if current user is a superUser", description="Check if current user is a superUser", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error due to data encoding")})
    public Response isSuperUser() {
        return Response.ok().entity((Object)("{\"isSuperUser\":\"" + this.userACL.isSuperUser() + "\"}")).build();
    }

    @GET
    @Path(value="isDelegatedAdministrator")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Check if current user is a delegated administrator", description="Check if current user is a delegated administrator", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error due to data encoding")})
    public Response isDelegatedAdministrator() {
        boolean isDelegatedAdministrator = this.userACL.isUserInGroup(DELEGATED_GROUP) && !this.userACL.isUserInGroup(ADMINISTRATOR_GROUP);
        return Response.ok().entity((Object)("{\"result\":\"" + isDelegatedAdministrator + "\"}")).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="isSynchronizedUserAllowedToChangePassword")
    @RolesAllowed(value={"users"})
    @Operation(summary="Check if synchronized user is allowed to change his password", description="Check if synchronized user is allowed to change his password", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error due to data encoding")})
    public Response isSynchronizedUserAllowedToChangePassword(@Context UriInfo uriInfo) throws Exception {
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        User user = this.organizationService.getUserHandler().findUserByName(userId, UserStatus.ANY);
        if (user == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        boolean allowChangePassword = user.isInternalStore() || System.getProperty("exo.portal.allow.change.external.password") != null && Boolean.valueOf(System.getProperty("exo.portal.allow.change.external.password").toString()) != false;
        return Response.ok().entity((Object)("{\"isSynchronizedUserAllowedToChangePassword\":\"" + allowChangePassword + "\"}")).build();
    }

    private UserRestEntity toEntity(User user) {
        return new UserRestEntity(user.getUserName(), user.getFirstName(), user.getLastName(), user.getDisplayName(), user.getEmail(), user.isEnabled(), false);
    }

    public static String getCurrentUsername() {
        Identity currentIdentity;
        Identity identity = currentIdentity = ConversationState.getCurrent() == null ? null : ConversationState.getCurrent().getIdentity();
        if (currentIdentity == null) {
            return null;
        }
        return currentIdentity.getUserId();
    }
}

