/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.embedder;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.commons.embedder.AbstractEmbedder;
import org.exoplatform.commons.embedder.ExoMedia;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.JSONException;
import org.json.JSONObject;

public class OembedEmbedder
extends AbstractEmbedder {
    private static final Log LOG = ExoLogger.getLogger(OembedEmbedder.class);
    private static final String EMBED_TITLE = "title";
    private static final String EMBED_DESC = "description";
    private static final String EMBED_PROVIDER = "provider_name";
    private static final String EMBED_URL = "url";
    private static final String EMBED_HTML = "html";
    private static final String EMBED_TYPE = "type";
    private static final String EMBED_THUMBNAIL_URL = "thumbnail_url";
    private static final String EMBED_THUMBNAIL_WIDTH = "thumbnail_width";
    private static final String EMBED_THUMBNAIL_HEIGHT = "thumbnail_height";
    private static final String EMBED_THUMBNAIL = "thumbnail";
    private static final Pattern SHORTEN_DAILY_MOTION_PATTERN = Pattern.compile("(https?)://dai\\.ly/.*");

    public OembedEmbedder(InitParams initParams) {
        super(initParams);
    }

    public Pattern getOembedURLPattern() {
        return this.getPattern();
    }

    @Override
    public ExoMedia getExoMedia() {
        URL urlObj = this.getOembedUrl(this.url);
        if (urlObj == null) {
            return null;
        }
        JSONObject oembedData = this.getJSONObject(urlObj);
        if (oembedData == null) {
            return null;
        }
        return this.jsonToExoMedia(oembedData);
    }

    private URL getOembedUrl(String url) {
        try {
            for (Pattern pattern : this.schemeEndpointMap.keySet()) {
                Matcher matcher = pattern.matcher(url);
                if (!matcher.find()) continue;
                String endpoint = (String)this.schemeEndpointMap.get(pattern);
                String scheme = "https";
                try {
                    PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
                    scheme = portalRequestContext.getRequest().getScheme();
                }
                catch (Exception e) {
                    LOG.info((Object)"Cannot get scheme from Portal Request Context");
                }
                Matcher shortenMatcher = SHORTEN_DAILY_MOTION_PATTERN.matcher(url);
                if (shortenMatcher.find()) {
                    if (shortenMatcher.group(1).equalsIgnoreCase("http")) {
                        url = this.correctURIString(url, "https", true);
                    }
                    url = url.replaceFirst("dai\\.ly", "www.dailymotion.com/embed/video");
                }
                return new URL(this.correctURIString(String.format(endpoint, url), scheme, false));
            }
        }
        catch (MalformedURLException e) {
            LOG.warn((Object)"Can't get oembed url for oembed request", (Throwable)e);
        }
        return null;
    }

    private ExoMedia jsonToExoMedia(JSONObject jsonObject) {
        ExoMedia mediaObject = new ExoMedia();
        try {
            mediaObject.setTitle(jsonObject.getString(EMBED_TITLE));
            mediaObject.setHtml(jsonObject.getString(EMBED_HTML).replaceFirst("width=\\\"[0-9]*\\\"", "width=\"450\"").replaceFirst("height=\\\"[0-9]*\\\"", "height=\"220\""));
            mediaObject.setType(jsonObject.getString(EMBED_TYPE));
            mediaObject.setProvider(jsonObject.getString(EMBED_PROVIDER));
            mediaObject.setDescription(jsonObject.has(EMBED_DESC) ? jsonObject.getString(EMBED_DESC) : "");
            mediaObject.setUrl(jsonObject.has(EMBED_URL) ? jsonObject.getString(EMBED_URL) : "");
            if (jsonObject.has(EMBED_THUMBNAIL_URL)) {
                mediaObject.setThumbnailUrl(jsonObject.getString(EMBED_THUMBNAIL_URL));
            } else if (jsonObject.has(EMBED_THUMBNAIL)) {
                mediaObject.setThumbnailUrl(jsonObject.getString(EMBED_THUMBNAIL));
            }
            if (jsonObject.has(EMBED_THUMBNAIL_HEIGHT)) {
                mediaObject.setThumbnailHeight(String.valueOf(jsonObject.getInt(EMBED_THUMBNAIL_HEIGHT)));
            }
            if (jsonObject.has(EMBED_THUMBNAIL_WIDTH)) {
                mediaObject.setThumbnailWidth(String.valueOf(jsonObject.getInt(EMBED_THUMBNAIL_WIDTH)));
            }
            if ("Flickr".equals(mediaObject.getProvider())) {
                mediaObject.setHtml(mediaObject.getHtml().replaceAll("<script.+</script>", ""));
            }
            return mediaObject;
        }
        catch (JSONException e) {
            LOG.warn((Object)"Can't convert JSONObject to ExoMedia object", (Throwable)e);
            return null;
        }
    }

    @Override
    protected Log getExoLogger() {
        return LOG;
    }
}

