/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileEventListener;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profileproperty.ProfilePropertyService;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertySetting;
import org.exoplatform.social.core.storage.api.IdentityStorage;

public class SocialUserProfileEventListenerImpl
extends UserProfileEventListener {
    private static final Log LOG = ExoLogger.getLogger(SocialUserProfileEventListenerImpl.class);
    private static final String SOCIAL_PROFILE_EXCLUDED_ATTRIBUTE_LIST = "exo.social.profile.excluded.attributeList";
    private final List<String> exlcudedAttributeList = new ArrayList<String>(List.of("authenticationAttempts", "latestAuthFailureTime"));
    private final IdentityManager identityManager;
    private final ProfilePropertyService profilePropertyService;

    public SocialUserProfileEventListenerImpl(IdentityManager identityManager, ProfilePropertyService profilePropertyService) {
        this.identityManager = identityManager;
        this.profilePropertyService = profilePropertyService;
        String socialProfileExcludedAttributeList = PropertyManager.getProperty((String)SOCIAL_PROFILE_EXCLUDED_ATTRIBUTE_LIST);
        if (StringUtils.isNotBlank((CharSequence)socialProfileExcludedAttributeList)) {
            this.exlcudedAttributeList.addAll(Arrays.asList(socialProfileExcludedAttributeList.split(",")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSave(UserProfile userProfile, boolean isNew) throws Exception {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            Identity identity = this.identityManager.getOrCreateIdentity("organization", userProfile.getUserName());
            Profile profile = identity.getProfile();
            String uGender = userProfile.getAttribute(UserProfile.PERSONAL_INFO_KEYS[4]);
            String uPosition = userProfile.getAttribute(UserProfile.PERSONAL_INFO_KEYS[7]);
            String pGender = (String)profile.getProperty("gender");
            String pPosition = (String)profile.getProperty("position");
            AtomicBoolean hasUpdated = new AtomicBoolean(false);
            Map properties = userProfile.getUserInfoMap();
            this.exlcudedAttributeList.forEach(properties.keySet()::remove);
            properties.forEach((name, value) -> {
                this.updateProfilePropertySettings((String)name, this.profilePropertyService);
                if (isNew) {
                    profile.setProperty(name, value);
                } else if (!StringUtils.equals((CharSequence)((String)profile.getProperty(name)), (CharSequence)userProfile.getAttribute(name))) {
                    profile.setProperty(name, value);
                    hasUpdated.set(true);
                }
            });
            if (!StringUtils.equals((CharSequence)uGender, (CharSequence)pGender)) {
                profile.setProperty("gender", (Object)uGender);
                hasUpdated.set(true);
            }
            if (!StringUtils.equals((CharSequence)uPosition, (CharSequence)pPosition)) {
                profile.setProperty("position", (Object)uPosition);
                hasUpdated.set(true);
            }
            if (hasUpdated.get()) {
                ArrayList<Profile.UpdateType> updateTypes = new ArrayList<Profile.UpdateType>();
                updateTypes.add(Profile.UpdateType.CONTACT);
                profile.setListUpdateTypes(updateTypes);
            }
            if (hasUpdated.get() || isNew) {
                IdentityStorage identityStorage = (IdentityStorage)CommonsUtils.getService(IdentityStorage.class);
                identityStorage.updateProfile(profile);
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private void updateProfilePropertySettings(String propertyName, ProfilePropertyService profilePropertyService) {
        ProfilePropertySetting propertySetting = profilePropertyService.getProfileSettingByName(propertyName);
        if (propertySetting == null) {
            ProfilePropertySetting profilePropertySetting = new ProfilePropertySetting();
            profilePropertySetting.setPropertyName(propertyName);
            profilePropertySetting.setMultiValued(false);
            profilePropertySetting.setActive(true);
            profilePropertySetting.setEditable(false);
            profilePropertySetting.setVisible(false);
            profilePropertySetting.setParentId(null);
            try {
                profilePropertyService.createPropertySetting(profilePropertySetting);
            }
            catch (ObjectAlreadyExistsException e) {
                LOG.error("Cannot add new profile setting property with name {}, already exist", new Object[]{propertyName, e});
            }
        }
    }
}

