/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.blockchain.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.future.FutureCache;
import org.exoplatform.services.cache.future.FutureExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.wallet.blockchain.service.EthereumClientConnector;
import org.exoplatform.wallet.blockchain.service.EthereumWalletTokenAdminService$AjcClosure1;
import org.exoplatform.wallet.contract.MeedsToken;
import org.exoplatform.wallet.model.ContractDetail;
import org.exoplatform.wallet.model.WalletType;
import org.exoplatform.wallet.model.settings.GlobalSettings;
import org.exoplatform.wallet.model.transaction.TransactionDetail;
import org.exoplatform.wallet.service.WalletAccountService;
import org.exoplatform.wallet.service.WalletContractService;
import org.exoplatform.wallet.service.WalletService;
import org.exoplatform.wallet.service.WalletTokenAdminService;
import org.exoplatform.wallet.service.WalletTransactionService;
import org.exoplatform.wallet.statistic.ExoWalletStatistic;
import org.exoplatform.wallet.statistic.ExoWalletStatisticAspect;
import org.exoplatform.wallet.statistic.ExoWalletStatisticService;
import org.exoplatform.wallet.storage.WalletStorage;
import org.exoplatform.wallet.utils.WalletUtils;
import org.picocontainer.Startable;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.crypto.CipherException;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Hash;
import org.web3j.crypto.Keys;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.TransactionEncoder;
import org.web3j.crypto.Wallet;
import org.web3j.crypto.WalletFile;
import org.web3j.protocol.ObjectMapperFactory;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.tx.ReadonlyTransactionManager;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;
import org.web3j.tx.gas.StaticGasProvider;
import org.web3j.utils.Numeric;

public class EthereumWalletTokenAdminService
implements WalletTokenAdminService,
Startable,
ExoWalletStatisticService {
    private static final Log LOG;
    private static final String NO_CONFIGURED_CONTRACT_ADDRESS = "No configured contract address";
    private static final String TRANSACTION_DETAIL_IS_MANDATORY = "Transaction detail is mandatory";
    private static final String RECEIVER_ADDRESS_PARAMETER_IS_MANDATORY = "receiver address parameter is mandatory";
    private PortalContainer container;
    private UserACL userACL;
    private WalletService walletService;
    private WalletContractService walletContractService;
    private EthereumClientConnector clientConnector;
    private WalletAccountService accountService;
    private WalletStorage accountStorage;
    private WalletTransactionService transactionService;
    private MeedsToken ertInstance;
    private long networkId = 0L;
    private String websocketURL = null;
    private String websocketURLSuffix = null;
    private String configuredContractAddress;
    private Integer configuredContractDecimals;
    private String adminPrivateKey;
    private long adminBlockchainNonce;
    private long adminBlockchainNonceLastUpdate;
    private FutureCache<String, BigInteger, Object> tokenBalanceFutureCache = null;
    private FutureCache<String, BigInteger, Object> etherBalanceFutureCache = null;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public EthereumWalletTokenAdminService(PortalContainer container, CacheService cacheService, WalletService walletService, EthereumClientConnector clientConnector) {
        this.container = container;
        this.walletService = walletService;
        this.clientConnector = clientConnector;
        ExoCache tokenBalanceCache = cacheService.getCacheInstance("wallet.blockchain.tokenBalance");
        tokenBalanceCache.setLiveTime(5L);
        ExoCache etherBalanceCache = cacheService.getCacheInstance("wallet.blockchain.etherBalance");
        etherBalanceCache.setLiveTime(5L);
        this.tokenBalanceFutureCache = new FutureExoCache((context, address) -> this.getTokenBalanceOfFromBlockchain((String)address), tokenBalanceCache);
        this.etherBalanceFutureCache = new FutureExoCache((context, address) -> this.getClientConnector().getEtherBalanceOf((String)address), etherBalanceCache);
    }

    public void start() {
        try {
            GlobalSettings settings = WalletUtils.getSettings();
            if (settings == null) {
                LOG.warn((Object)"No wallet settings are found");
                return;
            }
            if (settings.getNetwork() == null || settings.getNetwork().getId() <= 0L || StringUtils.isBlank((CharSequence)settings.getNetwork().getProviderURL()) || StringUtils.isBlank((CharSequence)settings.getNetwork().getWebsocketProviderURL())) {
                LOG.warn("No valid blockchain network settings are found: {}", new Object[]{settings.getNetwork()});
                return;
            }
            if (StringUtils.isBlank((CharSequence)settings.getContractAddress())) {
                LOG.warn((Object)"No contract address is configured");
                return;
            }
            this.adminPrivateKey = System.getProperty("exo.wallet.admin.privateKey", null);
            this.configuredContractAddress = settings.getContractAddress();
            this.websocketURL = WalletUtils.getWebsocketURL();
            this.networkId = WalletUtils.getNetworkId();
            ContractDetail contractDetail = this.getContractService().getContractDetail(this.configuredContractAddress);
            if (contractDetail == null) {
                contractDetail = new ContractDetail();
                contractDetail.setAddress(this.configuredContractAddress);
                contractDetail.setDecimals(Integer.valueOf(18));
                contractDetail.setName("Meeds Token");
                contractDetail.setSymbol("MEED");
                contractDetail.setNetworkId(Long.valueOf(this.networkId));
                this.getContractService().saveContractDetail(contractDetail);
                this.walletService.setConfiguredContractDetail(contractDetail);
            }
            this.configuredContractDecimals = this.getPrincipalContractDetail().getDecimals();
        }
        catch (Exception e) {
            LOG.warn("Error refreshing contract detail from blockchain with address {}", new Object[]{this.configuredContractAddress, e});
        }
        this.createAdminWalletAsync();
    }

    public void stop() {
    }

    public void createAdminAccount() {
        try {
            this.createAdminAccount(null, this.getUserACL().getSuperUser());
            LOG.info((Object)"Admin wallet created");
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("This exception shouldn't be thrown because no ACL check is made on server side method call", e);
        }
    }

    public org.exoplatform.wallet.model.Wallet createAdminAccount(String privateKey, String currentUser) throws IllegalAccessException {
        if (!WalletUtils.isUserRewardingAdmin((String)currentUser)) {
            throw new IllegalAccessException("User " + currentUser + " is not allowed to create admin wallet");
        }
        Identity identity = WalletUtils.getIdentityByTypeAndId((WalletType)WalletType.ADMIN, (String)"admin");
        if (identity == null) {
            throw new IllegalStateException("Can't find identity of admin wallet");
        }
        long identityId = Long.parseLong(identity.getId());
        org.exoplatform.wallet.model.Wallet wallet = this.getAccountService().getWalletByIdentityId(identityId);
        if (wallet != null && wallet.getAddress() != null && this.getAccountService().getPrivateKeyByTypeAndId(WalletType.ADMIN.getId(), "admin") != null) {
            throw new IllegalStateException("Admin wallet has already an associated wallet, thus can't overwrite it");
        }
        ECKeyPair ecKeyPair = null;
        if (StringUtils.isBlank((CharSequence)privateKey)) {
            try {
                ecKeyPair = Keys.createEcKeyPair();
            }
            catch (Exception e) {
                throw new IllegalStateException("Error creating new wallet keys pair", e);
            }
        } else {
            if (!org.web3j.crypto.WalletUtils.isValidPrivateKey((String)privateKey)) {
                throw new IllegalStateException("Private key isn't valid");
            }
            ecKeyPair = Credentials.create((String)privateKey).getEcKeyPair();
        }
        WalletFile adminWallet = null;
        try {
            adminWallet = Wallet.createLight((String)this.accountService.getAdminAccountPassword(), (ECKeyPair)ecKeyPair);
        }
        catch (CipherException e) {
            throw new IllegalStateException("Error creating new wallet", e);
        }
        wallet = new org.exoplatform.wallet.model.Wallet();
        wallet.setEnabled(true);
        wallet.setId("admin");
        wallet.setType(WalletType.ADMIN.getId());
        wallet.setAddress("0x" + adminWallet.getAddress());
        wallet.setTechnicalId(identityId);
        this.getAccountService().saveWalletAddress(wallet, currentUser);
        try {
            String walletJson = WalletUtils.toJsonString((Object)adminWallet);
            this.getAccountStorage().saveWalletPrivateKey(identityId, walletJson);
        }
        catch (Exception e) {
            this.getAccountService().removeWalletByAddress(wallet.getAddress(), currentUser);
        }
        if (StringUtils.isNotBlank((CharSequence)privateKey)) {
            this.getAccountService().refreshWalletFromBlockchain(wallet, WalletUtils.getContractDetail(), null);
        }
        return wallet;
    }

    public String getAdminWalletAddress() {
        org.exoplatform.wallet.model.Wallet adminWallet = this.getAccountService().getAdminWallet();
        return adminWallet == null ? null : adminWallet.getAddress();
    }

    public final boolean isInitializedAccount(org.exoplatform.wallet.model.Wallet wallet) throws Exception {
        return wallet.getIsInitialized() != null && wallet.getIsInitialized() != false;
    }

    public final BigInteger getTokenBalanceOf(String address) throws Exception {
        return (BigInteger)this.tokenBalanceFutureCache.get(null, (Object)address.toLowerCase());
    }

    public final BigInteger getEtherBalanceOf(String address) throws Exception {
        return (BigInteger)this.etherBalanceFutureCache.get(null, (Object)address.toLowerCase());
    }

    public TransactionDetail sendEther(TransactionDetail transactionDetail, String currentUserId) throws Exception {
        if (transactionDetail == null) {
            throw new IllegalArgumentException(TRANSACTION_DETAIL_IS_MANDATORY);
        }
        String receiverAddress = transactionDetail.getTo();
        if (StringUtils.isBlank((CharSequence)receiverAddress)) {
            throw new IllegalArgumentException(RECEIVER_ADDRESS_PARAMETER_IS_MANDATORY);
        }
        if (transactionDetail.getValue() <= 0.0) {
            throw new IllegalArgumentException("ether amount parameter has to be a positive amount");
        }
        this.checkAdminWalletIsValid();
        this.setIssuer(transactionDetail, currentUserId);
        String adminWalletAddress = this.getAdminWalletAddress();
        BigInteger etherAmount = transactionDetail.getValueDecimal(18);
        BigInteger adminEtherBalance = this.getEtherBalanceOf(adminWalletAddress);
        if (adminEtherBalance.compareTo(etherAmount) < 0) {
            throw new IllegalStateException("Wallet admin hasn't enough ether to initialize " + etherAmount.longValue() + " WEI to " + receiverAddress);
        }
        this.generateRawTransaction(receiverAddress, null, etherAmount, transactionDetail);
        transactionDetail.setNetworkId(this.networkId);
        transactionDetail.setFrom(adminWalletAddress);
        transactionDetail.setTimestamp(System.currentTimeMillis());
        transactionDetail.setAdminOperation(false);
        transactionDetail.setPending(true);
        transactionDetail.setGasPrice(this.walletService.getGasPrice());
        this.getTransactionService().saveTransactionDetail(transactionDetail, false);
        return transactionDetail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TransactionDetail sendToken(TransactionDetail transactionDetail, String issuerUsername) throws Exception {
        if (transactionDetail == null) {
            throw new IllegalArgumentException(TRANSACTION_DETAIL_IS_MANDATORY);
        }
        String receiverAddress = transactionDetail.getTo();
        if (StringUtils.isBlank((CharSequence)receiverAddress)) {
            throw new IllegalArgumentException(RECEIVER_ADDRESS_PARAMETER_IS_MANDATORY);
        }
        if (transactionDetail.getContractAmount() <= 0.0) {
            throw new IllegalArgumentException("token amount parameter has to be positive");
        }
        this.checkAdminWalletIsValid();
        this.setIssuer(transactionDetail, issuerUsername);
        if (StringUtils.isBlank((CharSequence)this.configuredContractAddress)) {
            throw new IllegalStateException(NO_CONFIGURED_CONTRACT_ADDRESS);
        }
        BigInteger tokenAmount = transactionDetail.getContractAmountDecimal(this.configuredContractDecimals.intValue());
        Function transferFunction = this.getTransferFunctionCall(receiverAddress, tokenAmount);
        try {
            this.generateRawTransaction(this.configuredContractAddress, transferFunction, BigInteger.ZERO, transactionDetail);
            transactionDetail.setPending(true);
        }
        catch (Exception e) {
            transactionDetail.setPending(false);
            transactionDetail.setNonce(0L);
        }
        finally {
            transactionDetail.setNetworkId(this.networkId);
            transactionDetail.setFrom(this.getAdminWalletAddress());
            transactionDetail.setContractAddress(this.configuredContractAddress);
            transactionDetail.setContractMethodName("transfer");
            transactionDetail.setTimestamp(System.currentTimeMillis());
            transactionDetail.setAdminOperation(false);
            if (StringUtils.isNotBlank((CharSequence)transactionDetail.getHash())) {
                this.getTransactionService().saveTransactionDetail(transactionDetail, false);
            }
        }
        return transactionDetail;
    }

    public final TransactionDetail reward(TransactionDetail transactionDetail, String issuerUsername) throws Exception {
        return this.sendToken(transactionDetail, issuerUsername);
    }

    public void boostAdminTransactions() {
        List pendingTransactions = this.getTransactionService().getPendingWalletTransactionsSent(this.getAdminWalletAddress());
        double gasPrice = this.walletService.getGasPrice();
        for (TransactionDetail transactionDetail : pendingTransactions) {
            boolean exceededWaitTime;
            boolean newGasPriceIsHigher = transactionDetail.getGasPrice() < gasPrice;
            boolean alreadyBoosted = transactionDetail.isBoost();
            long sentTimestamp = transactionDetail.getSentTimestamp();
            boolean bl = exceededWaitTime = sentTimestamp > 0L && System.currentTimeMillis() - sentTimestamp > 0x6DDD00L;
            if (!newGasPriceIsHigher || alreadyBoosted || !exceededWaitTime) continue;
            LOG.info("Boost transaction {} which was sent since {}", new Object[]{transactionDetail.getHash(), new Date(sentTimestamp)});
            TransactionDetail boostedTransaction = transactionDetail.clone();
            boostedTransaction.setId(0L);
            boostedTransaction.setHash(null);
            boostedTransaction.setBoost(true);
            boostedTransaction.setSentTimestamp(0L);
            boostedTransaction.setSendingAttemptCount(0L);
            boostedTransaction.setPending(true);
            try {
                if (transactionDetail.getContractAmount() > 0.0) {
                    this.sendToken(boostedTransaction, null);
                } else {
                    this.sendEther(boostedTransaction, null);
                }
                transactionDetail.setPending(false);
                transactionDetail.setDropped(true);
                this.transactionService.saveTransactionDetail(transactionDetail, true);
            }
            catch (Exception e) {
                LOG.warn("Can't boost transaction {} with the new one {}", new Object[]{transactionDetail.getHash(), boostedTransaction.getHash(), e});
            }
        }
    }

    public void retrieveWalletInformationFromBlockchain(org.exoplatform.wallet.model.Wallet wallet, ContractDetail contractDetail, Set<String> walletModifications) throws Exception {
        if (wallet == null) {
            throw new IllegalArgumentException("wallet is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)wallet.getAddress())) {
            return;
        }
        if (contractDetail == null || StringUtils.isBlank((CharSequence)contractDetail.getAddress()) || contractDetail.getDecimals() == null) {
            throw new IllegalArgumentException("contractDetail is mandatory");
        }
        String walletAddress = wallet.getAddress();
        BigInteger walletEtherBalance = this.getEtherBalanceOf(walletAddress);
        wallet.setEtherBalance(Double.valueOf(WalletUtils.convertFromDecimals((BigInteger)walletEtherBalance, (int)18)));
        if (wallet.getTokenBalance() == null || walletModifications == null || walletModifications.contains("transfer") || walletModifications.contains("transferFrom")) {
            BigInteger walletTokenBalance = this.getTokenBalanceOf(walletAddress);
            wallet.setTokenBalance(Double.valueOf(WalletUtils.convertFromDecimals((BigInteger)walletTokenBalance, (int)this.configuredContractDecimals)));
        }
    }

    public Map<String, Object> getStatisticParameters(String operation, Object result, Object ... methodArgs) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (this.networkId > 0L && StringUtils.isNotBlank((CharSequence)this.websocketURL)) {
            if (this.websocketURLSuffix == null) {
                String[] urlParts = this.websocketURL.split("/");
                this.websocketURLSuffix = urlParts[urlParts.length - 1];
            }
            parameters.put("blockchain_network_url_suffix", this.websocketURLSuffix);
            parameters.put("blockchain_network_id", this.networkId);
        }
        if (!StringUtils.equals((CharSequence)"eth_call", (CharSequence)operation)) {
            LOG.warn("Statistic type {} is not managed", new Object[]{operation});
            return null;
        }
        parameters.put("contract_address", methodArgs[0]);
        parameters.put("contract_method", methodArgs[1]);
        return parameters;
    }

    public String generateHash(String rawTransaction) {
        return Hash.sha3((String)rawTransaction);
    }

    public final BigInteger getTokenBalanceOfFromBlockchain(String address) throws Exception {
        if (StringUtils.isBlank((CharSequence)address)) {
            throw new IllegalArgumentException(RECEIVER_ADDRESS_PARAMETER_IS_MANDATORY);
        }
        String contractAddress = this.checkContractAddress();
        return (BigInteger)this.executeReadOperation(contractAddress, "balanceOf", address);
    }

    @ExoWalletStatistic(service="blockchain", local=false, operation="eth_call")
    public Object executeReadOperation(String contractAddress, String methodName, Object ... arguments) throws Exception {
        String string = contractAddress;
        String string2 = methodName;
        Object[] objectArray = arguments;
        Object[] objectArray2 = new Object[]{string, string2, objectArray};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray2);
        Object[] objectArray3 = new Object[]{this, string, string2, objectArray, joinPoint};
        EthereumWalletTokenAdminService$AjcClosure1 ethereumWalletTokenAdminService$AjcClosure1 = new EthereumWalletTokenAdminService$AjcClosure1(objectArray3);
        return ExoWalletStatisticAspect.aspectOf().around(ethereumWalletTokenAdminService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private void createAdminWalletAsync() {
        CompletableFuture.runAsync(() -> {
            ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
            RequestLifeCycle.begin((ExoContainer)this.container);
            try {
                org.exoplatform.wallet.model.Wallet adminWallet = this.getAccountService().getAdminWallet();
                if (adminWallet == null || StringUtils.isBlank((CharSequence)adminWallet.getAddress())) {
                    if (StringUtils.isBlank((CharSequence)this.adminPrivateKey)) {
                        this.createAdminAccount();
                    } else {
                        this.createAdminAccount(this.adminPrivateKey, this.getUserACL().getSuperUser());
                        LOG.warn((Object)"Admin wallet private key has been imported, you can delete it from property to keep it safe");
                    }
                } else if (StringUtils.isNotBlank((CharSequence)this.adminPrivateKey)) {
                    LOG.warn((Object)"Admin wallet private key has been already imported, you can delete it from property to keep it safe!");
                }
            }
            catch (Exception e) {
                LOG.warn((Object)"Error while creating Admin wallet", (Throwable)e);
            }
            finally {
                RequestLifeCycle.end();
            }
        });
    }

    private void generateRawTransaction(String toAddress, Function function, BigInteger etherValueInWei, TransactionDetail transactionDetail) throws Exception {
        Credentials adminCredentials = this.getAdminCredentials();
        if (adminCredentials == null) {
            throw new IllegalStateException("Can't find admin credentials");
        }
        double adminGasPrice = this.walletService.getGasPrice();
        BigInteger gasPrice = BigDecimal.valueOf(adminGasPrice).toBigInteger();
        transactionDetail.setGasPrice(adminGasPrice);
        BigInteger gasLimit = BigInteger.valueOf(WalletUtils.getGasLimit());
        if (transactionDetail.getNonce() == 0L) {
            BigInteger nonceToUse = this.getAdminNonce();
            transactionDetail.setNonce(nonceToUse.longValue());
        }
        RawTransaction rawTransaction = null;
        if (function != null) {
            String transactionData = FunctionEncoder.encode((Function)function);
            rawTransaction = RawTransaction.createTransaction((BigInteger)BigInteger.valueOf(transactionDetail.getNonce()), (BigInteger)gasPrice, (BigInteger)gasLimit, (String)toAddress, (BigInteger)etherValueInWei, (String)transactionData);
        } else {
            rawTransaction = RawTransaction.createEtherTransaction((BigInteger)BigInteger.valueOf(transactionDetail.getNonce()), (BigInteger)gasPrice, (BigInteger)gasLimit, (String)toAddress, (BigInteger)etherValueInWei);
        }
        byte[] signedMessage = TransactionEncoder.signMessage((RawTransaction)rawTransaction, (long)WalletUtils.getNetworkId(), (Credentials)adminCredentials);
        String rawTransactionString = Numeric.toHexString((byte[])signedMessage);
        transactionDetail.setRawTransaction(rawTransactionString);
        transactionDetail.setHash(this.generateHash(rawTransactionString));
    }

    private BigInteger getAdminNonce() throws IOException {
        String adminAddress = this.getAdminWalletAddress();
        if (System.currentTimeMillis() - this.adminBlockchainNonceLastUpdate > 15000L) {
            try {
                this.adminBlockchainNonce = this.getClientConnector().getNonce(adminAddress, DefaultBlockParameterName.PENDING).longValue();
                this.adminBlockchainNonceLastUpdate = System.currentTimeMillis();
            }
            catch (Exception e) {
                LOG.warn((Object)"Error retrieving nonce of admin wallet, use last sent nonce", (Throwable)e);
            }
        }
        long storedNonce = this.getTransactionService().getNonce(adminAddress);
        return BigInteger.valueOf(Long.max(this.adminBlockchainNonce, storedNonce));
    }

    private MeedsToken getContractInstance(String contractAddress) {
        Web3j web3j = this.getClientConnector().getWeb3j(false);
        if (this.ertInstance == null) {
            double adminGasPrice = this.walletService.getGasPrice();
            BigInteger gasPrice = BigDecimal.valueOf(adminGasPrice).toBigInteger();
            BigInteger gasLimit = BigInteger.valueOf(WalletUtils.getGasLimit());
            this.ertInstance = MeedsToken.load((String)contractAddress, (Web3j)web3j, (TransactionManager)new ReadonlyTransactionManager(web3j, Address.DEFAULT.toString()), (ContractGasProvider)new StaticGasProvider(gasPrice, gasLimit));
        }
        return this.ertInstance;
    }

    private String checkContractAddress() {
        if (StringUtils.isBlank((CharSequence)this.configuredContractAddress)) {
            throw new IllegalStateException(NO_CONFIGURED_CONTRACT_ADDRESS);
        }
        return this.configuredContractAddress;
    }

    private void setIssuer(TransactionDetail transactionDetail, String issuerUsername) {
        if (StringUtils.isNotBlank((CharSequence)issuerUsername)) {
            org.exoplatform.wallet.model.Wallet issuerWallet = this.getAccountService().getWalletByTypeAndId(WalletType.USER.name(), issuerUsername);
            if (issuerWallet == null) {
                throw new IllegalStateException("Can't find identity of user with id " + issuerUsername);
            }
            transactionDetail.setIssuer(issuerWallet);
        }
    }

    private final void checkAdminWalletIsValid() {
        String adminAddress = this.getAdminWalletAddress();
        if (adminAddress == null) {
            throw new IllegalStateException("No admin wallet is set");
        }
    }

    private Credentials getAdminCredentials() {
        ECKeyPair adminWalletKeys = (ECKeyPair)this.getAdminWalletKeys();
        if (adminWalletKeys == null) {
            return null;
        }
        return Credentials.create((ECKeyPair)adminWalletKeys);
    }

    private Object getAdminWalletKeys() {
        String privateKey = this.getAccountService().getPrivateKeyByTypeAndId(WalletType.ADMIN.getId(), "admin");
        if (StringUtils.isBlank((CharSequence)privateKey)) {
            return null;
        }
        WalletFile adminWallet = null;
        try {
            ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
            adminWallet = (WalletFile)objectMapper.readerFor(WalletFile.class).readValue(privateKey);
        }
        catch (Exception e) {
            throw new IllegalStateException("An error occurred while parsing admin wallet keys", e);
        }
        try {
            return Wallet.decrypt((String)this.accountService.getAdminAccountPassword(), (WalletFile)adminWallet);
        }
        catch (CipherException e) {
            throw new IllegalStateException("Can't descrypt stored admin wallet", e);
        }
    }

    private Method getMethod(String methodName) {
        Method[] methods;
        Method methodToInvoke = null;
        for (Method method : methods = MeedsToken.class.getDeclaredMethods()) {
            if (!StringUtils.equals((CharSequence)methodName, (CharSequence)method.getName())) continue;
            methodToInvoke = method;
        }
        return methodToInvoke;
    }

    private ContractDetail getPrincipalContractDetail() {
        GlobalSettings settings = WalletUtils.getSettings();
        return settings.getContractDetail();
    }

    private WalletTransactionService getTransactionService() {
        if (this.transactionService == null) {
            this.transactionService = (WalletTransactionService)CommonsUtils.getService(WalletTransactionService.class);
        }
        return this.transactionService;
    }

    private WalletStorage getAccountStorage() {
        if (this.accountStorage == null) {
            this.accountStorage = (WalletStorage)CommonsUtils.getService(WalletStorage.class);
        }
        return this.accountStorage;
    }

    private WalletAccountService getAccountService() {
        if (this.accountService == null) {
            this.accountService = (WalletAccountService)CommonsUtils.getService(WalletAccountService.class);
        }
        return this.accountService;
    }

    private WalletContractService getContractService() {
        if (this.walletContractService == null) {
            this.walletContractService = (WalletContractService)CommonsUtils.getService(WalletContractService.class);
        }
        return this.walletContractService;
    }

    private EthereumClientConnector getClientConnector() {
        return this.clientConnector;
    }

    private UserACL getUserACL() {
        if (this.userACL == null) {
            this.userACL = (UserACL)CommonsUtils.getService(UserACL.class);
        }
        return this.userACL;
    }

    private Function getTransferFunctionCall(String toAddress, BigInteger tokenAmount) {
        return new Function("transfer", Arrays.asList(new Address(toAddress), new Uint256(tokenAmount)), Collections.emptyList());
    }

    static {
        EthereumWalletTokenAdminService.ajc$preClinit();
        LOG = ExoLogger.getLogger(EthereumWalletTokenAdminService.class);
    }

    static /* synthetic */ Object executeReadOperation_aroundBody0(EthereumWalletTokenAdminService ajc$this, String contractAddress, String methodName, Object[] arguments, JoinPoint joinPoint) {
        MeedsToken contractInstance = ajc$this.getContractInstance(contractAddress);
        Method methodToInvoke = ajc$this.getMethod(methodName);
        if (methodToInvoke == null) {
            throw new IllegalStateException("Can't find method " + methodName + " in Token instance");
        }
        RemoteCall response = (RemoteCall)methodToInvoke.invoke((Object)contractInstance, arguments);
        return response.send();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("EthereumWalletTokenAdminService.java", EthereumWalletTokenAdminService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("81", "executeReadOperation", "org.exoplatform.wallet.blockchain.service.EthereumWalletTokenAdminService", "java.lang.String:java.lang.String:[Ljava.lang.Object;", "contractAddress:methodName:arguments", "java.lang.Exception", "java.lang.Object"), 499);
    }
}

