/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.branding;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.ByteArrayInputStream;
import java.util.Date;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.portal.branding.model.Background;
import org.exoplatform.portal.branding.model.Branding;
import org.exoplatform.portal.branding.model.Favicon;
import org.exoplatform.portal.branding.model.Logo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/v1/platform/branding")
@Tag(name="/v1/platform/branding", description="Managing branding information")
public class BrandingRestResourcesV1
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(BrandingRestResourcesV1.class);
    private static final String IMAGE_MIME_TYPE = "image/png";
    private static final int CACHE_IN_SECONDS = 31536000;
    private static final int CACHE_IN_MILLI_SECONDS = 1471228928;
    private BrandingService brandingService;

    public BrandingRestResourcesV1(BrandingService brandingService) {
        this.brandingService = brandingService;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Get Branding information", description="Get Branding information", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="304", description="Resource not modified"), @ApiResponse(responseCode="500", description="Server error when retrieving branding information")})
    public Response getBrandingInformation(@Context Request request) {
        try {
            long lastUpdated = this.brandingService.getLastUpdatedTime();
            EntityTag eTag = new EntityTag(String.valueOf(lastUpdated));
            Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
            if (builder == null) {
                Branding brandingInformation = this.brandingService.getBrandingInformation(false);
                builder = Response.ok((Object)brandingInformation);
                CacheControl cc = new CacheControl();
                cc.setMustRevalidate(true);
                builder.tag(eTag);
                builder.lastModified(new Date(lastUpdated));
                builder.expires(new Date(System.currentTimeMillis() + 1471228928L));
                builder.cacheControl(cc);
            }
            return builder.build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when retrieving branding information", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update Branding information", description="Update Branding information", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Branding information updated"), @ApiResponse(responseCode="500", description="Server error when updating branding information")})
    public Response updateBrandingInformation(Branding branding) {
        try {
            this.brandingService.updateBrandingInformation(branding);
            return Response.noContent().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when updating branding information", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/logo")
    @Produces(value={"image/png"})
    @Operation(summary="Get Branding logo", description="Get Branding logo", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Branding logo retrieved"), @ApiResponse(responseCode="404", description="Branding logo not found"), @ApiResponse(responseCode="500", description="Server error when retrieving branding logo")})
    public Response getBrandingLogo(@Context Request request, @Parameter(description="The value of lastModified parameter will determine whether the query should be cached by browser or not. If not set, no 'expires HTTP Header will be sent'") @QueryParam(value="lastModified") String lastModified, @Parameter(description="The value of version parameter will determine whether the query should be cached by browser or not. If not set, no 'expires HTTP Header will be sent'") @QueryParam(value="v") String version) {
        Logo logo = this.brandingService.getLogo();
        if (logo == null || logo.getData() == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        long lastUpdated = logo.getUpdatedDate();
        EntityTag eTag = new EntityTag(String.valueOf(lastUpdated));
        Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
        if (builder == null) {
            ByteArrayInputStream stream = new ByteArrayInputStream(logo.getData());
            builder = Response.ok((Object)stream, (String)IMAGE_MIME_TYPE);
            if (StringUtils.isNotBlank((CharSequence)lastModified) || StringUtils.isNotBlank((CharSequence)version)) {
                CacheControl cc = new CacheControl();
                cc.setMaxAge(31536000);
                builder.tag(eTag);
                builder.lastModified(new Date(lastUpdated));
                builder.expires(new Date(System.currentTimeMillis() + 1471228928L));
                builder.cacheControl(cc);
            }
        }
        return builder.build();
    }

    @GET
    @Path(value="/favicon")
    @Produces(value={"image/png"})
    @Operation(summary="Get Branding favicon", description="Get Branding favicon", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Branding favicon retrieved"), @ApiResponse(responseCode="404", description="Branding favicon not found"), @ApiResponse(responseCode="500", description="Server error when retrieving branding favicon")})
    public Response getBrandingFavicon(@Context Request request, @Parameter(description="The value of lastModified parameter will determine whether the query should be cached by browser or not. If not set, no 'expires HTTP Header will be sent'") @QueryParam(value="lastModified") String lastModified, @Parameter(description="The value of version parameter will determine whether the query should be cached by browser or not. If not set, no 'expires HTTP Header will be sent'") @QueryParam(value="v") String version) {
        Favicon favicon = this.brandingService.getFavicon();
        if (favicon == null || favicon.getData() == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        long lastUpdated = favicon.getUpdatedDate();
        EntityTag eTag = new EntityTag(String.valueOf(lastUpdated));
        Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
        if (builder == null) {
            ByteArrayInputStream stream = new ByteArrayInputStream(favicon.getData());
            builder = Response.ok((Object)stream, (String)IMAGE_MIME_TYPE);
            if (StringUtils.isNotBlank((CharSequence)lastModified) || StringUtils.isNotBlank((CharSequence)version)) {
                CacheControl cc = new CacheControl();
                cc.setMaxAge(31536000);
                builder.tag(eTag);
                builder.lastModified(new Date(lastUpdated));
                builder.expires(new Date(System.currentTimeMillis() + 1471228928L));
                builder.cacheControl(cc);
            }
        }
        return builder.build();
    }

    @GET
    @Path(value="/loginBackground")
    @Produces(value={"image/png"})
    @Operation(summary="Get authentication pages left panel background", description="Get authentication pages left panel background", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fullfilled"), @ApiResponse(responseCode="404", description="Resource not found"), @ApiResponse(responseCode="500", description="Server error when retrieving resource")})
    public Response getLoginBackground(@Context Request request, @Parameter(description="The value of lastModified parameter will determine whether the query should be cached by browser or not. If not set, no 'expires HTTP Header will be sent'") @QueryParam(value="lastModified") String lastModified, @Parameter(description="The value of version parameter will determine whether the query should be cached by browser or not. If not set, no 'expires HTTP Header will be sent'") @QueryParam(value="v") String version) {
        Background loginBackground = this.brandingService.getLoginBackground();
        if (loginBackground == null || loginBackground.getData() == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        long lastUpdated = loginBackground.getUpdatedDate();
        EntityTag eTag = new EntityTag(String.valueOf(lastUpdated));
        Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
        if (builder == null) {
            ByteArrayInputStream stream = new ByteArrayInputStream(loginBackground.getData());
            builder = Response.ok((Object)stream, (String)IMAGE_MIME_TYPE);
            if (StringUtils.isNotBlank((CharSequence)lastModified) || StringUtils.isNotBlank((CharSequence)version)) {
                CacheControl cc = new CacheControl();
                cc.setMaxAge(31536000);
                builder.tag(eTag);
                builder.lastModified(new Date(lastUpdated));
                builder.expires(new Date(System.currentTimeMillis() + 1471228928L));
                builder.cacheControl(cc);
            }
        }
        return builder.build();
    }

    @GET
    @Path(value="/css")
    @Operation(summary="Get Branding CSS content", description="Get Branding CSS content", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Branding css retrieved"), @ApiResponse(responseCode="304", description="Branding css not modified"), @ApiResponse(responseCode="500", description="Server error when retrieving branding css")})
    public Response getBrandingCSS(@Context Request request, @Parameter(description="The value of lastModified parameter will determine whether the query should be cached by browser or not. If not set, no 'expires HTTP Header will be sent'") @QueryParam(value="v") String lastModified) {
        long lastUpdated = this.brandingService.getLastUpdatedTime();
        EntityTag eTag = new EntityTag(String.valueOf(lastUpdated));
        Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
        if (builder == null) {
            String themeCSS = this.brandingService.getThemeCSSContent();
            builder = Response.ok((Object)themeCSS, (String)"text/css");
            builder.tag(eTag);
        }
        CacheControl cc = new CacheControl();
        cc.setMaxAge(86400);
        builder.type("text/css");
        builder.tag(eTag);
        builder.lastModified(new Date(lastUpdated));
        if (StringUtils.isNotBlank((CharSequence)lastModified)) {
            builder.expires(new Date(System.currentTimeMillis() + 1471228928L));
        }
        builder.cacheControl(cc);
        return builder.cacheControl(cc).build();
    }
}

