/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.perkstore.service.utils;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.NotificationPluginUtils;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.perkstore.model.GlobalSettings;
import org.exoplatform.perkstore.model.Product;
import org.exoplatform.perkstore.model.ProductOrder;
import org.exoplatform.perkstore.model.Profile;
import org.exoplatform.perkstore.model.constant.ProductOrderModificationType;
import org.exoplatform.perkstore.model.constant.ProductOrderStatus;
import org.exoplatform.perkstore.model.constant.ProductOrderTransactionStatus;
import org.exoplatform.perkstore.service.utils.Utils;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;
import org.exoplatform.webui.utils.TimeConvertUtils;

public class NotificationUtils {
    public static final ArgumentLiteral<GlobalSettings> SETTINGS_PARAMETER = new ArgumentLiteral(GlobalSettings.class, "settings");
    public static final ArgumentLiteral<Product> PRODUCT_PARAMETER = new ArgumentLiteral(Product.class, "product");
    public static final ArgumentLiteral<Boolean> PRODUCT_IS_NEW_PARAMETER = new ArgumentLiteral(Boolean.class, "product.new");
    public static final ArgumentLiteral<ProductOrder> NEW_ORDER_PARAMETER = new ArgumentLiteral(ProductOrder.class, "newOrder");
    public static final ArgumentLiteral<ProductOrder> OLD_ORDER_PARAMETER = new ArgumentLiteral(ProductOrder.class, "oldOrder");
    public static final ArgumentLiteral<Profile> MODIFIER_PARAMETER = new ArgumentLiteral(Profile.class, "modifier");
    public static final ArgumentLiteral<ProductOrderModificationType> ORDER_MODIFICATION_TYPE_PARAMETER = new ArgumentLiteral(ProductOrderModificationType.class, "orderModificationType");
    public static final ArgumentLiteral<Boolean> ORDER_IS_NEW_PARAMETER = new ArgumentLiteral(Boolean.class, "order.new");
    public static final String PERKSTORE_PRODUCT_ADDED_NOTIFICATION_PLUGIN = "ProductAddedNotificationPlugin";
    public static final String PERKSTORE_PRODUCT_MODIFIED_NOTIFICATION_PLUGIN = "ProductModifiedNotificationPlugin";
    public static final String PERKSTORE_ORDER_ADDED_NOTIFICATION_PLUGIN = "OrderAddedNotificationPlugin";
    public static final String PERKSTORE_ORDER_MODIFIED_NOTIFICATION_PLUGIN = "OrderModifiedNotificationPlugin";
    public static final PluginKey ORDER_MODIFIED_KEY = PluginKey.key((String)"OrderModifiedNotificationPlugin");
    public static final PluginKey ORDER_ADDED_KEY = PluginKey.key((String)"OrderAddedNotificationPlugin");
    public static final PluginKey PRODUCT_MODIFIED_KEY = PluginKey.key((String)"ProductModifiedNotificationPlugin");
    public static final PluginKey PRODUCT_ADDED_KEY = PluginKey.key((String)"ProductAddedNotificationPlugin");
    private static final String STORED_PARAMETER_SETTINGS_SYMBOL = "SYMBOL";
    private static final String STORED_PARAMETER_PRODUCT_ID = "PRODUCT_ID";
    private static final String STORED_PARAMETER_PRODUCT_TITLE = "PRODUCT_TITLE";
    private static final String STORED_PARAMETER_PRODUCT_SUPPLY = "PRODUCT_SUPPLY";
    private static final String STORED_PARAMETER_PRODUCT_PRICE = "PRODUCT_PRICE";
    private static final String STORED_PARAMETER_PRODUCT_IS_NEW = "PRODUCT_IS_NEW";
    private static final String STORED_PARAMETER_ORDER_ID = "ORDER_ID";
    private static final String STORED_PARAMETER_ORDER_STATUS = "ORDER_STATUS";
    private static final String STORED_PARAMETER_QUANTITY_ORDER = "ORDER_QUANTITY";
    private static final String STORED_PARAMETER_ORDER_DELIVERED_QUANTITY = "ORDER_DELIVERED_QUANTITY";
    private static final String STORED_PARAMETER_NEW_ORDER_DELIVERED_QUANTITY = "NEW_ORDER_DELIVERED_QUANTITY";
    private static final String STORED_PARAMETER_ORDER_REFUND_TX_STATUS = "ORDER_REFUNDED_TX_STATUS";
    private static final String STORED_PARAMETER_ORDER_REFUNDED_QUANTITY = "ORDER_REFUNDED_QUANTITY";
    private static final String STORED_PARAMETER_ORDER_REFUNDED_AMOUNT = "ORDER_REFUNDED_AMOUNT";
    private static final String STORED_PARAMETER_ORDER_REMAINING_QUANTITY = "ORDER_REMAINING_QUANTITY";
    private static final String STORED_PARAMETER_ORDER_IS_NEW = "ORDER_IS_NEW";
    private static final String STORED_PARAMETER_ORDER_MODIFICATION_TYPE = "ORDER_MODIFICATION_TYPE";
    private static final String STORED_PARAMETER_MODIFIER_IDENTITY_ID = "MODIFIER_ID";
    private static final String STORED_PARAMETER_SENDER_IDENTITY_ID = "SENDER_ID";
    private static final String STORED_PARAMETER_RECEIVER_IDENTITY_ID = "RECEIVER_ID";
    private static final String TEMPLATE_VARIABLE_SETTINGS_SYMBOL = "symbol";
    private static final String TEMPLATE_VARIABLE_PRODUCT_ID = "productId";
    private static final String TEMPLATE_VARIABLE_PRODUCT_TITLE = "productTitle";
    private static final String TEMPLATE_VARIABLE_PRODUCT_SUPPLY = "productSupply";
    private static final String TEMPLATE_VARIABLE_PRODUCT_PRICE = "productPrice";
    private static final String TEMPLATE_VARIABLE_PRODUCT_IS_NEW = "isNewProduct";
    private static final String TEMPLATE_VARIABLE_ORDER_ID = "orderId";
    private static final String TEMPLATE_VARIABLE_ORDER_STATUS = "orderStatus";
    private static final String TEMPLATE_VARIABLE_ORDER_LABEL_STATUS = "orderStatusLabel";
    private static final String TEMPLATE_VARIABLE_ORDER_QUANTITY = "orderQuantity";
    private static final String TEMPLATE_VARIABLE_ORDER_DELIVERED_QUANTITY = "orderDeliveredQuantity";
    private static final String TEMPLATE_VARIABLE_NEW_ORDER_DELIVERED_QUANTITY = "newOrderDeliveredQuantity";
    private static final String TEMPLATE_VARIABLE_ORDER_REFUNDED_QUANTITY = "orderRefundedQuantity";
    private static final String TEMPLATE_VARIABLE_ORDER_REFUND_TX_STATUS = "orderRefundTransactionStatus";
    private static final String TEMPLATE_VARIABLE_ORDER_REFUNDED_AMOUNT = "orderRefundedAmount";
    private static final String TEMPLATE_VARIABLE_ORDER_REMAINING_QUANTITY = "orderRemainingQuantity";
    private static final String TEMPLATE_VARIABLE_ORDER_IS_NEW = "isNewOrder";
    private static final String TEMPLATE_VARIABLE_ORDER_MODIFICATION_TYPE = "modificationType";
    private static final String TEMPLATE_VARIABLE_NOTIFICATION_URL = "detailsURL";
    private static final String TEMPLATE_VARIABLE_PREFIX_ORDER_IDENTITY = "isOrder";
    private static final String TEMPLATE_VARIABLE_SUFFIX_IDENTITY_ID = "Id";
    private static final String TEMPLATE_VARIABLE_SUFFIX_IDENTITY_AVATAR = "Avatar";
    private static final String TEMPLATE_VARIABLE_SUFFIX_IDENTITY_NAME = "Name";
    private static final String TEMPLATE_VARIABLE_SUFFIX_IDENTITY_URL = "Url";
    private static final String TEMPLATE_VARIABLE_SUFFIX_IS_SPACE_TYPE = "IsSpaceType";
    private static String defaultSite;

    private NotificationUtils() {
    }

    public static final GlobalSettings getSettingsParameter(NotificationContext ctx) {
        return (GlobalSettings)ctx.value(SETTINGS_PARAMETER);
    }

    public static final Product getProductParameter(NotificationContext ctx) {
        return (Product)ctx.value(PRODUCT_PARAMETER);
    }

    public static final ProductOrder getOldOrderParameter(NotificationContext ctx) {
        return (ProductOrder)ctx.value(OLD_ORDER_PARAMETER);
    }

    public static final Profile getModifierParameter(NotificationContext ctx) {
        return (Profile)ctx.value(MODIFIER_PARAMETER);
    }

    public static final ProductOrder getUpdatedOrderParameter(NotificationContext ctx) {
        return (ProductOrder)ctx.value(NEW_ORDER_PARAMETER);
    }

    public static final ProductOrderModificationType getOrderModificationTypeParameter(NotificationContext ctx) {
        return (ProductOrderModificationType)((Object)ctx.value(ORDER_MODIFICATION_TYPE_PARAMETER));
    }

    public static final boolean isNewProductParameter(NotificationContext ctx) {
        Boolean value = (Boolean)ctx.value(PRODUCT_IS_NEW_PARAMETER);
        return value != null && value != false;
    }

    public static final boolean isNewOrderParameter(NotificationContext ctx) {
        Boolean value = (Boolean)ctx.value(ORDER_IS_NEW_PARAMETER);
        return value != null && value != false;
    }

    public static final void setSettingsParameter(NotificationContext ctx, GlobalSettings settings) {
        ctx.append(SETTINGS_PARAMETER, (Object)settings);
    }

    public static final void setProductParameter(NotificationContext ctx, Product product) {
        ctx.append(PRODUCT_PARAMETER, (Object)product);
    }

    public static final void setOrderParameter(NotificationContext ctx, ProductOrder order) {
        ctx.append(NEW_ORDER_PARAMETER, (Object)order);
    }

    public static final void setIsNewProductParameter(NotificationContext ctx) {
        ctx.append(PRODUCT_IS_NEW_PARAMETER, (Object)true);
    }

    public static final void setIsNewOrderParameter(NotificationContext ctx) {
        ctx.append(ORDER_IS_NEW_PARAMETER, (Object)true);
    }

    public static final void setNotificationRecipients(NotificationInfo notification, GlobalSettings globalSettings, Product product, ProductOrder order, boolean newProduct, boolean newOrder, Profile modifier) {
        HashSet<String> ignoredUsers = new HashSet<String>();
        HashSet<String> recipientList = new HashSet<String>();
        if (order == null) {
            List<Profile> applicationAccessPermissions;
            if (newProduct) {
                ignoredUsers.add(product.getCreator().getId());
            } else {
                ignoredUsers.add(product.getLastModifier().getId());
            }
            List<Profile> productAccessPermissions = product.getAccessPermissions();
            if (productAccessPermissions == null || productAccessPermissions.isEmpty()) {
                productAccessPermissions = null;
            }
            if ((applicationAccessPermissions = globalSettings.getAccessPermissionsProfiles()) == null || applicationAccessPermissions.isEmpty()) {
                applicationAccessPermissions = null;
            }
            if (productAccessPermissions != null && applicationAccessPermissions != null) {
                ArrayList<String> applicationRecipientList = new ArrayList<String>();
                Utils.addIdentityMembersFromProfiles(applicationAccessPermissions, applicationRecipientList);
                Utils.addIdentityMembersFromProfiles(productAccessPermissions, recipientList);
                recipientList.retainAll(applicationRecipientList);
            } else if (productAccessPermissions != null) {
                Utils.addIdentityMembersFromProfiles(productAccessPermissions, recipientList);
            } else if (applicationAccessPermissions != null) {
                Utils.addIdentityMembersFromProfiles(applicationAccessPermissions, recipientList);
            } else {
                Utils.addIdentityMembersFromProfiles(product.getMarchands(), recipientList);
                Utils.addIdentityMembersFromProfiles(Collections.singleton(product.getReceiverMarchand()), recipientList);
            }
        } else if (newOrder) {
            ignoredUsers.add(order.getSender().getId());
            Utils.addIdentityMembersFromProfiles(product.getMarchands(), recipientList);
        } else {
            if (modifier != null) {
                ignoredUsers.add(modifier.getId());
            }
            recipientList.add(order.getSender().getId());
            Utils.addIdentityMembersFromProfiles(product.getMarchands(), recipientList);
        }
        recipientList.removeAll(ignoredUsers);
        notification.to(new ArrayList<String>(recipientList));
    }

    public static final void storeOrderParameters(NotificationInfo notification, ProductOrder oldOrder, ProductOrder updatedOrder, ProductOrderModificationType orderModificationType, boolean isNew, Profile modifier) {
        if (updatedOrder.getReceiver() == null || updatedOrder.getReceiver().getTechnicalId() == 0L) {
            throw new IllegalStateException("receiver is null");
        }
        if (updatedOrder.getSender() == null || updatedOrder.getSender().getTechnicalId() == 0L) {
            throw new IllegalStateException("sender is null");
        }
        if (modifier != null) {
            notification.with(STORED_PARAMETER_MODIFIER_IDENTITY_ID, String.valueOf(modifier.getTechnicalId()));
        }
        String status = updatedOrder.getStatus();
        if (orderModificationType == ProductOrderModificationType.TX_STATUS) {
            status = StringUtils.equals((String)ProductOrderTransactionStatus.SUCCESS.name(), (String)updatedOrder.getTransactionStatus()) ? ProductOrderStatus.PAID.name() : ProductOrderStatus.ERROR.name();
        } else if (orderModificationType == ProductOrderModificationType.REFUND_TX_STATUS) {
            status = ProductOrderStatus.REFUNDED.name();
        }
        double newlyDeliveredQuantity = updatedOrder.getDeliveredQuantity() - (oldOrder == null ? 0.0 : oldOrder.getDeliveredQuantity());
        notification.with(STORED_PARAMETER_ORDER_ID, String.valueOf(updatedOrder.getId())).with(STORED_PARAMETER_RECEIVER_IDENTITY_ID, String.valueOf(updatedOrder.getReceiver().getTechnicalId())).with(STORED_PARAMETER_SENDER_IDENTITY_ID, String.valueOf(updatedOrder.getSender().getTechnicalId())).with(STORED_PARAMETER_ORDER_STATUS, status).with(STORED_PARAMETER_QUANTITY_ORDER, NotificationUtils.stringifyDouble(updatedOrder.getQuantity())).with(STORED_PARAMETER_ORDER_DELIVERED_QUANTITY, NotificationUtils.stringifyDouble(updatedOrder.getDeliveredQuantity())).with(STORED_PARAMETER_NEW_ORDER_DELIVERED_QUANTITY, NotificationUtils.stringifyDouble(newlyDeliveredQuantity)).with(STORED_PARAMETER_ORDER_REFUND_TX_STATUS, updatedOrder.getRefundTransactionStatus()).with(STORED_PARAMETER_ORDER_MODIFICATION_TYPE, orderModificationType.name()).with(STORED_PARAMETER_ORDER_REFUNDED_AMOUNT, NotificationUtils.stringifyDouble(updatedOrder.getRefundedAmount())).with(STORED_PARAMETER_ORDER_REFUNDED_QUANTITY, NotificationUtils.stringifyDouble(updatedOrder.getRefundedQuantity())).with(STORED_PARAMETER_ORDER_REMAINING_QUANTITY, NotificationUtils.stringifyDouble(updatedOrder.getRemainingQuantityToProcess())).with(STORED_PARAMETER_ORDER_IS_NEW, String.valueOf(isNew));
    }

    public static final void storeSettingsParameters(GlobalSettings globalSettings, NotificationInfo notification) {
        String symbol = globalSettings.getSymbol();
        if (symbol == null) {
            symbol = "";
        }
        notification.with(STORED_PARAMETER_SETTINGS_SYMBOL, symbol);
    }

    public static final void storeProductParameters(NotificationInfo notification, Product product, boolean isNew) {
        if (product.getCreator() == null || product.getCreator().getTechnicalId() == 0L) {
            throw new IllegalStateException("creator is null");
        }
        if (!(isNew || product.getLastModifier() != null && product.getLastModifier().getTechnicalId() != 0L)) {
            throw new IllegalStateException("last modifier is null");
        }
        long modifierId = isNew ? product.getCreator().getTechnicalId() : product.getLastModifier().getTechnicalId();
        notification.with(STORED_PARAMETER_PRODUCT_ID, String.valueOf(product.getId())).with(STORED_PARAMETER_SENDER_IDENTITY_ID, String.valueOf(modifierId)).with(STORED_PARAMETER_PRODUCT_TITLE, product.getTitle()).with(STORED_PARAMETER_PRODUCT_SUPPLY, NotificationUtils.stringifyDouble(product.getTotalSupply())).with(STORED_PARAMETER_PRODUCT_PRICE, NotificationUtils.stringifyDouble(product.getPrice())).with(STORED_PARAMETER_PRODUCT_IS_NEW, String.valueOf(isNew));
    }

    public static final String stringifyDouble(double value) {
        long longValue = (long)value;
        if (value == (double)longValue) {
            return String.format("%d", longValue);
        }
        return String.format("%s", value);
    }

    public static final String getNotificationURL(Product product, ProductOrder productOrder) {
        String currentSite = NotificationUtils.getDefaultSite();
        Object currentDomain = CommonsUtils.getCurrentDomain();
        if (!((String)currentDomain).endsWith("/")) {
            currentDomain = (String)currentDomain + "/";
        }
        String notificationURL = (String)currentDomain + "portal/" + currentSite + "/perkstore?productId=" + product.getId();
        if (productOrder != null) {
            notificationURL = notificationURL + "&orderId=" + productOrder.getId();
        }
        return notificationURL;
    }

    public static String getDefaultSite() {
        if (defaultSite != null) {
            return defaultSite;
        }
        UserPortalConfigService portalConfig = (UserPortalConfigService)CommonsUtils.getService(UserPortalConfigService.class);
        defaultSite = portalConfig.getDefaultPortal();
        return defaultSite;
    }

    public static final TemplateContext buildTemplateParameters(TemplateProvider templateProvider, NotificationInfo notification, String notificationURL) {
        String language = NotificationPluginUtils.getLanguage((String)notification.getTo());
        TemplateContext templateContext = NotificationUtils.getTemplateContext(templateProvider, notification, language);
        NotificationUtils.setFooter(notification, templateContext);
        NotificationUtils.setRead(notification, templateContext);
        NotificationUtils.setNotificationId(notification, templateContext);
        NotificationUtils.setLasModifiedTime(notification, templateContext, language);
        NotificationUtils.setIdentityNameAndAvatar(notification, templateContext, "sender");
        NotificationUtils.setIdentityNameAndAvatar(notification, templateContext, "receiver");
        NotificationUtils.setIdentityNameAndAvatar(notification, templateContext, "modifier");
        NotificationUtils.setSettingsDetails(templateContext, notification);
        NotificationUtils.setProductDetails(templateContext, notification);
        NotificationUtils.setOrderDetails(templateContext, notification);
        templateContext.put((Object)TEMPLATE_VARIABLE_NOTIFICATION_URL, (Object)notificationURL);
        return templateContext;
    }

    public static final MessageInfo buildMessageSubjectAndBody(TemplateContext templateContext, NotificationInfo notification, String pushNotificationURL) {
        MessageInfo messageInfo = new MessageInfo();
        NotificationUtils.setMessageSubject(messageInfo, templateContext, NotificationUtils.getProductTitle(notification), pushNotificationURL);
        NotificationUtils.setMessageBody(templateContext, messageInfo);
        return messageInfo.end();
    }

    private static final void setMessageSubject(MessageInfo messageInfo, TemplateContext templateContext, String title, String pushNotificationURL) {
        if (pushNotificationURL != null) {
            messageInfo.subject(pushNotificationURL);
        } else {
            messageInfo.subject(TemplateUtils.processSubject((TemplateContext)templateContext) + ": " + title);
        }
    }

    private static String getProductTitle(NotificationInfo notification) {
        return notification.getValueOwnerParameter(STORED_PARAMETER_PRODUCT_TITLE);
    }

    private static final TemplateContext getTemplateContext(TemplateProvider templateProvider, NotificationInfo notification, String language) {
        PluginKey pluginKey = notification.getKey();
        String pluginId = pluginKey.getId();
        ChannelKey channelKey = templateProvider.getChannelKey();
        return TemplateContext.newChannelInstance((ChannelKey)channelKey, (String)pluginId, (String)language);
    }

    private static final void setMessageBody(TemplateContext templateContext, MessageInfo messageInfo) {
        messageInfo.body(TemplateUtils.processGroovy((TemplateContext)templateContext));
    }

    private static final void setOrderDetails(TemplateContext templateContext, NotificationInfo notification) {
        String orderId = notification.getValueOwnerParameter(STORED_PARAMETER_ORDER_ID);
        if (StringUtils.isNotBlank((String)orderId)) {
            String isNewString = notification.getValueOwnerParameter(STORED_PARAMETER_ORDER_IS_NEW);
            boolean isNew = StringUtils.isNotBlank((String)isNewString) && Boolean.parseBoolean(isNewString);
            String modificationType = notification.getValueOwnerParameter(STORED_PARAMETER_ORDER_MODIFICATION_TYPE);
            String orderStatus = notification.getValueOwnerParameter(STORED_PARAMETER_ORDER_STATUS);
            String deliveredQuantity = notification.getValueOwnerParameter(STORED_PARAMETER_ORDER_DELIVERED_QUANTITY);
            String newDeliveredQuantity = notification.getValueOwnerParameter(STORED_PARAMETER_NEW_ORDER_DELIVERED_QUANTITY);
            if (StringUtils.isBlank((String)newDeliveredQuantity)) {
                newDeliveredQuantity = deliveredQuantity;
            }
            String refundedQuantity = notification.getValueOwnerParameter(STORED_PARAMETER_ORDER_REFUNDED_QUANTITY);
            String remainingQuantity = notification.getValueOwnerParameter(STORED_PARAMETER_ORDER_REMAINING_QUANTITY);
            String orderRefundedAmount = notification.getValueOwnerParameter(STORED_PARAMETER_ORDER_REFUNDED_AMOUNT);
            String orderRefundTxStatus = notification.getValueOwnerParameter(STORED_PARAMETER_ORDER_REFUND_TX_STATUS);
            if (StringUtils.isBlank((String)orderRefundedAmount)) {
                orderRefundedAmount = "0";
            }
            if (StringUtils.isBlank((String)orderRefundTxStatus)) {
                orderRefundTxStatus = "NONE";
            }
            if (ProductOrderModificationType.valueOf(modificationType) == ProductOrderModificationType.REFUND_TX_STATUS) {
                String orderStatusLabel = ProductOrderStatus.REFUNDED.name().toLowerCase();
                if (StringUtils.equals((String)orderRefundTxStatus, (String)"failed")) {
                    templateContext.put((Object)TEMPLATE_VARIABLE_ORDER_LABEL_STATUS, (Object)("error." + orderStatusLabel));
                } else {
                    templateContext.put((Object)TEMPLATE_VARIABLE_ORDER_LABEL_STATUS, (Object)orderStatusLabel);
                }
            } else if (ProductOrderModificationType.valueOf(modificationType) == ProductOrderModificationType.REFUNDED_QUANTITY) {
                templateContext.put((Object)TEMPLATE_VARIABLE_ORDER_LABEL_STATUS, (Object)ProductOrderStatus.REFUNDED.name().toLowerCase());
            } else if (ProductOrderModificationType.valueOf(modificationType) == ProductOrderModificationType.DELIVERED_QUANTITY) {
                templateContext.put((Object)TEMPLATE_VARIABLE_ORDER_LABEL_STATUS, (Object)ProductOrderStatus.DELIVERED.name().toLowerCase());
            } else {
                templateContext.put((Object)TEMPLATE_VARIABLE_ORDER_LABEL_STATUS, (Object)orderStatus.toLowerCase());
            }
            templateContext.put((Object)TEMPLATE_VARIABLE_ORDER_ID, (Object)orderId);
            templateContext.put((Object)TEMPLATE_VARIABLE_ORDER_STATUS, (Object)orderStatus);
            templateContext.put((Object)TEMPLATE_VARIABLE_ORDER_QUANTITY, (Object)notification.getValueOwnerParameter(STORED_PARAMETER_QUANTITY_ORDER));
            templateContext.put((Object)TEMPLATE_VARIABLE_ORDER_DELIVERED_QUANTITY, (Object)deliveredQuantity);
            templateContext.put((Object)TEMPLATE_VARIABLE_NEW_ORDER_DELIVERED_QUANTITY, (Object)newDeliveredQuantity);
            templateContext.put((Object)TEMPLATE_VARIABLE_ORDER_REFUNDED_QUANTITY, (Object)refundedQuantity);
            templateContext.put((Object)TEMPLATE_VARIABLE_ORDER_REFUNDED_AMOUNT, (Object)orderRefundedAmount);
            templateContext.put((Object)TEMPLATE_VARIABLE_ORDER_REFUND_TX_STATUS, (Object)orderRefundTxStatus);
            templateContext.put((Object)TEMPLATE_VARIABLE_ORDER_REMAINING_QUANTITY, (Object)remainingQuantity);
            templateContext.put((Object)TEMPLATE_VARIABLE_ORDER_MODIFICATION_TYPE, (Object)modificationType);
            templateContext.put((Object)TEMPLATE_VARIABLE_ORDER_IS_NEW, (Object)String.valueOf(isNew));
        }
    }

    private static final void setSettingsDetails(TemplateContext templateContext, NotificationInfo notification) {
        String symbol = notification.getValueOwnerParameter(STORED_PARAMETER_SETTINGS_SYMBOL);
        if (symbol == null) {
            symbol = "";
        }
        templateContext.put((Object)TEMPLATE_VARIABLE_SETTINGS_SYMBOL, (Object)symbol);
    }

    private static final void setProductDetails(TemplateContext templateContext, NotificationInfo notification) {
        String isNewString = notification.getValueOwnerParameter(STORED_PARAMETER_PRODUCT_IS_NEW);
        boolean isNew = StringUtils.isNotBlank((String)isNewString) && Boolean.parseBoolean(isNewString);
        templateContext.put((Object)TEMPLATE_VARIABLE_PRODUCT_ID, (Object)notification.getValueOwnerParameter(STORED_PARAMETER_PRODUCT_ID));
        templateContext.put((Object)TEMPLATE_VARIABLE_PRODUCT_TITLE, (Object)NotificationUtils.getProductTitle(notification));
        templateContext.put((Object)TEMPLATE_VARIABLE_PRODUCT_SUPPLY, (Object)notification.getValueOwnerParameter(STORED_PARAMETER_PRODUCT_SUPPLY));
        templateContext.put((Object)TEMPLATE_VARIABLE_PRODUCT_PRICE, (Object)notification.getValueOwnerParameter(STORED_PARAMETER_PRODUCT_PRICE));
        templateContext.put((Object)TEMPLATE_VARIABLE_PRODUCT_IS_NEW, (Object)String.valueOf(isNew));
    }

    private static final void setIdentityNameAndAvatar(NotificationInfo notification, TemplateContext templateContext, String prefix) {
        Space space;
        String identityId = notification.getValueOwnerParameter(prefix.toUpperCase() + "_ID");
        if (StringUtils.isBlank((String)identityId)) {
            templateContext.put((Object)(prefix + TEMPLATE_VARIABLE_SUFFIX_IDENTITY_ID), (Object)"");
            templateContext.put((Object)(prefix + TEMPLATE_VARIABLE_SUFFIX_IDENTITY_ID), (Object)"");
            templateContext.put((Object)(prefix + TEMPLATE_VARIABLE_SUFFIX_IDENTITY_NAME), (Object)"");
            templateContext.put((Object)(prefix + TEMPLATE_VARIABLE_SUFFIX_IDENTITY_AVATAR), (Object)"");
            templateContext.put((Object)(prefix + TEMPLATE_VARIABLE_SUFFIX_IS_SPACE_TYPE), (Object)"");
            templateContext.put((Object)(prefix + TEMPLATE_VARIABLE_SUFFIX_IDENTITY_URL), (Object)"");
            templateContext.put((Object)(TEMPLATE_VARIABLE_PREFIX_ORDER_IDENTITY + StringUtils.capitalize((String)prefix)), (Object)"false");
            return;
        }
        Identity identity = Utils.getIdentityById(identityId);
        if (identity == null) {
            throw new IllegalStateException("Identity with id " + identityId + " not found, can't send notification");
        }
        boolean isSpaceType = Utils.isSpaceType(identity.getProviderId());
        templateContext.put((Object)(prefix + TEMPLATE_VARIABLE_SUFFIX_IS_SPACE_TYPE), (Object)String.valueOf(isSpaceType));
        String remoteId = identity.getRemoteId();
        templateContext.put((Object)(prefix + TEMPLATE_VARIABLE_SUFFIX_IDENTITY_ID), (Object)remoteId);
        templateContext.put((Object)(TEMPLATE_VARIABLE_PREFIX_ORDER_IDENTITY + StringUtils.capitalize((String)prefix)), (Object)String.valueOf(StringUtils.equals((String)notification.getTo(), (String)remoteId)));
        String fullName = identity.getProfile().getFullName();
        if (StringUtils.isBlank((String)fullName) && isSpaceType && (space = Utils.getSpace(remoteId)) != null) {
            fullName = space.getDisplayName();
        }
        templateContext.put((Object)(prefix + TEMPLATE_VARIABLE_SUFFIX_IDENTITY_NAME), (Object)fullName);
        String avatarURL = identity.getProfile().getAvatarUrl();
        if (avatarURL == null) {
            avatarURL = isSpaceType ? "/platform-ui/skin/images/avatar/DefaultSpaceAvatar.png" : "/platform-ui/skin/images/avatar/DefaultUserAvatar.png";
        }
        templateContext.put((Object)(prefix + TEMPLATE_VARIABLE_SUFFIX_IDENTITY_AVATAR), (Object)avatarURL);
        templateContext.put((Object)(prefix + TEMPLATE_VARIABLE_SUFFIX_IDENTITY_URL), (Object)NotificationUtils.getAbsoluteURL(remoteId, isSpaceType));
    }

    public static String getAbsoluteURL(String id, boolean isSpaceType) {
        if (isSpaceType) {
            return NotificationUtils.getSpaceAbsoluteURL(id);
        }
        return NotificationUtils.getUserAbsoluteURI(id);
    }

    private static String getUserAbsoluteURI(String id) {
        String currentSite = NotificationUtils.getDefaultSite();
        Object currentDomain = CommonsUtils.getCurrentDomain();
        if (!((String)currentDomain).endsWith("/")) {
            currentDomain = (String)currentDomain + "/";
        }
        return (String)currentDomain + "portal/" + currentSite + "/profile/" + id;
    }

    public static String getSpaceAbsoluteURL(String id) {
        Space space = Utils.getSpace(id);
        if (space != null) {
            String spaceUrlId = space.getGroupId().replace("/spaces/", "");
            Object currentDomain = CommonsUtils.getCurrentDomain();
            if (!((String)currentDomain).endsWith("/")) {
                currentDomain = (String)currentDomain + "/";
            }
            return (String)currentDomain + "portal/g/:spaces:" + spaceUrlId;
        }
        return "#";
    }

    private static final void setFooter(NotificationInfo notification, TemplateContext templateContext) {
        SocialNotificationUtils.addFooterAndFirstName((String)notification.getTo(), (TemplateContext)templateContext);
    }

    private static final void setRead(NotificationInfo notification, TemplateContext templateContext) {
        templateContext.put((Object)"READ", (Object)(Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())) != false ? "read" : "unread"));
    }

    private static final void setNotificationId(NotificationInfo notification, TemplateContext templateContext) {
        templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
    }

    private static final void setLasModifiedTime(NotificationInfo notification, TemplateContext templateContext, String language) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(notification.getLastModifiedDate());
        templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
    }
}

