/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.plugin;

import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.service.ProgramService;
import io.meeds.gamification.service.RuleService;
import io.meeds.social.translation.plugin.TranslationPlugin;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class RuleTranslationPlugin
extends TranslationPlugin {
    public static final String RULE_OBJECT_TYPE = "rule";
    public static final String RULE_DESCRIPTION_FIELD_NAME = "description";
    public static final String RULE_TITLE_FIELD_NAME = "title";
    private RuleService ruleService;
    private ProgramService programService;
    private SpaceService spaceService;
    private IdentityManager identityManager;

    public RuleTranslationPlugin(ProgramService programService, RuleService ruleService, SpaceService spaceService, IdentityManager identityManager) {
        this.programService = programService;
        this.ruleService = ruleService;
        this.spaceService = spaceService;
        this.identityManager = identityManager;
    }

    public String getObjectType() {
        return RULE_OBJECT_TYPE;
    }

    public boolean hasAccessPermission(long ruleId, String username) throws ObjectNotFoundException {
        try {
            RuleDTO rule = this.ruleService.findRuleById(ruleId, username);
            return rule != null && this.programService.isProgramMember(rule.getProgramId(), username);
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }

    public boolean hasEditPermission(long ruleId, String username) throws ObjectNotFoundException {
        try {
            RuleDTO rule = this.ruleService.findRuleById(ruleId, username);
            return rule != null && this.programService.isProgramOwner(rule.getProgramId(), username);
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }

    public long getAudienceId(long ruleId) throws ObjectNotFoundException {
        long spaceId = this.getSpaceId(ruleId);
        if (spaceId == 0L) {
            return 0L;
        }
        Space space = this.spaceService.getSpaceById(String.valueOf(spaceId));
        if (space == null) {
            throw new ObjectNotFoundException(String.format("Space with id %s wasn't found", spaceId));
        }
        Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
        return Long.parseLong(spaceIdentity.getId());
    }

    public long getSpaceId(long ruleId) throws ObjectNotFoundException {
        RuleDTO rule = this.ruleService.findRuleById(ruleId);
        if (rule == null) {
            throw new ObjectNotFoundException(String.format("Rule with id %s wasn't found", ruleId));
        }
        return rule.getProgram().getSpaceId();
    }
}

