/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.storage;

import io.meeds.gamification.constant.IdentityType;
import io.meeds.gamification.dao.RealizationDAO;
import io.meeds.gamification.entity.RealizationEntity;
import io.meeds.gamification.model.PiechartLeaderboard;
import io.meeds.gamification.model.ProfileReputation;
import io.meeds.gamification.model.RealizationDTO;
import io.meeds.gamification.model.StandardLeaderboard;
import io.meeds.gamification.model.filter.RealizationFilter;
import io.meeds.gamification.storage.ProgramStorage;
import io.meeds.gamification.storage.RuleStorage;
import io.meeds.gamification.storage.mapper.RealizationMapper;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class RealizationStorage {
    private ProgramStorage programStorage;
    private RuleStorage ruleStorage;
    private RealizationDAO gamificationHistoryDAO;

    public RealizationStorage(ProgramStorage programStorage, RuleStorage ruleStorage, RealizationDAO gamificationHistoryDAO) {
        this.programStorage = programStorage;
        this.ruleStorage = ruleStorage;
        this.gamificationHistoryDAO = gamificationHistoryDAO;
    }

    public List<RealizationDTO> getRealizationsByFilter(RealizationFilter realizationFilter, int offset, int limit) {
        List<RealizationEntity> realizationEntities = this.gamificationHistoryDAO.findRealizationsByFilter(realizationFilter, offset, limit);
        return RealizationMapper.fromEntities(this.programStorage, realizationEntities);
    }

    public int countRealizationsByFilter(RealizationFilter realizationFilter) {
        return this.gamificationHistoryDAO.countRealizationsByFilter(realizationFilter);
    }

    public RealizationDTO getRealizationById(long id) {
        return RealizationMapper.fromEntity(this.programStorage, (RealizationEntity)this.gamificationHistoryDAO.find(Long.valueOf(id)));
    }

    public RealizationDTO updateRealization(RealizationDTO realization) {
        RealizationEntity realizationEntity = RealizationMapper.toEntity(this.ruleStorage, realization);
        realizationEntity = (RealizationEntity)this.gamificationHistoryDAO.update(realizationEntity);
        return RealizationMapper.fromEntity(this.programStorage, realizationEntity);
    }

    public RealizationDTO createRealization(RealizationDTO realization) {
        RealizationEntity realizationEntity = RealizationMapper.toEntity(this.ruleStorage, realization);
        realizationEntity.setId(null);
        realizationEntity.setCreatedDate(new Date());
        return RealizationMapper.fromEntity(this.programStorage, (RealizationEntity)this.gamificationHistoryDAO.create(realizationEntity));
    }

    public List<RealizationDTO> findRealizationsByObjectIdAndObjectType(String objectId, String objectType) {
        List<RealizationEntity> realizationEntities = this.gamificationHistoryDAO.getRealizationsByObjectIdAndObjectType(objectId, objectType);
        return RealizationMapper.fromEntities(this.programStorage, realizationEntities);
    }

    public List<StandardLeaderboard> findRealizationsByDate(IdentityType identityType, Date date) {
        return this.gamificationHistoryDAO.findRealizationsByDate(identityType, date);
    }

    public List<StandardLeaderboard> findRealizationsByDateAndProgramId(IdentityType identityType, Date date, long programId) {
        return this.gamificationHistoryDAO.findRealizationsByDateAndProgramId(identityType, date, programId);
    }

    public List<StandardLeaderboard> findRealizationsAgnostic(IdentityType identityType) {
        return this.gamificationHistoryDAO.findRealizationsAgnostic(identityType);
    }

    public List<StandardLeaderboard> findRealizationsByProgramId(IdentityType identityType, long programId) {
        return this.gamificationHistoryDAO.findRealizationsByProgramId(identityType, programId);
    }

    public List<RealizationDTO> findRealizationsByIdentityIdSortedByDate(String earnerIdentityId, int limit) {
        return RealizationMapper.fromEntities(this.programStorage, this.gamificationHistoryDAO.findRealizationsByIdentityIdSortedByDate(earnerIdentityId, limit));
    }

    public List<StandardLeaderboard> findRealizationsByDate(Date fromDate, IdentityType identityType, int limit) {
        return this.gamificationHistoryDAO.findRealizationsByDate(fromDate, identityType, limit);
    }

    public List<StandardLeaderboard> findRealizations(IdentityType identityType, int limit) {
        return this.gamificationHistoryDAO.findRealizations(identityType, limit);
    }

    public List<StandardLeaderboard> findRealizationsByDateByProgramId(Date fromDate, IdentityType identityType, long programId, int limit) {
        return this.gamificationHistoryDAO.findRealizationsByDateByProgramId(fromDate, identityType, programId, limit);
    }

    public List<StandardLeaderboard> findRealizationsByProgramId(long programId, IdentityType identityType, int limit) {
        return this.gamificationHistoryDAO.findRealizationsByProgramId(programId, identityType, limit);
    }

    public List<ProfileReputation> getScorePerProgramByIdentityId(String earnerIdentityId) {
        return this.gamificationHistoryDAO.getScorePerProgramByIdentityId(earnerIdentityId);
    }

    public List<PiechartLeaderboard> getStatsByIdentityId(String earnerIdentityId, Date startDate, Date endDate) {
        return this.gamificationHistoryDAO.findStatsByUserId(earnerIdentityId, startDate, endDate);
    }

    public long getScoreByIdentityIdAndBetweenDates(String earnerIdentityId, Date fromDate, Date toDate) {
        return this.gamificationHistoryDAO.findUserReputationScoreBetweenDate(earnerIdentityId, fromDate, toDate);
    }

    public long getScoreByIdentityId(String earnerIdentityId) {
        return this.gamificationHistoryDAO.getScoreByIdentityId(earnerIdentityId);
    }

    public Map<Long, Long> findUsersReputationScoreBetweenDate(List<String> earnersId, Date fromDate, Date toDate) {
        return this.gamificationHistoryDAO.findUsersReputationScoreBetweenDate(earnersId, fromDate, toDate);
    }

    public List<StandardLeaderboard> findAllLeaderboardBetweenDate(IdentityType earnedType, Date fromDate, Date toDate) {
        return this.gamificationHistoryDAO.findAllLeaderboardBetweenDate(earnedType, fromDate, toDate);
    }

    public RealizationDTO findLastReadlizationByRuleIdAndEarnerIdAndReceiverAndObjectId(long ruleId, String earnerId, String receiverId, String objectId, String objectType) {
        return RealizationMapper.fromEntity(this.programStorage, this.gamificationHistoryDAO.findLastReadlizationByRuleIdAndEarnerIdAndReceiverAndObjectId(ruleId, earnerId, receiverId, objectId, objectType));
    }

    public int countRealizationsByRuleIdAndEarnerId(String earnerIdentityId, long ruleId) {
        return this.gamificationHistoryDAO.countRealizationsByRuleIdAndEarnerId(earnerIdentityId, ruleId);
    }

    public int countRealizationsByRuleIdAndEarnerIdSinceDate(String earnerIdentityId, long ruleId, Date sinceDate) {
        return this.gamificationHistoryDAO.countRealizationsByRuleIdAndEarnerIdSinceDate(earnerIdentityId, ruleId, sinceDate);
    }
}

