/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.PageType;
import org.exoplatform.portal.mop.rest.UserNodeRestEntity;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;

public class EntityBuilder {
    private static final Log LOG = ExoLogger.getLogger(EntityBuilder.class);

    private EntityBuilder() {
    }

    public static List<UserNodeRestEntity> toUserNodeRestEntity(Collection<UserNode> nodes, boolean expand, OrganizationService organizationService, LayoutService layoutService, UserACL userACL) {
        if (nodes == null) {
            return Collections.emptyList();
        }
        ArrayList<UserNodeRestEntity> result = new ArrayList<UserNodeRestEntity>();
        for (UserNode userNode : nodes) {
            if (userNode == null) continue;
            UserNodeRestEntity resultNode = new UserNodeRestEntity(userNode);
            if (expand && userNode.getPageRef() != null) {
                Page userNodePage = layoutService.getPage(userNode.getPageRef());
                if (PageType.LINK.equals((Object)PageType.valueOf((String)userNodePage.getType()))) {
                    resultNode.setPageLink(userNodePage.getLink());
                }
                if (!StringUtils.isBlank((String)userNodePage.getEditPermission())) {
                    resultNode.setCanEditPage(userACL.hasEditPermission(userNodePage));
                    HashMap<String, Object> editPermission = new HashMap<String, Object>();
                    try {
                        editPermission.put("membershipType", userNodePage.getEditPermission().split(":")[0]);
                        editPermission.put("group", organizationService.getGroupHandler().findGroupById(userNodePage.getEditPermission().split(":")[1]));
                    }
                    catch (Exception e) {
                        LOG.warn("Error when getting group with id {}", new Object[]{userNodePage.getEditPermission().split(":")[1], e});
                    }
                    resultNode.setPageEditPermission(editPermission);
                }
                if (userNodePage.getAccessPermissions() != null) {
                    ArrayList<Map<String, Object>> accessPermissions = new ArrayList();
                    if (userNodePage.getAccessPermissions().length == 1 && userNodePage.getAccessPermissions()[0].equals("Everyone")) {
                        HashMap<String, String> accessPermission = new HashMap<String, String>();
                        accessPermission.put("membershipType", userNodePage.getAccessPermissions()[0]);
                        accessPermissions.add(accessPermission);
                    } else {
                        accessPermissions = Arrays.stream(userNodePage.getAccessPermissions()).map(permission -> {
                            HashMap<String, String> accessPermission = new HashMap<String, String>();
                            try {
                                accessPermission.put("membershipType", permission.split(":")[0]);
                                accessPermission.put("group", (String)organizationService.getGroupHandler().findGroupById(permission.split(":")[1]));
                            }
                            catch (Exception e) {
                                LOG.warn("Error when getting group with id {}", new Object[]{permission.split(":")[1], e});
                            }
                            return accessPermission;
                        }).collect(Collectors.toList());
                    }
                    resultNode.setPageAccessPermissions(accessPermissions);
                }
            }
            resultNode.setChildren(EntityBuilder.toUserNodeRestEntity(userNode.getChildren(), expand, organizationService, layoutService, userACL));
            result.add(resultNode);
        }
        return result;
    }
}

