/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.api;

import java.util.List;
import org.exoplatform.social.core.model.SpaceExternalInvitation;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.SpaceStorageException;

public interface SpaceStorage {
    public Space getSpaceByDisplayName(String var1) throws SpaceStorageException;

    public void saveSpace(Space var1, boolean var2) throws SpaceStorageException;

    public void renameSpace(Space var1, String var2) throws SpaceStorageException;

    public void renameSpace(String var1, Space var2, String var3) throws SpaceStorageException;

    public void deleteSpace(String var1) throws SpaceStorageException;

    public void ignoreSpace(String var1, String var2);

    public boolean isSpaceIgnored(String var1, String var2);

    public int getManagerSpacesCount(String var1);

    public int getManagerSpacesByFilterCount(String var1, SpaceFilter var2);

    public List<Space> getManagerSpaces(String var1, long var2, long var4);

    public List<Space> getManagerSpacesByFilter(String var1, SpaceFilter var2, long var3, long var5);

    public int getMemberSpacesCount(String var1) throws SpaceStorageException;

    public int getMemberSpacesByFilterCount(String var1, SpaceFilter var2);

    @Deprecated
    public List<Space> getMemberSpaces(String var1) throws SpaceStorageException;

    public List<Space> getMemberSpaces(String var1, long var2, long var4) throws SpaceStorageException;

    public List<Space> getMemberSpacesByFilter(String var1, SpaceFilter var2, long var3, long var5);

    public int getFavoriteSpacesByFilterCount(String var1, SpaceFilter var2);

    public List<Space> getFavoriteSpacesByFilter(String var1, SpaceFilter var2, long var3, long var5);

    public int getPendingSpacesCount(String var1) throws SpaceStorageException;

    public int getPendingSpacesByFilterCount(String var1, SpaceFilter var2);

    public List<Space> getPendingSpaces(String var1) throws SpaceStorageException;

    public List<Space> getPendingSpaces(String var1, long var2, long var4) throws SpaceStorageException;

    public List<Space> getPendingSpacesByFilter(String var1, SpaceFilter var2, long var3, long var5);

    public int getInvitedSpacesCount(String var1) throws SpaceStorageException;

    public int getInvitedSpacesByFilterCount(String var1, SpaceFilter var2);

    public List<Space> getInvitedSpaces(String var1) throws SpaceStorageException;

    public List<Space> getInvitedSpaces(String var1, long var2, long var4) throws SpaceStorageException;

    public List<Space> getInvitedSpacesByFilter(String var1, SpaceFilter var2, long var3, long var5);

    public int getPublicSpacesCount(String var1) throws SpaceStorageException;

    public int getPublicSpacesByFilterCount(String var1, SpaceFilter var2);

    public List<Space> getPublicSpacesByFilter(String var1, SpaceFilter var2, long var3, long var5);

    public List<Space> getPublicSpaces(String var1) throws SpaceStorageException;

    public List<Space> getPublicSpaces(String var1, long var2, long var4) throws SpaceStorageException;

    public int getAccessibleSpacesCount(String var1) throws SpaceStorageException;

    public int getVisibleSpacesCount(String var1, SpaceFilter var2) throws SpaceStorageException;

    public int getUnifiedSearchSpacesCount(String var1, SpaceFilter var2) throws SpaceStorageException;

    public int getAccessibleSpacesByFilterCount(String var1, SpaceFilter var2);

    @Deprecated
    public List<Space> getAccessibleSpaces(String var1) throws SpaceStorageException;

    public List<Space> getVisibleSpaces(String var1, SpaceFilter var2, long var3, long var5) throws SpaceStorageException;

    public List<Space> getUnifiedSearchSpaces(String var1, SpaceFilter var2, long var3, long var5) throws SpaceStorageException;

    public List<Space> getVisibleSpaces(String var1, SpaceFilter var2) throws SpaceStorageException;

    public List<Space> getAccessibleSpaces(String var1, long var2, long var4) throws SpaceStorageException;

    public List<Space> getAccessibleSpacesByFilter(String var1, SpaceFilter var2, long var3, long var5);

    public int getEditableSpacesCount(String var1) throws SpaceStorageException;

    public int getEditableSpacesByFilterCount(String var1, SpaceFilter var2);

    public List<Space> getEditableSpaces(String var1) throws SpaceStorageException;

    public List<Space> getEditableSpaces(String var1, long var2, long var4) throws SpaceStorageException;

    public List<Space> getEditableSpacesByFilter(String var1, SpaceFilter var2, long var3, long var5);

    public int getAllSpacesCount() throws SpaceStorageException;

    public List<Space> getAllSpaces() throws SpaceStorageException;

    public int getAllSpacesByFilterCount(SpaceFilter var1);

    public List<Space> getSpaces(long var1, long var3) throws SpaceStorageException;

    public List<Space> getSpacesByFilter(SpaceFilter var1, long var2, long var4);

    public Space getSpaceById(String var1) throws SpaceStorageException;

    public Space getSpaceSimpleById(String var1) throws SpaceStorageException;

    public Space getSpaceByPrettyName(String var1) throws SpaceStorageException;

    public Space getSpaceByGroupId(String var1) throws SpaceStorageException;

    public Space getSpaceByUrl(String var1) throws SpaceStorageException;

    public void updateSpaceAccessed(String var1, Space var2) throws SpaceStorageException;

    public List<Space> getLastAccessedSpace(SpaceFilter var1, int var2, int var3) throws SpaceStorageException;

    public int getLastAccessedSpaceCount(SpaceFilter var1) throws SpaceStorageException;

    public int getNumberOfMemberPublicSpaces(String var1);

    public List<Space> getVisitedSpaces(SpaceFilter var1, int var2, int var3) throws SpaceStorageException;

    public List<Space> getLastSpaces(int var1);

    @Deprecated(since="6.4.0", forRemoval=true)
    default public List<String> getMemberSpaceIds(String identityId, int offset, int limit) throws SpaceStorageException {
        return this.getMemberRoleSpaceIdentityIds(identityId, offset, limit);
    }

    default public List<String> getSpaceIdentityIdsByUserRole(String remoteId, String status, int offset, int limit) {
        throw new UnsupportedOperationException();
    }

    default public List<String> getFavoriteSpaceIdentityIds(String userIdentityId, SpaceFilter spaceFilter, int offset, int limit) {
        throw new UnsupportedOperationException();
    }

    public List<String> getMemberRoleSpaceIdentityIds(String var1, int var2, int var3) throws SpaceStorageException;

    public List<String> getMemberRoleSpaceIds(String var1, int var2, int var3) throws SpaceStorageException;

    public List<String> getManagerRoleSpaceIds(String var1, int var2, int var3) throws SpaceStorageException;

    public List<SpaceExternalInvitation> findSpaceExternalInvitationsBySpaceId(String var1) throws SpaceStorageException;

    public void saveSpaceExternalInvitation(String var1, String var2, String var3) throws SpaceStorageException;

    public SpaceExternalInvitation findSpaceExternalInvitationById(String var1) throws SpaceStorageException;

    public void deleteSpaceExternalInvitation(SpaceExternalInvitation var1) throws SpaceStorageException;

    public List<String> findExternalInvitationsSpacesByEmail(String var1) throws SpaceStorageException;

    public void deleteExternalUserInvitations(String var1) throws SpaceStorageException;

    default public int countPendingSpaceRequestsToManage(String username) {
        throw new UnsupportedOperationException();
    }

    default public List<Space> getPendingSpaceRequestsToManage(String username, int offset, int limit) {
        throw new UnsupportedOperationException();
    }

    default public int countExternalMembers(Long spaceId) {
        throw new UnsupportedOperationException();
    }

    default public List<Space> getCommonSpaces(String userId, String otherUserId, int offset, int limit) {
        throw new UnsupportedOperationException();
    }

    default public int countCommonSpaces(String userId, String otherUserId) {
        throw new UnsupportedOperationException();
    }
}

