/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class Utils {
    private static final Pattern MENTION_PATTERN = Pattern.compile("<a href=\"([\\w|/]+|)/profile/([\\w]+)\">([\\w|\\s]+|)</a>");
    private static final int MAX_LENGTH = 150;
    private static final Pattern LINK_PATTERN = Pattern.compile("<a ([^>]+)>([^<]+)</a>");
    private static final Pattern HREF_PATTERN = Pattern.compile("href=\"(.*?)\"");
    private static final String SLASH_STR = "/";
    private static final Pattern URL_PATTERN = Pattern.compile("^(?i)(((?:(?:ht)tp(?:s?)\\:\\/\\/)?(?:\\w+:\\w+@)?(((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?))|(?:(?:[-\\p{L}\\p{Digit}\\+\\$\\-\\*\\=]+\\.)+(?:com|org|net|edu|gov|mil|biz|info|mobi|name|aero|jobs|museum|travel|asia|cat|coop|int|pro|tel|xxx|[a-z]{2}))))|(?:(?:(?:ht)tp(?:s?)\\:\\/\\/)(?:\\w+:\\w+@)?(?:[-\\p{L}\\p{Digit}\\+\\$\\-\\*\\=]+)))(?::[\\d]{1,5})?(?:[\\/|\\?|\\#].*)?$");
    private static final String styleCSS = " style=\"color: #2f5e92; text-decoration: none;\"";

    public static <T> T getService(Class<T> clazz) {
        return (T)PortalContainer.getInstance().getComponentInstanceOfType(clazz);
    }

    public static String getUserId(String identityId) {
        return Utils.getIdentityManager().getIdentity(identityId, false).getRemoteId();
    }

    public static List<String> toListUserIds(String ... userIds) {
        ArrayList<String> ids = new ArrayList<String>();
        for (String userId : userIds) {
            ids.add(userId);
        }
        return ids;
    }

    public static boolean isSpaceActivity(ExoSocialActivity activity) {
        Identity id = Utils.getIdentityManager().getOrCreateIdentity("space", activity.getStreamOwner(), false);
        return id != null;
    }

    public static void sendToCommeters(Set<String> receivers, String[] commenters, String poster, String spaceId) {
        receivers.addAll(Utils.getDestinataires(commenters, poster, spaceId));
    }

    public static void sendToLikers(Set<String> receivers, String[] likers, String poster, String spaceId) {
        receivers.addAll(Utils.getDestinataires(likers, poster, spaceId));
    }

    public static void sendToStreamOwner(Set<String> receivers, String streamOwner, String posteId) {
        Identity id = Utils.getIdentityManager().getOrCreateIdentity("space", streamOwner, false);
        if (id != null) {
            return;
        }
        String postRemoteId = Utils.getUserId(posteId);
        if (!streamOwner.equals(postRemoteId)) {
            receivers.add(streamOwner);
        }
    }

    public static void sendToActivityPoster(Set<String> receivers, String activityPosterId, String posterId, String spaceId) {
        if (activityPosterId.equals(posterId)) {
            return;
        }
        String activityPosterRemoteId = Utils.getUserId(activityPosterId);
        SpaceService spaceService = Utils.getSpaceService();
        if (spaceId == null || spaceService.isSuperManager(activityPosterRemoteId) || spaceService.isMember(spaceService.getSpaceById(spaceId), activityPosterRemoteId)) {
            receivers.add(activityPosterRemoteId);
        }
    }

    public static void sendToMentioners(Set<String> receivers, String[] mentioners, String poster, String spaceId) {
        receivers.addAll(Utils.getDestinataires(mentioners, poster, spaceId));
    }

    private static Set<String> getDestinataires(String[] users, String poster, String spaceId) {
        HashSet<String> destinataires = new HashSet<String>();
        SpaceService spaceService = Utils.getSpaceService();
        Space space = spaceService.getSpaceById(spaceId);
        for (String user : users) {
            user = user.split("@")[0];
            String userName = Utils.getUserId(user);
            boolean isMember = true;
            if (space != null) {
                boolean bl = isMember = spaceService.isMember(space, userName) || spaceService.isSuperManager(userName);
            }
            if (user.equals(poster) || !isMember) continue;
            destinataires.add(userName);
        }
        return destinataires;
    }

    public static String processMentions(String title) {
        Matcher matcher = MENTION_PATTERN.matcher(title);
        String domain = CommonsUtils.getCurrentDomain();
        while (matcher.find()) {
            String remoteId = matcher.group(2);
            Identity identity = Utils.getIdentityManager().getOrCreateIdentity("organization", remoteId, false);
            if (identity == null) continue;
            String result = matcher.group();
            String host = matcher.group(1);
            title = title.replace(result, result.replace(host, domain + host));
        }
        return title;
    }

    public static Set<String> getMentioners(String title, String posterId, String spaceId) {
        String posterRemoteId = Utils.getUserId(posterId);
        HashSet<String> mentioners = new HashSet<String>();
        Matcher matcher = MENTION_PATTERN.matcher(title);
        SpaceService spaceService = Utils.getSpaceService();
        Space space = spaceService.getSpaceById(spaceId);
        while (matcher.find()) {
            String remoteId = matcher.group(2);
            Identity identity = Utils.getIdentityManager().getOrCreateIdentity("organization", remoteId, false);
            boolean isMember = true;
            if (space != null) {
                boolean bl = isMember = spaceService.isMember(space, remoteId) || spaceService.isSuperManager(remoteId);
            }
            if (identity == null || posterRemoteId.equals(remoteId) || !isMember) continue;
            mentioners.add(remoteId);
        }
        return mentioners;
    }

    public static String processLinkTitle(String title) {
        Matcher matcher = LINK_PATTERN.matcher(title);
        String domain = CommonsUtils.getCurrentDomain();
        while (matcher.find()) {
            String newUrl;
            String url;
            String result = matcher.group(1);
            title = title.replace(result, result + styleCSS);
            Matcher m = HREF_PATTERN.matcher(result);
            if (!m.find() || (url = m.group(1)) == null || Utils.isValidUrl(url) || !Utils.isValidUrl(newUrl = url.startsWith(SLASH_STR) ? domain + url : domain + SLASH_STR + url)) continue;
            title = title.replace(url, newUrl);
        }
        return title;
    }

    public static boolean isValidUrl(String url) {
        return URL_PATTERN.matcher(url).matches();
    }

    public static List<String> getDestinataires(ExoSocialActivity activity, Space space) {
        ArrayList<String> destinataires = new ArrayList<String>();
        String poster = Utils.getUserId(activity.getPosterId());
        for (String member : space.getMembers()) {
            if (member.equals(poster)) continue;
            destinataires.add(member);
        }
        return destinataires;
    }

    public static String formatContent(String content) {
        if (((String)content).length() > 150) {
            content = ((String)content).substring(0, 150) + " ... ";
        }
        return content;
    }

    public static IdentityManager getIdentityManager() {
        return Utils.getService(IdentityManager.class);
    }

    public static SpaceService getSpaceService() {
        return Utils.getService(SpaceService.class);
    }

    public static ActivityManager getActivityManager() {
        return Utils.getService(ActivityManager.class);
    }

    public static RelationshipManager getRelationshipManager() {
        return Utils.getService(RelationshipManager.class);
    }

    public static String addExternalFlag(Identity userIdentity) {
        Object fullName = userIdentity.getProfile().getFullName();
        if (userIdentity != null && userIdentity.getProfile() != null && userIdentity.getProfile().getProperty("external") != null && userIdentity.getProfile().getProperty("external").equals("true")) {
            fullName = (String)fullName + " (" + LinkProvider.getResourceBundleLabel((Locale)new Locale(LinkProvider.getCurrentUserLanguage((String)userIdentity.getRemoteId())), (String)"external.label.tag") + ")";
        }
        return fullName;
    }
}

