/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.command.NotificationCommand;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.task.dto.CommentDto;
import org.exoplatform.task.dto.ProjectDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.integration.notification.NotificationUtils;
import org.exoplatform.task.service.CommentService;
import org.exoplatform.task.util.ProjectUtil;

public class TaskCommentNotificationListener
extends Listener<TaskDto, CommentDto> {
    private final OrganizationService organizationService;

    public TaskCommentNotificationListener(OrganizationService organizationService) {
        this.organizationService = organizationService;
    }

    public void onEvent(Event<TaskDto, CommentDto> event) throws Exception {
        TaskDto task = (TaskDto)event.getSource();
        CommentDto comment = (CommentDto)event.getData();
        NotificationContext ctx = this.buildContext(task, comment);
        this.dispatch(ctx, "TaskCommentedPlugin", "TaskMentionedPlugin");
    }

    private NotificationContext buildContext(TaskDto task, CommentDto comment) {
        CommentService commentService;
        List<CommentDto> comments;
        Set<String> watcher;
        Set<String> coworker;
        ProjectDto project = task.getStatus().getProject();
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(NotificationUtils.COMMENT, (Object)comment).append(NotificationUtils.TASK, (Object)task);
        String creator = ConversationState.getCurrent().getIdentity().getUserId();
        ctx.append(NotificationUtils.CREATOR, (Object)creator);
        HashSet<String> receiver = new HashSet<String>();
        receiver.add(task.getCreatedBy());
        if (task.getAssignee() != null && !task.getAssignee().isEmpty()) {
            receiver.add(task.getAssignee());
        }
        if ((coworker = task.getCoworker()) != null && coworker.size() > 0) {
            receiver.addAll(coworker);
        }
        if ((watcher = task.getWatcher()) != null && watcher.size() > 0) {
            receiver.addAll(watcher);
        }
        if ((comments = (commentService = (CommentService)PortalContainer.getInstance().getComponentInstanceOfType(CommentService.class)).getComments(task.getId(), 0, 0)) != null && comments.size() > 0) {
            for (CommentDto c : comments) {
                receiver.add(c.getAuthor());
                List<CommentDto> subComments = c.getSubComments();
                if (subComments == null) continue;
                for (CommentDto subComment : subComments) {
                    receiver.add(subComment.getAuthor());
                }
            }
        }
        receiver.remove(creator);
        Set<String> mentioned = comment.getMentionedUsers();
        if (mentioned == null) {
            mentioned = new HashSet<String>();
        }
        mentioned.remove(creator);
        receiver.removeIf(user -> !ProjectUtil.isProjectParticipant(this.organizationService, user, project));
        ctx.append(NotificationUtils.RECEIVERS, receiver);
        ctx.append(NotificationUtils.MENTIONED, mentioned);
        return ctx;
    }

    private void dispatch(NotificationContext ctx, String ... pluginId) {
        ArrayList<NotificationCommand> commands = new ArrayList<NotificationCommand>(pluginId.length);
        for (String p : pluginId) {
            commands.add(ctx.makeCommand(PluginKey.key((String)p)));
        }
        ctx.getNotificationExecutor().with(commands).execute(ctx);
    }
}

