/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration.gamification;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.StringUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.task.dto.ChangeLogEntry;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.service.TaskPayload;
import org.exoplatform.task.service.TaskService;

public class GamificationTaskUpdateListener
extends Listener<TaskService, TaskPayload> {
    public static final String GAMIFICATION_TASK_ADDON_CREATE_TASK = "createNewTask";
    public static final String GAMIFICATION_TASK_ADDON_COMPLETED_TASK_ASSIGNED = "completeTaskAssigned";
    public static final String GAMIFICATION_TASK_ADDON_COMPLETED_TASK_COWORKER = "completeTaskCoworker";
    public static final String GAMIFICATION_TASK_ADDON_COMPLETED_TASK = "completeTask";
    public static final String GAMIFICATION_TASK_ADDON_UPDATE_TASK = "updateTask";
    protected TaskService taskService;
    protected IdentityManager identityManager;
    protected ListenerService listenerService;

    public GamificationTaskUpdateListener(TaskService taskService, IdentityManager identityManager, ListenerService listenerService) {
        this.taskService = taskService;
        this.identityManager = identityManager;
        this.listenerService = listenerService;
    }

    public void onEvent(Event<TaskService, TaskPayload> event) throws Exception {
        TaskPayload data = (TaskPayload)event.getData();
        TaskDto oldTask = data.before();
        TaskDto newTask = data.after();
        if (oldTask == null && newTask != null) {
            this.createTask(newTask);
        } else if (oldTask != null && newTask != null) {
            this.updateTask(oldTask, newTask);
        }
    }

    protected void createTask(TaskDto task) {
        String actorUsername = ConversationState.getCurrent().getIdentity().getUserId();
        String actorId = this.identityManager.getOrCreateUserIdentity(actorUsername).getId();
        this.createGamificationRealization(actorId, actorId, GAMIFICATION_TASK_ADDON_CREATE_TASK, String.valueOf(task.getId()));
    }

    protected void updateTask(TaskDto before, TaskDto after) throws Exception {
        String actorUsername = ConversationState.getCurrent().getIdentity().getUserId();
        String actorId = this.identityManager.getOrCreateUserIdentity(actorUsername).getId();
        long taskId = after.getId();
        if (!before.isCompleted() && after.isCompleted()) {
            List<ChangeLogEntry> taskLogs = this.taskService.getTaskLogs(taskId, 0, -1);
            this.createGamificationRealization(taskId, GAMIFICATION_TASK_ADDON_COMPLETED_TASK_ASSIGNED, taskLogs, "assign");
            this.createGamificationRealization(taskId, GAMIFICATION_TASK_ADDON_COMPLETED_TASK_COWORKER, taskLogs, "assignCoworker");
            this.createGamificationRealization(actorId, actorId, GAMIFICATION_TASK_ADDON_COMPLETED_TASK, String.valueOf(taskId));
        } else {
            this.createGamificationRealization(actorId, actorId, GAMIFICATION_TASK_ADDON_UPDATE_TASK, String.valueOf(taskId));
        }
    }

    private void createGamificationRealization(long taskId, String eventName, List<ChangeLogEntry> taskLogs, String taskLogName) {
        Set<String> usernames = taskLogs.stream().filter(taskLog -> StringUtils.equals((CharSequence)taskLogName, (CharSequence)taskLog.getActionName())).map(ChangeLogEntry::getTarget).collect(Collectors.toSet());
        this.createGamificationRealization(taskId, usernames, eventName);
    }

    private void createGamificationRealization(long taskId, Set<String> usernames, String eventName) {
        usernames.forEach(username -> {
            Identity identity = this.identityManager.getOrCreateUserIdentity(username);
            if (identity == null || !identity.isEnable() || identity.isDeleted()) {
                return;
            }
            this.createGamificationRealization(identity.getId(), identity.getId(), eventName, String.valueOf(taskId));
        });
    }

    protected boolean isDiff(Object before, Object after) {
        if (before == after) {
            return false;
        }
        if (before != null) {
            return !before.equals(after);
        }
        return true;
    }

    private void createGamificationRealization(String earnerIdentityId, String receiverId, String gamificationEventName, String taskId) {
        HashMap<String, String> gam = new HashMap<String, String>();
        try {
            gam.put("eventId", gamificationEventName);
            gam.put("objectId", taskId);
            gam.put("objectType", "task");
            gam.put("senderId", earnerIdentityId);
            gam.put("receiverId", receiverId);
            this.listenerService.broadcast("exo.gamification.generic.action", gam, null);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error triggering Gamification Listener Event: " + gam, e);
        }
    }
}

