/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.navigation;

import java.util.Map;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.portal.mop.navigation.FederatingVisitor;
import org.exoplatform.portal.mop.navigation.HierarchyError;
import org.exoplatform.portal.mop.navigation.HierarchyException;
import org.exoplatform.portal.mop.navigation.ModelAdapter;
import org.exoplatform.portal.mop.navigation.NodeAdapter;
import org.exoplatform.portal.mop.navigation.NodeAdapterImpl;
import org.exoplatform.portal.mop.navigation.NodeChangeListener;
import org.exoplatform.portal.mop.navigation.NodeChangeQueue;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeContextUpdateAdapter;
import org.exoplatform.portal.mop.navigation.NodeData;
import org.exoplatform.portal.mop.navigation.NodeDataUpdateAdapter;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.NodePersister;
import org.exoplatform.portal.mop.navigation.NodeStore;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.navigation.TreeContext;
import org.exoplatform.portal.mop.navigation.TreeDiff;
import org.exoplatform.portal.mop.navigation.TreeMerge;
import org.exoplatform.portal.mop.navigation.TreeUpdate;

public class NodeManager {
    private final NodeStore store;

    public NodeManager(NodeStore store) {
        this.store = store;
    }

    public NodeStore getStore() {
        return this.store;
    }

    public <N> NodeContext<N> loadNode(NodeModel<N> model, String nodeId, Scope scope, NodeChangeListener<NodeContext<N>> listener) {
        NodeData data = this.store.loadNode(Safe.parseLong(nodeId));
        if (data != null) {
            NodeContext<N> context = new NodeContext<N>(model, data);
            this.updateNode(context, scope, listener);
            return context;
        }
        return null;
    }

    public <N> void diff(ModelAdapter<N> adapter, N node, NodeContext<N> context) {
        this.diff(new NodeAdapterImpl<N>(adapter), node, context);
    }

    public <L, N> void diff(NodeAdapter<L, N> adapter, N node, NodeContext<N> context) {
        TreeDiff<L, N> diff = new TreeDiff<L, N>(node, context, adapter);
        diff.perform();
    }

    public <N> void updateNode(NodeContext<N> root, Scope scope, NodeChangeListener<NodeContext<N>> listener) throws NullPointerException, IllegalArgumentException, HierarchyException {
        Scope.Visitor visitor = scope != null ? new FederatingVisitor<N>(root.tree, root, scope) : root.tree;
        this.updateTree(root.tree, visitor, listener);
    }

    public <N> void saveNode(NodeContext<N> context, NodeChangeListener<NodeContext<N>> listener) throws NullPointerException, HierarchyException {
        this.saveTree(context.tree, listener);
    }

    public <N> void rebaseNode(NodeContext<N> context, Scope scope, NodeChangeListener<NodeContext<N>> listener) throws HierarchyException {
        FederatingVisitor<N> visitor = scope != null ? new FederatingVisitor<N>(context.tree.origin(), context, scope) : context.tree.origin();
        this.rebaseTree(context.tree, visitor, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <N> void updateTree(TreeContext<N> tree, Scope.Visitor visitor, NodeChangeListener<NodeContext<N>> listener) throws NullPointerException, IllegalArgumentException, HierarchyException {
        if (tree.hasChanges()) {
            throw new IllegalArgumentException("For now we don't accept to update a context that has pending changes");
        }
        NodeData data = this.store.loadNode(Safe.parseLong(tree.root.data.id));
        if (data == null) {
            throw new HierarchyException(HierarchyError.UPDATE_CONCURRENTLY_REMOVED_NODE);
        }
        tree.editMode = true;
        try {
            TreeUpdate.perform(tree, NodeContextUpdateAdapter.create(), data, NodeDataUpdateAdapter.create(this.store), listener, visitor);
        }
        finally {
            tree.editMode = false;
        }
    }

    private <N> void rebaseTree(TreeContext<N> tree, Scope.Visitor visitor, NodeChangeListener<NodeContext<N>> listener) throws HierarchyException {
        if (!tree.hasChanges()) {
            this.updateTree(tree, visitor, listener);
        } else {
            TreeContext<N> rebased = this.rebase(tree, visitor);
            TreeUpdate.perform(tree, NodeContextUpdateAdapter.create(), rebased.root, NodeContextUpdateAdapter.create(), listener, rebased);
        }
    }

    private <N> TreeContext<N> rebase(TreeContext<N> tree, Scope.Visitor visitor) throws HierarchyException {
        NodeData data = this.store.loadNode(Safe.parseLong(tree.root.getId()));
        if (data == null) {
            throw new HierarchyException(HierarchyError.UPDATE_CONCURRENTLY_REMOVED_NODE);
        }
        TreeContext rebased = new NodeContext<N>(tree.model, (NodeData)data).tree;
        TreeUpdate.perform(rebased, NodeContextUpdateAdapter.create(), data, NodeDataUpdateAdapter.create(this.store), null, visitor);
        NodeChangeQueue changes = tree.getChanges();
        TreeMerge merger = new TreeMerge(rebased, rebased);
        if (changes != null) {
            changes.broadcast(merger);
        }
        return rebased;
    }

    private <N> void saveTree(TreeContext<N> tree, NodeChangeListener<NodeContext<N>> listener) throws NullPointerException, HierarchyException {
        NodeData data = this.store.loadNode(Safe.parseLong(tree.root.data.id));
        if (data == null) {
            throw new HierarchyException(HierarchyError.UPDATE_CONCURRENTLY_REMOVED_NODE);
        }
        TreeContext<N> rebased = this.rebase(tree, tree.origin());
        NodePersister persister = new NodePersister(this.store);
        NodeChangeQueue changes = rebased.getChanges();
        if (changes != null) {
            NodeContext<N> a;
            changes.broadcast(persister);
            changes.broadcast(listener);
            for (Map.Entry<String, String> entry : persister.toPersist.entrySet()) {
                a = tree.getNode(entry.getKey());
                a.handle = entry.getValue();
            }
            for (String ddd : persister.toUpdate) {
                a = tree.getNode(ddd);
                a.data = new NodeData(a);
                a.name = null;
                a.state = null;
            }
            changes.clear();
            tree.getChanges().clear();
        }
        TreeUpdate.perform(tree, NodeContextUpdateAdapter.create(), rebased.root, NodeContextUpdateAdapter.create(), null, rebased);
    }
}

