/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.notes.service;

import io.meeds.social.cms.model.CMSSetting;
import io.meeds.social.cms.service.CMSService;
import java.util.Date;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.pom.data.PageKey;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.PageUpdateType;
import org.exoplatform.wiki.service.WikiService;

public class NotePageViewService {
    public static final String CMS_CONTENT_TYPE = "notePage";
    private NoteService noteService;
    private WikiService noteBookService;
    private CMSService cmsService;

    public NotePageViewService(NoteService noteService, WikiService noteBookService, CMSService cmsService) {
        this.noteService = noteService;
        this.noteBookService = noteBookService;
        this.cmsService = cmsService;
    }

    public Page getNotePage(String name, String lang, Identity currentUserAclIdentity) throws IllegalAccessException {
        CMSSetting setting = this.cmsService.getSetting(CMS_CONTENT_TYPE, name);
        if (setting == null) {
            return null;
        }
        if (!this.cmsService.hasAccessPermission(currentUserAclIdentity, CMS_CONTENT_TYPE, name)) {
            throw new IllegalAccessException("Note page isn't accessible");
        }
        String pageReference = setting.getPageReference();
        PageKey pageKey = PageKey.create((String)pageReference);
        return this.getNotePage(pageKey, name);
    }

    public void saveNotePage(String name, String content, String lang, Identity currentUserAclIdentity) throws IllegalAccessException, ObjectNotFoundException {
        CMSSetting setting = this.cmsService.getSetting(CMS_CONTENT_TYPE, name);
        if (setting == null) {
            throw new ObjectNotFoundException(String.format("CMS Setting name %s wasn't found", name));
        }
        if (!this.cmsService.hasEditPermission(currentUserAclIdentity, CMS_CONTENT_TYPE, name)) {
            throw new IllegalAccessException("Note page isn't editable");
        }
        String pageReference = setting.getPageReference();
        PageKey pageKey = PageKey.create((String)pageReference);
        try {
            Wiki noteBook = this.getNote(pageKey);
            Page page = this.getNotePage(pageKey, name);
            if (page == null) {
                page = new Page(name, name);
                page.setContent(content);
                page.setCreatedDate(new Date());
                page.setUpdatedDate(new Date());
                page.setOwner(IdentityConstants.SYSTEM);
                this.noteService.createNote(noteBook, noteBook.getWikiHome(), page);
            } else {
                page.setContent(content);
                page.setUpdatedDate(new Date());
                page = this.noteService.updateNote(page, PageUpdateType.EDIT_PAGE_CONTENT);
                String username = currentUserAclIdentity.getUserId();
                this.noteService.createVersionOfNote(page, username);
                this.noteService.removeDraftOfNote(page, username);
            }
        }
        catch (WikiException e) {
            throw new IllegalStateException(String.format("Error retrieving note with name %s referenced in page %s", name, pageKey), e);
        }
    }

    private Wiki getNote(PageKey pageKey) throws WikiException {
        Wiki noteBook = this.noteBookService.getWikiByTypeAndOwner(pageKey.getType(), pageKey.getId());
        if (noteBook == null) {
            return this.noteBookService.createWiki(pageKey.getType(), pageKey.getId());
        }
        return noteBook;
    }

    private Page getNotePage(PageKey pageKey, String name) {
        try {
            String ownerType = pageKey.getType();
            String ownerName = pageKey.getId();
            return this.noteService.getNoteOfNoteBookByName(ownerType, ownerName, name);
        }
        catch (WikiException e) {
            throw new IllegalStateException(String.format("Error retrieving note with name %s referenced in page %s", name, pageKey), e);
        }
    }
}

