/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.log.LogLevel;
import org.exoplatform.services.organization.DisabledUserException;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.organization.externalstore.IDMExternalStoreService;
import org.exoplatform.services.organization.idm.AbstractDAOImpl;
import org.exoplatform.services.organization.idm.EntityMapperUtils;
import org.exoplatform.services.organization.idm.IDMUserListAccess;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.exoplatform.services.organization.idm.PicketLinkIDMServiceImpl;
import org.exoplatform.services.organization.idm.Tools;
import org.exoplatform.services.organization.idm.UserImpl;
import org.picketlink.idm.api.Attribute;
import org.picketlink.idm.api.AttributesManager;
import org.picketlink.idm.api.Group;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.IdentityType;
import org.picketlink.idm.api.query.UserQueryBuilder;
import org.picketlink.idm.impl.api.SimpleAttribute;
import org.picketlink.idm.impl.api.model.SimpleUser;

public class UserDAOImpl
extends AbstractDAOImpl
implements UserHandler {
    private static final String LISTENER_EXECUTION_ERR_MSG = "Error executing %s on listener %s for user %s";
    public static final String USER_PASSWORD = "password";
    public static final String USER_PASSWORD_SALT = "passwordSalt";
    public static final String USER_FIRST_NAME = "firstName";
    public static final String USER_LAST_NAME = "lastName";
    public static final String USER_DISPLAY_NAME = "displayName";
    public static final String USER_EMAIL = "email";
    public static final String USER_CREATED_DATE = "createdDate";
    public static final String USER_LAST_LOGIN_TIME = "lastLoginTime";
    public static final String USER_ORGANIZATION_ID = "organizationId";
    public static final String USER_ENABLED = "enabled";
    public static final String USER_PASSWORD_SALT128 = "passwordSalt128";
    public static final Set<String> USER_NON_PROFILE_KEYS;
    public static final DateFormat dateFormat;
    private List<UserEventListener> listeners_ = new ArrayList<UserEventListener>(3);

    public UserDAOImpl(PicketLinkIDMOrganizationServiceImpl orgService, PicketLinkIDMService idmService) {
        super(orgService, idmService);
    }

    public final List<UserEventListener> getUserEventListeners() {
        return Collections.unmodifiableList(this.listeners_);
    }

    public void addUserEventListener(UserEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.listeners_.add(listener);
    }

    public void removeUserEventListener(UserEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.listeners_.remove(listener);
    }

    public User createUserInstance() {
        return new UserImpl();
    }

    public User createUserInstance(String username) {
        return new UserImpl(username);
    }

    public void createUser(User user, boolean broadcast) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "createUser", new Object[]{"user", user, "broadcast", broadcast});
        }
        IdentitySession session = this.service_.getIdentitySession();
        if (broadcast) {
            this.preSave(user, true);
        }
        org.picketlink.idm.api.User plIDMUser = null;
        try {
            this.orgService.flush();
            plIDMUser = session.getPersistenceManager().createUser(user.getUserName());
        }
        catch (Exception e) {
            this.handleException("Identity operation error: ", e);
        }
        try {
            this.persistUserInfo(user, plIDMUser, session, true);
        }
        catch (Exception e) {
            try {
                session.getPersistenceManager().removeUser(user.getUserName(), true);
                throw e;
            }
            catch (Exception e2) {
                this.handleException("Can't remove user", e);
            }
        }
        if (broadcast) {
            this.postSave(user, true);
        }
    }

    public void saveUser(User user, boolean broadcast) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "saveUser", new Object[]{"user", user, "broadcast", broadcast});
        }
        if (user != null && !user.isEnabled()) {
            throw new DisabledUserException(user.getUserName());
        }
        IdentitySession session = this.service_.getIdentitySession();
        if (broadcast) {
            this.preSave(user, false);
        }
        org.picketlink.idm.api.User plIDMUser = session.getPersistenceManager().findUser(user.getUserName());
        this.persistUserInfo(user, plIDMUser, session, false);
        if (broadcast) {
            this.postSave(user, false);
        }
    }

    public User setEnabled(String userName, boolean enabled, boolean broadcast) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "setEnabled", new Object[]{"userName", userName, USER_ENABLED, enabled, "broadcast", broadcast});
        }
        this.orgService.flush();
        IdentitySession session = this.service_.getIdentitySession();
        User foundUser = this.getPopulatedUser(userName, session, UserStatus.ANY);
        if (!this.disableUserActived()) {
            this.log.debug((Object)"disableUserActived option is set to FALSE, setEnabled method will be ignored");
            return foundUser;
        }
        if (foundUser == null || foundUser.isEnabled() == enabled) {
            return foundUser;
        }
        ((UserImpl)foundUser).setEnabled(enabled);
        if (broadcast) {
            this.preSetEnabled(foundUser);
        }
        AttributesManager am = session.getAttributesManager();
        if (enabled) {
            try {
                am.removeAttributes(userName, new String[]{USER_ENABLED});
            }
            catch (Exception e) {
                this.handleException("Cannot update enabled status for user: " + userName + "; ", e);
            }
        } else {
            Attribute[] attrs = new Attribute[]{new SimpleAttribute(USER_ENABLED, (Object)String.valueOf(enabled))};
            try {
                am.updateAttributes(userName, attrs);
            }
            catch (Exception e) {
                this.handleException("Cannot update enabled status for user: " + userName + "; ", e);
            }
        }
        if (broadcast) {
            this.postSetEnabled(foundUser);
        }
        return foundUser;
    }

    public User removeUser(String userName, boolean broadcast) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "removeUser", new Object[]{"userName", userName, "broadcast", broadcast});
        }
        IdentitySession session = this.service_.getIdentitySession();
        org.picketlink.idm.api.User foundUser = null;
        try {
            this.orgService.flush();
            foundUser = session.getPersistenceManager().findUser(userName);
        }
        catch (IllegalArgumentException e) {
            this.log.debug((Object)"Can NOT find any user with username is NULL");
        }
        catch (Exception e) {
            this.handleException("Cannot obtain user: " + userName + "; ", e);
        }
        if (foundUser == null) {
            return null;
        }
        User exoUser = this.getPopulatedUser(userName, session, UserStatus.ANY);
        if (broadcast) {
            this.preDelete(exoUser);
        }
        try {
            this.orgService.getMembershipHandler().removeMembershipByUser(userName, false);
            this.orgService.getUserProfileHandler().removeUserProfile(userName, false);
        }
        catch (Exception e) {
            this.handleException("Cannot cleanup user relationships: " + userName + "; ", e);
        }
        try {
            session.getPersistenceManager().removeUser(foundUser, true);
        }
        catch (Exception e) {
            this.handleException("Cannot remove user: " + userName + "; ", e);
        }
        if (broadcast) {
            this.postDelete(exoUser);
        }
        return exoUser;
    }

    public boolean isUpdateLastLoginTime() {
        return this.orgService.getConfiguration().isUpdateLastLoginTimeAfterAuthentication();
    }

    public User findUserByName(String userName) throws Exception {
        return this.findUserByName(userName, UserStatus.ENABLED);
    }

    public User findUserByName(String userName, UserStatus userStatus) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "findUserByName", new Object[]{"userName", userName, "userStatus", userStatus});
        }
        IdentitySession session = this.service_.getIdentitySession();
        User user = this.getPopulatedUser(userName, session, userStatus);
        if (this.log.isTraceEnabled()) {
            Tools.logMethodOut(this.log, LogLevel.TRACE, "findUserByName", user);
        }
        return user;
    }

    public LazyPageList<User> getUserPageList(int pageSize) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "getUserPagetList", new Object[]{"pageSize", pageSize});
        }
        UserQueryBuilder qb = this.service_.getIdentitySession().createUserQueryBuilder();
        boolean enabledOnly = this.filterDisabledUsersInQueries();
        if (enabledOnly) {
            qb = this.addEnabledUserFilter(qb);
        }
        return new LazyPageList((ListAccess)new IDMUserListAccess(qb, pageSize, true, this.countPaginatedUsers(), enabledOnly ? UserStatus.ENABLED : UserStatus.DISABLED), pageSize);
    }

    public ListAccess<User> findAllUsers() throws Exception {
        return this.findAllUsers(UserStatus.ENABLED);
    }

    public ListAccess<User> findAllUsers(UserStatus userStatus) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "findAllUsers", new Object[]{"userStatus", userStatus});
        }
        UserQueryBuilder qb = this.service_.getIdentitySession().createUserQueryBuilder();
        if (this.disableUserActived()) {
            switch (userStatus) {
                case DISABLED: {
                    if (!this.filterDisabledUsersInQueries()) break;
                    qb = this.addDisabledUserFilter(qb);
                    break;
                }
                case ANY: {
                    break;
                }
                case ENABLED: {
                    if (!this.filterDisabledUsersInQueries()) break;
                    qb = this.addEnabledUserFilter(qb);
                }
            }
        }
        return new IDMUserListAccess(qb, 20, !this.countPaginatedUsers(), this.countPaginatedUsers(), userStatus);
    }

    public boolean authenticate(String username, String password) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "authenticate", new Object[]{"userName", username, USER_PASSWORD, "****"});
        }
        boolean authenticated = false;
        User user = this.findUserByName(username, UserStatus.ANY);
        if (user != null) {
            if (this.log.isTraceEnabled()) {
                Tools.logMethodOut(this.log, LogLevel.TRACE, "authenticate", false);
            }
            if (!user.isEnabled()) {
                throw new DisabledUserException(username);
            }
            if (user.isInternalStore() && (authenticated = this.authenticateDB(user, password))) {
                return true;
            }
        }
        return this.authenticateExternal(username, password);
    }

    public boolean authenticateExternal(String username, String password) throws Exception {
        ExoContainer currentContainer = this.getPortalContainer();
        IDMExternalStoreService externalStoreService = (IDMExternalStoreService)currentContainer.getComponentInstanceOfType(IDMExternalStoreService.class);
        if (externalStoreService == null || !externalStoreService.isEnabled()) {
            return false;
        }
        return externalStoreService.authenticate(username, password);
    }

    public boolean authenticateDB(User user, String password) throws Exception {
        boolean authenticated = false;
        if (this.orgService.getConfiguration().isPasswordAsAttribute()) {
            authenticated = user.getPassword().equals(password);
        } else {
            try {
                this.orgService.flush();
                IdentitySession session = this.service_.getIdentitySession();
                org.picketlink.idm.api.User idmUser = session.getPersistenceManager().findUser(user.getUserName());
                authenticated = this.service_.getExtendedAttributeManager().validatePassword(idmUser, password);
            }
            catch (Exception e) {
                this.handleException("Cannot authenticate user: " + user.getUserName() + "; ", e);
            }
        }
        if (this.log.isTraceEnabled()) {
            Tools.logMethodOut(this.log, LogLevel.TRACE, "authenticate", authenticated);
        }
        return authenticated;
    }

    public LazyPageList findUsers(Query q) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "findUsers", new Object[]{"q", q});
        }
        ListAccess<User> list = this.findUsersByQuery(q);
        return new LazyPageList(list, 20);
    }

    public ListAccess<User> findUsersByQuery(Query q) throws Exception {
        return this.findUsersByQuery(q, UserStatus.ENABLED);
    }

    public ListAccess<User> findUsersByQuery(Query q, UserStatus userStatus) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "findUsersByQuery", new Object[]{q, userStatus});
        }
        if (q.getUserName() == null && q.getEmail() != null && q.getFirstName() == null && q.getLastName() == null) {
            final User uniqueUser = this.findUserByUniqueAttribute(USER_EMAIL, q.getEmail(), userStatus);
            if (uniqueUser != null) {
                return new ListAccess<User>(){

                    public User[] load(int index, int length) throws Exception {
                        return new User[]{uniqueUser};
                    }

                    public int getSize() throws Exception {
                        return 1;
                    }
                };
            }
            if (!q.getEmail().contains("*")) {
                return new ListAccess<User>(){

                    public User[] load(int index, int length) throws Exception {
                        return new User[0];
                    }

                    public int getSize() throws Exception {
                        return 0;
                    }
                };
            }
        }
        UserQueryBuilder qb = this.service_.getIdentitySession().createUserQueryBuilder();
        if (q.getUserName() != null) {
            Object username = q.getUserName();
            if (!((String)username).startsWith("*")) {
                username = "*" + (String)username;
            }
            if (!((String)username).endsWith("*")) {
                username = (String)username + "*";
            }
            qb.idFilter((String)username);
        }
        if (q.getEmail() != null) {
            qb.attributeValuesFilter(USER_EMAIL, new String[]{q.getEmail()});
        }
        if (q.getFirstName() != null) {
            qb.attributeValuesFilter(USER_FIRST_NAME, new String[]{q.getFirstName()});
        }
        if (q.getLastName() != null) {
            qb.attributeValuesFilter(USER_LAST_NAME, new String[]{q.getLastName()});
        }
        if (this.disableUserActived()) {
            switch (userStatus) {
                case DISABLED: {
                    if (!this.filterDisabledUsersInQueries()) break;
                    qb = this.addDisabledUserFilter(qb);
                    break;
                }
                case ANY: {
                    break;
                }
                case ENABLED: {
                    if (!this.filterDisabledUsersInQueries()) break;
                    qb = this.addEnabledUserFilter(qb);
                }
            }
        }
        IDMUserListAccess list = q.getUserName() == null && q.getEmail() == null && q.getFirstName() == null && q.getLastName() == null ? new IDMUserListAccess(qb, 20, !this.countPaginatedUsers(), this.countPaginatedUsers(), userStatus) : new IDMUserListAccess(qb, 20, false, this.countPaginatedUsers(), userStatus);
        return list;
    }

    public LazyPageList findUsersByGroup(String groupId) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "findUsersByGroup", new Object[]{"groupId", groupId});
        }
        return new LazyPageList(this.findUsersByGroupId(groupId), 20);
    }

    public User findUserByEmail(String email) throws Exception {
        return this.findUserByUniqueAttribute(USER_EMAIL, email, UserStatus.ENABLED);
    }

    public User findUserByUniqueAttribute(String attributeName, String attributeValue, UserStatus userStatus) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "findUserByUniqueAttribute", new Object[]{"findUserByUniqueAttribute", attributeName, attributeValue, userStatus});
        }
        IdentitySession session = this.service_.getIdentitySession();
        org.picketlink.idm.api.User plUser = null;
        try {
            this.orgService.flush();
            plUser = session.getAttributesManager().findUserByUniqueAttribute(attributeName, (Object)attributeValue);
        }
        catch (Exception e) {
            this.handleException("Cannot find user by unique attribute: attrName=" + attributeName + ", attrValue=" + attributeValue + "; ", e);
        }
        UserImpl user = null;
        if (plUser != null) {
            user = new UserImpl(plUser.getId());
            this.populateUser((User)user, session);
            if (this.disableUserActived() && !userStatus.matches(user.isEnabled())) {
                user = null;
            }
        }
        if (this.log.isTraceEnabled()) {
            Tools.logMethodOut(this.log, LogLevel.TRACE, "findUserByUniqueAttribute", (Object)user);
        }
        return user;
    }

    public ListAccess<User> findUsersByGroupId(String groupId) throws Exception {
        return this.findUsersByGroupId(groupId, UserStatus.ENABLED);
    }

    public ListAccess<User> findUsersByQuery(Query query, List<String> groupIds, UserStatus userStatus) throws Exception {
        UserQueryBuilder qb = this.service_.getIdentitySession().createUserQueryBuilder();
        ArrayList<Group> groups = new ArrayList<Group>();
        for (String groupId : groupIds) {
            try {
                Group group = this.orgService.getJBIDMGroup(groupId);
                if (group == null) continue;
                groups.add(group);
            }
            catch (Exception e) {
                this.handleException("Cannot obtain group: " + groupId + "; ", e);
            }
        }
        qb.addRelatedGroups(groups);
        if (query.getUserName() != null) {
            Object username = query.getUserName();
            if (!((String)username).startsWith("*")) {
                username = "*" + (String)username;
            }
            if (!((String)username).endsWith("*")) {
                username = (String)username + "*";
            }
            qb.idFilter((String)username);
        }
        if (query.getEmail() != null) {
            qb.attributeValuesFilter(USER_EMAIL, new String[]{query.getEmail()});
        }
        if (query.getFirstName() != null) {
            qb.attributeValuesFilter(USER_FIRST_NAME, new String[]{query.getFirstName()});
        }
        if (query.getLastName() != null) {
            qb.attributeValuesFilter(USER_LAST_NAME, new String[]{query.getLastName()});
        }
        if (this.disableUserActived()) {
            switch (userStatus) {
                case DISABLED: {
                    if (!this.filterDisabledUsersInQueries()) break;
                    qb = this.addDisabledUserFilter(qb);
                    break;
                }
                case ANY: {
                    break;
                }
                case ENABLED: {
                    if (!this.filterDisabledUsersInQueries()) break;
                    qb = this.addEnabledUserFilter(qb);
                }
            }
        }
        return new IDMUserListAccess(qb, 20, false, this.countPaginatedUsers(), userStatus);
    }

    public ListAccess<User> findUsersByGroupId(String groupId, UserStatus userStatus) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "findUsersByGroupId", new Object[]{groupId, userStatus});
        }
        UserQueryBuilder qb = this.service_.getIdentitySession().createUserQueryBuilder();
        Group jbidGroup = null;
        try {
            jbidGroup = this.orgService.getJBIDMGroup(groupId);
        }
        catch (Exception e) {
            this.handleException("Cannot obtain group: " + groupId + "; ", e);
        }
        if (jbidGroup == null) {
            return new ListAccess<User>(){

                public User[] load(int index, int length) throws Exception {
                    if (index > 0 || length > 0) {
                        throw new IndexOutOfBoundsException("Try to access an empty list");
                    }
                    return new User[0];
                }

                public int getSize() throws Exception {
                    return 0;
                }
            };
        }
        qb.addRelatedGroup(jbidGroup);
        if (this.disableUserActived()) {
            switch (userStatus) {
                case DISABLED: {
                    if (!this.filterDisabledUsersInQueries()) break;
                    qb = this.addDisabledUserFilter(qb);
                    break;
                }
                case ANY: {
                    break;
                }
                case ENABLED: {
                    if (!this.filterDisabledUsersInQueries()) break;
                    qb = this.addEnabledUserFilter(qb);
                }
            }
        }
        return new IDMUserListAccess(qb, 20, false, this.countPaginatedUsers(), userStatus);
    }

    private void preSave(User user, boolean isNew) {
        for (UserEventListener listener : this.listeners_) {
            this.executeWithTransaction(() -> this.preSave(listener, user, isNew));
        }
    }

    private void postSave(User user, boolean isNew) {
        for (UserEventListener listener : this.listeners_) {
            this.executeWithTransaction(() -> this.postSave(listener, user, isNew));
        }
    }

    private void preDelete(User user) {
        for (UserEventListener listener : this.listeners_) {
            this.executeWithTransaction(() -> this.preDelete(listener, user));
        }
    }

    private void postDelete(User user) {
        for (UserEventListener listener : this.listeners_) {
            this.executeWithTransaction(() -> this.postDelete(listener, user));
        }
    }

    private void preSetEnabled(User user) {
        for (UserEventListener listener : this.listeners_) {
            this.executeWithTransaction(() -> this.preSetEnabled(listener, user));
        }
    }

    private void postSetEnabled(User user) throws Exception {
        for (UserEventListener listener : this.listeners_) {
            this.executeWithTransaction(() -> this.postSetEnabled(listener, user));
        }
    }

    public void persistUserInfo(User user, IdentitySession session, boolean isNew) throws Exception {
        this.persistUserInfo(user, null, session, isNew);
    }

    public void persistUserInfo(User user, org.picketlink.idm.api.User plIDMUser, IdentitySession session, boolean isNew) throws Exception {
        this.orgService.flush();
        AttributesManager am = session.getAttributesManager();
        ArrayList<SimpleAttribute> attributes = new ArrayList<SimpleAttribute>();
        if (user.getCreatedDate() != null) {
            attributes.add(new SimpleAttribute(USER_CREATED_DATE, (Object)("" + user.getCreatedDate().getTime())));
        }
        if (user.getLastLoginTime() != null) {
            attributes.add(new SimpleAttribute(USER_LAST_LOGIN_TIME, (Object)("" + user.getLastLoginTime().getTime())));
        }
        if (user.getEmail() != null) {
            attributes.add(new SimpleAttribute(USER_EMAIL, (Object)user.getEmail()));
        }
        if (user.getFirstName() != null) {
            attributes.add(new SimpleAttribute(USER_FIRST_NAME, (Object)user.getFirstName()));
        }
        if (user.getLastName() != null) {
            attributes.add(new SimpleAttribute(USER_LAST_NAME, (Object)user.getLastName()));
        }
        if (!user.isEnabled()) {
            attributes.add(new SimpleAttribute(USER_ENABLED, (Object)Boolean.toString(user.isEnabled())));
        }
        if (user instanceof UserImpl) {
            UserImpl userImpl = (UserImpl)user;
            if (userImpl.getDisplayName() != null) {
                attributes.add(new SimpleAttribute(USER_DISPLAY_NAME, (Object)((UserImpl)user).getDisplayName()));
            } else {
                this.removeDisplayNameIfNeeded(am, user);
            }
        } else {
            this.log.warn((Object)("User is of class " + user.getClass() + " which is not instanceof " + UserImpl.class));
        }
        if (user.getOrganizationId() != null) {
            attributes.add(new SimpleAttribute(USER_ORGANIZATION_ID, (Object)user.getOrganizationId()));
        }
        if (user instanceof UserImpl && ((UserImpl)user).getOriginatingStore() != null) {
            attributes.add(new SimpleAttribute("store", (Object)((UserImpl)user).getOriginatingStore()));
        }
        if (user.getPassword() != null) {
            if (user instanceof UserImpl && !((UserImpl)user).isInternalStore()) {
                throw new IllegalStateException("User originating store is external, thus the password can't be changed");
            }
            if (this.orgService.getConfiguration().isPasswordAsAttribute()) {
                attributes.add(new SimpleAttribute(USER_PASSWORD, (Object)user.getPassword()));
            } else {
                try {
                    if (plIDMUser == null) {
                        plIDMUser = session.getPersistenceManager().findUser(user.getUserName());
                    }
                    am.updatePassword(plIDMUser, user.getPassword());
                }
                catch (Exception e) {
                    this.handleException("Cannot update password: " + user.getUserName() + "; ", e);
                }
            }
        }
        Attribute[] attrs = new Attribute[attributes.size()];
        attrs = attributes.toArray(attrs);
        try {
            am.updateAttributes(user.getUserName(), attrs);
        }
        catch (Exception e) {
            this.handleException("Cannot update attributes for user: " + user.getUserName() + "; ", e);
        }
    }

    public User getPopulatedUser(String userName, IdentitySession session, UserStatus userStatus) throws Exception {
        org.picketlink.idm.api.User u = null;
        this.orgService.flush();
        try {
            u = session.getPersistenceManager().findUser(userName);
        }
        catch (IllegalArgumentException e) {
            this.log.debug((Object)"Can NOT find any user with username is NULL");
        }
        catch (Exception e) {
            this.handleException("Cannot obtain user: " + userName + "; ", e);
        }
        if (u == null) {
            return null;
        }
        UserImpl user = new UserImpl(u.getId());
        this.populateUser((User)user, session);
        if (this.disableUserActived()) {
            return userStatus.matches(user.isEnabled()) ? user : null;
        }
        return user;
    }

    public void populateUser(User user, IdentitySession session) throws Exception {
        AttributesManager am = session.getAttributesManager();
        Map attrs = null;
        try {
            attrs = am.getAttributes((IdentityType)new SimpleUser(user.getUserName()));
        }
        catch (Exception e) {
            this.handleException("Cannot obtain attributes for user: " + user.getUserName() + "; ", e);
        }
        if (attrs == null) {
            return;
        }
        EntityMapperUtils.populateUser(user, attrs);
        if (attrs.containsKey(USER_PASSWORD)) {
            user.setPassword(((Attribute)attrs.get(USER_PASSWORD)).getValue().toString());
        }
    }

    public PicketLinkIDMOrganizationServiceImpl getOrgService() {
        return this.orgService;
    }

    private String getCacheNS() {
        return ((PicketLinkIDMServiceImpl)this.service_).getRealmName();
    }

    private void removeDisplayNameIfNeeded(AttributesManager am, User user) throws Exception {
        try {
            Attribute attr = am.getAttribute(user.getUserName(), USER_DISPLAY_NAME);
            if (attr != null) {
                am.removeAttributes(user.getUserName(), new String[]{USER_DISPLAY_NAME});
            }
        }
        catch (Exception e) {
            this.handleException("Cannot remove displayName attribute of user: " + user.getUserName() + "; ", e);
        }
    }

    private UserQueryBuilder addEnabledUserFilter(UserQueryBuilder qb) throws Exception {
        return qb.attributeValuesFilter(USER_ENABLED, new String[0]);
    }

    private UserQueryBuilder addDisabledUserFilter(UserQueryBuilder qb) throws Exception {
        return qb.attributeValuesFilter(USER_ENABLED, new String[]{Boolean.FALSE.toString()});
    }

    private boolean countPaginatedUsers() {
        return this.orgService.getConfiguration().isCountPaginatedUsers();
    }

    private boolean filterDisabledUsersInQueries() {
        return this.orgService.getConfiguration().isFilterDisabledUsersInQueries();
    }

    private boolean disableUserActived() {
        return this.orgService.getConfiguration().isDisableUserActived();
    }

    private void preSave(UserEventListener listener, User user, boolean isNew) {
        try {
            listener.preSave(user, isNew);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format(LISTENER_EXECUTION_ERR_MSG, "preSave", listener.getClass().getName(), user.getUserName()), e);
        }
    }

    private void postSave(UserEventListener listener, User user, boolean isNew) {
        try {
            listener.postSave(user, isNew);
        }
        catch (Exception e) {
            this.log.warn((Object)String.format(LISTENER_EXECUTION_ERR_MSG, "postSave", listener.getClass().getName(), user.getUserName()), (Throwable)e);
        }
    }

    private void preDelete(UserEventListener listener, User user) {
        try {
            listener.preDelete(user);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format(LISTENER_EXECUTION_ERR_MSG, "preDelete", listener.getClass().getName(), user.getUserName()), e);
        }
    }

    private void postDelete(UserEventListener listener, User user) {
        try {
            listener.postDelete(user);
        }
        catch (Exception e) {
            this.log.warn((Object)String.format(LISTENER_EXECUTION_ERR_MSG, "postDelete", listener.getClass().getName(), user.getUserName()), (Throwable)e);
        }
    }

    private void preSetEnabled(UserEventListener listener, User user) {
        try {
            listener.preSetEnabled(user);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format(LISTENER_EXECUTION_ERR_MSG, "preSetEnabled", listener.getClass().getName(), user.getUserName()), e);
        }
    }

    private void postSetEnabled(UserEventListener listener, User user) {
        try {
            listener.postSetEnabled(user);
        }
        catch (Exception e) {
            this.log.warn((Object)String.format(LISTENER_EXECUTION_ERR_MSG, "postSetEnabled", listener.getClass().getName(), user.getUserName()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWithTransaction(Runnable runnable) {
        int transactionCount = this.restartTransaction();
        ExoContainer portalContainer = this.getPortalContainer();
        if (transactionCount == 0) {
            this.orgService.startRequest(portalContainer);
        }
        try {
            runnable.run();
        }
        finally {
            if (transactionCount == 0 && this.orgService.isStarted(portalContainer)) {
                this.orgService.endRequest(portalContainer);
            }
        }
    }

    protected int restartTransaction() {
        ExoContainer portalContainer = this.getPortalContainer();
        int i = 0;
        while (this.orgService.isStarted(portalContainer)) {
            this.orgService.endRequest(portalContainer);
            ++i;
        }
        for (int j = 0; j < i; ++j) {
            this.orgService.startRequest(portalContainer);
        }
        return i;
    }

    private ExoContainer getPortalContainer() {
        ExoContainer currentContainer = ExoContainerContext.getCurrentContainer();
        if (currentContainer == null || currentContainer instanceof RootContainer) {
            currentContainer = PortalContainer.getInstance();
        }
        return currentContainer;
    }

    static {
        dateFormat = DateFormat.getInstance();
        HashSet<String> keys = new HashSet<String>();
        keys.add(USER_PASSWORD);
        keys.add(USER_PASSWORD_SALT);
        keys.add(USER_FIRST_NAME);
        keys.add(USER_LAST_NAME);
        keys.add(USER_DISPLAY_NAME);
        keys.add(USER_EMAIL);
        keys.add(USER_CREATED_DATE);
        keys.add(USER_LAST_LOGIN_TIME);
        keys.add(USER_ORGANIZATION_ID);
        keys.add(USER_ENABLED);
        keys.add("store");
        keys.add(USER_PASSWORD_SALT128);
        USER_NON_PROFILE_KEYS = Collections.unmodifiableSet(keys);
    }
}

