/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.analytics;

import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.service.RuleService;
import org.exoplatform.analytics.listener.social.BaseAttachmentAnalyticsListener;
import org.exoplatform.analytics.model.StatisticData;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.attachment.model.ObjectAttachmentId;
import org.exoplatform.social.core.space.spi.SpaceService;

@Asynchronous
public class RuleAttachmentAnalyticsListener
extends BaseAttachmentAnalyticsListener {
    private RuleService ruleService;

    public RuleAttachmentAnalyticsListener(AttachmentService attachmentService, SpaceService spaceService, InitParams initParams, RuleService ruleService) {
        super(attachmentService, spaceService, initParams);
        this.ruleService = ruleService;
    }

    protected void extendStatisticData(StatisticData statisticData, ObjectAttachmentId objectAttachment) {
        RuleDTO rule = this.ruleService.findRuleById(Long.parseLong(objectAttachment.getObjectId()));
        if (rule != null) {
            ProgramDTO program = rule.getProgram();
            if (program != null) {
                statisticData.addParameter("programTitle", (Object)rule.getProgram().getTitle());
            }
            statisticData.addParameter("ruleTitle", (Object)rule.getTitle());
        }
    }

    protected String getModule(ObjectAttachmentId objectAttachment) {
        return "gamification";
    }

    protected String getSubModule(ObjectAttachmentId objectAttachment) {
        return "rule";
    }
}

