/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil.detector;

import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.detector.MagicMimeEntry;
import java.util.Iterator;

class MatchingMagicMimeEntry {
    private MagicMimeEntry magicMimeEntry;
    private double specificity = -1.0;

    public MatchingMagicMimeEntry(MagicMimeEntry magicMimeEntry) {
        this.magicMimeEntry = magicMimeEntry;
    }

    public MagicMimeEntry getMagicMimeEntry() {
        return this.magicMimeEntry;
    }

    private int getLevel() {
        int l = 0;
        MagicMimeEntry parent = this.magicMimeEntry.getParent();
        while (parent != null) {
            ++l;
            parent = parent.getParent();
        }
        return l;
    }

    private int getRecursiveSubEntryCount() {
        return this.getRecursiveSubEntryCount(this.magicMimeEntry, 0);
    }

    public int getRecursiveSubEntryCount(MagicMimeEntry entry, int subLevel) {
        ++subLevel;
        int result = 0;
        Iterator it = entry.getSubEntries().iterator();
        while (it.hasNext()) {
            MagicMimeEntry subEntry = (MagicMimeEntry)it.next();
            result += subLevel * (1 + this.getRecursiveSubEntryCount(subEntry, subLevel));
        }
        return result;
    }

    public double getSpecificity() {
        if (this.specificity < 0.0) {
            this.specificity = (double)(this.getLevel() + 1) / (double)(this.getRecursiveSubEntryCount() + 1);
        }
        return this.specificity;
    }

    public MimeType getMimeType() {
        return new MimeType(this.magicMimeEntry.getMimeType());
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + '[' + this.getMimeType() + ',' + this.getSpecificity() + ']';
    }
}

