/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.api;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.rest.impl.ApplicationContextImpl;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.user.UserStateModel;
import org.exoplatform.services.user.UserStateService;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.rest.entity.DataEntity;

public class RestUtils {
    public static final int DEFAULT_LIMIT = 20;
    public static final int DEFAULT_OFFSET = 0;
    public static final int HARD_LIMIT = 500;
    public static final String SUPPORT_TYPE = "json";
    public static final String ADMIN_GROUP = "/platform/administrators";
    public static final String DELEGATED_GROUP = "/platform/delegated";
    public static final String INVISIBLE = "invisible";
    private static IdentityManager identityManager;

    public static String formatISO8601(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return ISO8601.format((Calendar)calendar);
    }

    public static MediaType getJsonMediaType() {
        return RestUtils.getMediaType(SUPPORT_TYPE, new String[]{SUPPORT_TYPE});
    }

    public static MediaType getMediaType(String expectedFormat, String[] supportedFormats) {
        if (!RestUtils.isSupportedFormat(expectedFormat, supportedFormats)) {
            throw new WebApplicationException(Response.Status.UNSUPPORTED_MEDIA_TYPE);
        }
        if (expectedFormat.equals(SUPPORT_TYPE) && RestUtils.isSupportedFormat(SUPPORT_TYPE, supportedFormats)) {
            return MediaType.APPLICATION_JSON_TYPE;
        }
        if (expectedFormat.equals("xml") && RestUtils.isSupportedFormat("xml", supportedFormats)) {
            return MediaType.APPLICATION_XML_TYPE;
        }
        if (expectedFormat.equals("atom") && RestUtils.isSupportedFormat("atom", supportedFormats)) {
            return MediaType.APPLICATION_ATOM_XML_TYPE;
        }
        throw new WebApplicationException(Response.Status.NOT_ACCEPTABLE);
    }

    private static boolean isSupportedFormat(String expectedFormat, String[] supportedFormats) {
        for (String supportedFormat : supportedFormats) {
            if (!supportedFormat.equals(expectedFormat)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMemberOfAdminGroup() {
        return ConversationState.getCurrent().getIdentity().isMemberOf(ADMIN_GROUP);
    }

    public static boolean isMemberOfDelegatedGroup() {
        return ConversationState.getCurrent().getIdentity().isMemberOf(DELEGATED_GROUP);
    }

    public static String getRestUrl(String type, String id, String restPath) {
        if (StringUtils.isBlank((String)restPath)) {
            return null;
        }
        String version = restPath.split("/")[1];
        String socialResource = restPath.split("/")[2];
        return new StringBuffer(RestUtils.getBaseRestUrl()).append("/").append(version).append("/").append(socialResource).append("/").append(type).append("/").append(id).toString();
    }

    public static String getBaseRestUrl() {
        return new StringBuffer(RestUtils.getBaseUrl()).append("/").append(PortalContainer.getCurrentPortalContainerName()).append("/").append(CommonsUtils.getRestContextName()).toString();
    }

    public static String getBaseUrl() {
        if (ApplicationContextImpl.getCurrent() == null) {
            return "";
        }
        String fullUrl = ApplicationContextImpl.getCurrent().getBaseUri().toString();
        return fullUrl != null && !fullUrl.isEmpty() ? fullUrl.substring(0, fullUrl.indexOf("/", 9)) : "";
    }

    public static boolean isAnonymous() {
        return ConversationState.getCurrent() == null || ConversationState.getCurrent().getIdentity() == null || IdentityConstants.ANONIM.equals(ConversationState.getCurrent().getIdentity().getUserId());
    }

    public static String getPathParam(UriInfo uriInfo, String name) {
        return (String)uriInfo.getPathParameters().getFirst((Object)name);
    }

    public static String getQueryParam(UriInfo uriInfo, String name) {
        return (String)uriInfo.getQueryParameters().getFirst((Object)name);
    }

    public static int getLimit(UriInfo uriInfo) {
        Integer limit = RestUtils.getIntegerValue(uriInfo, "limit");
        return limit != null && limit > 0 ? Math.min(500, limit) : 20;
    }

    public static int getOffset(UriInfo uriInfo) {
        Integer offset = RestUtils.getIntegerValue(uriInfo, "offset");
        return offset != null ? offset : 0;
    }

    public static Integer getIntegerValue(UriInfo uriInfo, String name) {
        String value = RestUtils.getQueryParam(uriInfo, name);
        if (value == null) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Long getLongValue(UriInfo uriInfo, String name) {
        String value = RestUtils.getQueryParam(uriInfo, name);
        if (value == null) {
            return null;
        }
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static boolean isReturnSize(UriInfo uriInfo) {
        return Boolean.parseBoolean(RestUtils.getQueryParam(uriInfo, "returnSize"));
    }

    public static DataEntity extractInfo(DataEntity inEntity, List<String> returnedProperties) {
        DataEntity outEntity = new DataEntity();
        for (Map.Entry entry : inEntity.entrySet()) {
            if (!returnedProperties.contains(entry.getKey())) continue;
            outEntity.setProperty((String)entry.getKey(), entry.getValue());
        }
        return outEntity;
    }

    public static long getBaseTime(String baseDateTime) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date date = sdf.parse(baseDateTime);
        return date.getTime();
    }

    public static org.exoplatform.social.core.identity.model.Identity getUserIdentity(String user) {
        return RestUtils.isAnonymous() ? null : RestUtils.getIdentityManager().getOrCreateIdentity("organization", user);
    }

    public static org.exoplatform.social.core.identity.model.Identity getCurrentUserIdentity() {
        return RestUtils.isAnonymous() ? null : RestUtils.getUserIdentity(RestUtils.getCurrentUser());
    }

    public static long getCurrentUserIdentityId() {
        String currentUser = RestUtils.getCurrentUser();
        if (RestUtils.isAnonymous() || currentUser == null) {
            return 0L;
        }
        org.exoplatform.social.core.identity.model.Identity userIdentity = RestUtils.getUserIdentity(currentUser);
        String id = userIdentity == null ? null : userIdentity.getId();
        return id == null ? 0L : Long.parseLong(id);
    }

    public static Identity getCurrentUserAclIdentity() {
        return RestUtils.isAnonymous() ? null : ConversationState.getCurrent().getIdentity();
    }

    public static String getCurrentUser() {
        return RestUtils.isAnonymous() ? null : ConversationState.getCurrent().getIdentity().getUserId();
    }

    public static org.exoplatform.social.core.identity.model.Identity[] getOnlineIdentitiesOfSpace(UserStateService userStateService, String userId, Space space, int limit) {
        ArrayList<org.exoplatform.social.core.identity.model.Identity> identities = new ArrayList<org.exoplatform.social.core.identity.model.Identity>();
        String[] spaceMembers = space.getMembers();
        String superUserName = ((UserACL)ExoContainerContext.getService(UserACL.class)).getSuperUser();
        if (userStateService == null) {
            userStateService = (UserStateService)ExoContainerContext.getService(UserStateService.class);
        }
        for (String user : spaceMembers) {
            UserStateModel userModel = userStateService.getUserState(user);
            boolean isOnline = userStateService.isOnline(user);
            if (user.equals(userId) || user.equals(superUserName) || userModel == null || INVISIBLE.equals(userModel.getStatus()) || !isOnline) continue;
            org.exoplatform.social.core.identity.model.Identity userIdentity = RestUtils.getIdentityManager().getOrCreateUserIdentity(user);
            identities.add(userIdentity);
            if (identities.size() == limit) break;
        }
        return identities.toArray(new org.exoplatform.social.core.identity.model.Identity[identities.size()]);
    }

    public static org.exoplatform.social.core.identity.model.Identity[] getOnlineIdentities(UserStateService userStateService, String userId, int limit) {
        ArrayList<org.exoplatform.social.core.identity.model.Identity> identities = new ArrayList<org.exoplatform.social.core.identity.model.Identity>();
        if (userStateService == null) {
            userStateService = (UserStateService)ExoContainerContext.getService(UserStateService.class);
        }
        List users = userStateService.online();
        Collections.reverse(users);
        if (users.size() > limit) {
            users = users.subList(0, limit);
        }
        UserACL userACL = (UserACL)ExoContainerContext.getService(UserACL.class);
        String superUserName = userACL.getSuperUser();
        for (UserStateModel userModel : users) {
            String user = userModel == null ? null : userModel.getUserId();
            if (StringUtils.isBlank((String)user) || user.equals(userId) || user.equals(superUserName) || INVISIBLE.equals(userModel.getStatus())) continue;
            org.exoplatform.social.core.identity.model.Identity userIdentity = RestUtils.getIdentityManager().getOrCreateUserIdentity(user);
            identities.add(userIdentity);
        }
        return identities.toArray(new org.exoplatform.social.core.identity.model.Identity[identities.size()]);
    }

    public static IdentityManager getIdentityManager() {
        if (identityManager == null) {
            identityManager = (IdentityManager)ExoContainerContext.getService(IdentityManager.class);
        }
        return identityManager;
    }
}

