/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.manager;

import java.util.List;
import java.util.Map;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.deprecation.DeprecatedAPI;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.storage.RelationshipStorageException;

public interface RelationshipManager {
    public Relationship get(String var1);

    public Relationship get(Identity var1, Identity var2);

    public Relationship inviteToConnect(Identity var1, Identity var2);

    public Relationship confirm(Identity var1, Identity var2);

    public void deny(Identity var1, Identity var2);

    public Relationship ignore(Identity var1, Identity var2);

    public void delete(Relationship var1);

    public ListAccess<Identity> getConnections(Identity var1);

    public ListAccess<Identity> getIncomingWithListAccess(Identity var1);

    public ListAccess<Identity> getOutgoing(Identity var1);

    public ListAccess<Identity> getAllWithListAccess(Identity var1);

    public Relationship.Type getStatus(Identity var1, Identity var2);

    @Deprecated(forRemoval=true)
    public Relationship invite(Identity var1, Identity var2) throws RelationshipStorageException;

    public Relationship getRelationshipById(String var1) throws RelationshipStorageException;

    @Deprecated(forRemoval=true)
    public void confirm(Relationship var1) throws RelationshipStorageException;

    @Deprecated(forRemoval=true)
    public void deny(Relationship var1) throws RelationshipStorageException;

    @Deprecated(forRemoval=true)
    public void remove(Relationship var1) throws RelationshipStorageException;

    @Deprecated(forRemoval=true)
    public void ignore(Relationship var1) throws RelationshipStorageException;

    @Deprecated(forRemoval=true)
    public List<Relationship> getPendingRelationships(Identity var1) throws RelationshipStorageException;

    @Deprecated(forRemoval=true)
    public List<Relationship> getPendingRelationships(Identity var1, boolean var2) throws RelationshipStorageException;

    @Deprecated(forRemoval=true)
    public List<Relationship> getPendingRelationships(Identity var1, List<Identity> var2, boolean var3) throws RelationshipStorageException;

    @Deprecated(forRemoval=true)
    public List<Relationship> getContacts(Identity var1, List<Identity> var2) throws RelationshipStorageException;

    @Deprecated(forRemoval=true)
    public List<Relationship> getContacts(Identity var1) throws RelationshipStorageException;

    @Deprecated(forRemoval=true)
    public List<Relationship> getAllRelationships(Identity var1) throws RelationshipStorageException;

    @Deprecated(forRemoval=true)
    public List<Relationship> getRelationshipsByIdentityId(String var1) throws RelationshipStorageException;

    @Deprecated(forRemoval=true)
    public List<Identity> getIdentities(Identity var1) throws Exception;

    @Deprecated(forRemoval=true)
    public Relationship getRelationship(Identity var1, Identity var2) throws RelationshipStorageException;

    @Deprecated(forRemoval=true)
    public List<Identity> findRelationships(Identity var1, Relationship.Type var2) throws RelationshipStorageException;

    @Deprecated(forRemoval=true)
    public Relationship.Type getRelationshipStatus(Relationship var1, Identity var2);

    @Deprecated(forRemoval=true)
    public Relationship.Type getConnectionStatus(Identity var1, Identity var2) throws Exception;

    @Deprecated(forRemoval=true)
    public List<Relationship> getPending(Identity var1) throws RelationshipStorageException;

    @Deprecated(forRemoval=true)
    public List<Relationship> getPending(Identity var1, List<Identity> var2) throws RelationshipStorageException;

    @Deprecated(forRemoval=true)
    public List<Relationship> getIncoming(Identity var1) throws RelationshipStorageException;

    @Deprecated(forRemoval=true)
    public List<Relationship> getIncoming(Identity var1, List<Identity> var2) throws RelationshipStorageException;

    @Deprecated(forRemoval=true)
    public List<Relationship> getConfirmed(Identity var1) throws RelationshipStorageException;

    @Deprecated(forRemoval=true)
    public List<Relationship> getConfirmed(Identity var1, List<Identity> var2) throws RelationshipStorageException;

    @Deprecated(forRemoval=true)
    public List<Relationship> getAll(Identity var1) throws RelationshipStorageException;

    @Deprecated(forRemoval=true)
    public List<Relationship> getAll(Identity var1, List<Identity> var2) throws RelationshipStorageException;

    @Deprecated(forRemoval=true)
    public List<Relationship> getAll(Identity var1, Relationship.Type var2, List<Identity> var3) throws RelationshipStorageException;

    public ListAccess<Identity> getConnectionsByFilter(Identity var1, ProfileFilter var2);

    @DeprecatedAPI(value="Must use getIncoming method instead, ES doesn't index incomings")
    @Deprecated(forRemoval=true)
    public ListAccess<Identity> getIncomingByFilter(Identity var1, ProfileFilter var2);

    @DeprecatedAPI(value="Must use getIncoming method instead, ES doesn't index outgoings")
    @Deprecated(forRemoval=true)
    public ListAccess<Identity> getOutgoingByFilter(Identity var1, ProfileFilter var2);

    public Map<Identity, Integer> getSuggestions(Identity var1, int var2, int var3, int var4);

    @Deprecated(forRemoval=true)
    public Map<Identity, Integer> getSuggestions(Identity var1, int var2, int var3);

    public List<Identity> getLastConnections(Identity var1, int var2);

    public List<Relationship> getRelationshipsByStatus(Identity var1, Relationship.Type var2, int var3, int var4);

    public int getRelationshipsCountByStatus(Identity var1, Relationship.Type var2);

    default public int getConnectionsInCommonCount(Identity identity1, Identity identity2) {
        throw new UnsupportedOperationException();
    }
}

