/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.site;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteFilter;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.http.PATCH;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.entity.SiteEntity;

@Path(value="v1/social/sites")
@Tag(name="v1/social/sites", description="Manage sites")
public class SiteRest
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(SiteRest.class);
    private LayoutService layoutService;
    private UserACL userACL;
    private static final int CACHE_IN_SECONDS = 604800;
    private static final int CACHE_IN_MILLI_SECONDS = 604800000;
    private static final CacheControl SITES_CACHE_CONTROL = new CacheControl();
    private static final CacheControl SITE_CACHE_CONTROL = new CacheControl();
    private static final CacheControl BANNER_CACHE_CONTROL = new CacheControl();

    public SiteRest(LayoutService layoutService, UserACL userACL) {
        this.layoutService = layoutService;
        this.userACL = userACL;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets sites", description="Gets sites", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getSites(@Context HttpServletRequest httpServletRequest, @Context Request request, @Parameter(description="Portal site types, possible values: PORTAL, GROUP or USER", required=true) @QueryParam(value="siteType") String siteType, @Parameter(description="Site type to be excluded") @QueryParam(value="excludedSiteType") String excludedSiteType, @Parameter(description="Site name to be excluded") @QueryParam(value="excludedSiteName") String excludedSiteName, @Parameter(description="to exclude space sites") @DefaultValue(value="false") @QueryParam(value="excludeSpaceSites") boolean excludeSpaceSites, @Parameter(description="to exclude sites with empty navigation") @DefaultValue(value="false") @QueryParam(value="excludeEmptyNavigationSites") boolean excludeEmptyNavigationSites, @Parameter(description="to expand site navigations nodes") @DefaultValue(value="false") @QueryParam(value="expandNavigations") boolean expandNavigations, @Parameter(description="Multivalued visibilities of navigation nodes to retrieve, possible values: DISPLAYED, HIDDEN, SYSTEM or TEMPORAL. If empty, all visibilities will be used.", required=false) @Schema(defaultValue="All possible values combined") @QueryParam(value="visibility") List<String> visibilityNames, @Parameter(description="to check, in expandNavigations case, the navigation nodes scheduling start and end dates") @DefaultValue(value="false") @QueryParam(value="temporalCheck") boolean temporalCheck, @Parameter(description="to exclude group nodes without page child nodes") @DefaultValue(value="false") @QueryParam(value="excludeGroupNodesWithoutPageChildNodes") boolean excludeGroupNodesWithoutPageChildNodes, @Parameter(description="to sort with display order") @DefaultValue(value="false") @QueryParam(value="sortByDisplayOrder") boolean sortByDisplayOrder, @Parameter(description="to filter sites by displayed status") @DefaultValue(value="false") @QueryParam(value="filterByDisplayed") boolean filterByDisplayed, @Parameter(description="to retrieve sites with displayed status") @DefaultValue(value="false") @QueryParam(value="displayed") boolean displayed, @Parameter(description="to filter sites by view/edit permissions") @DefaultValue(value="false") @QueryParam(value="filterByPermissions") boolean filterByPermission, @Parameter(description="Offset of results to retrieve") @QueryParam(value="offset") @DefaultValue(value="0") int offset, @Parameter(description="Limit of results to retrieve") @QueryParam(value="limit") @DefaultValue(value="0") int limit, @Parameter(description="Used to retrieve the site label and description in the requested language") @QueryParam(value="lang") String lang) {
        try {
            SiteFilter siteFilter = new SiteFilter();
            if (siteType != null) {
                siteFilter.setSiteType(SiteType.valueOf((String)siteType.toUpperCase()));
            }
            if (excludedSiteType != null) {
                siteFilter.setExcludedSiteType(SiteType.valueOf((String)excludedSiteType.toUpperCase()));
            }
            if (excludedSiteName != null) {
                siteFilter.setExcludedSiteName(excludedSiteName);
            }
            siteFilter.setExcludeSpaceSites(excludeSpaceSites);
            siteFilter.setSortByDisplayOrder(sortByDisplayOrder);
            if (filterByDisplayed) {
                siteFilter.setFilterByDisplayed(filterByDisplayed);
                siteFilter.setDisplayed(displayed);
            }
            siteFilter.setLimit(limit);
            siteFilter.setOffset(offset);
            List sites = this.layoutService.getSites(siteFilter);
            List<SiteEntity> siteEntities = EntityBuilder.buildSiteEntities(sites, httpServletRequest, expandNavigations, visibilityNames, excludeEmptyNavigationSites, temporalCheck, excludeGroupNodesWithoutPageChildNodes, filterByPermission, sortByDisplayOrder, this.getLocale(lang));
            EntityTag eTag = new EntityTag(String.valueOf(Objects.hash(siteEntities, siteFilter, expandNavigations, visibilityNames, excludeEmptyNavigationSites, temporalCheck, excludeGroupNodesWithoutPageChildNodes, filterByPermission, sortByDisplayOrder, this.getLocale(lang))));
            Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
            if (builder == null) {
                builder = Response.ok(siteEntities);
            }
            builder.tag(eTag);
            builder.cacheControl(SITES_CACHE_CONTROL);
            return builder.build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while retrieving sites", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="{siteId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets a specific site by id", description="Gets site by id", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getSiteById(@Context HttpServletRequest httpServletRequest, @Context Request request, @Parameter(description="site Id", required=true) @PathParam(value="siteId") String siteId, @Parameter(description="to expand site navigations nodes") @DefaultValue(value="false") @QueryParam(value="expandNavigations") boolean expandNavigations, @Parameter(description="Multivalued visibilities of navigation nodes to retrieve, possible values: DISPLAYED, HIDDEN, SYSTEM or TEMPORAL. If empty, all visibilities will be used.", required=false) @Schema(defaultValue="All possible values combined") @QueryParam(value="visibility") List<String> visibilityNames, @Parameter(description="to check, in expandNavigations case, the navigation nodes scheduling start and end dates") @DefaultValue(value="false") @QueryParam(value="temporalCheck") boolean temporalCheck, @Parameter(description="to exclude group nodes without page child nodes") @DefaultValue(value="false") @QueryParam(value="excludeGroupNodesWithoutPageChildNodes") boolean excludeGroupNodesWithoutPageChildNodes, @Parameter(description="to exclude sites with empty navigation") @DefaultValue(value="false") @QueryParam(value="excludeEmptyNavigationSites") boolean excludeEmptyNavigationSites, @Parameter(description="Used to retrieve the site label and description in the requested language") @QueryParam(value="lang") String lang) {
        try {
            PortalConfig site = this.layoutService.getPortalConfig(Long.parseLong(siteId));
            if (site == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (!this.userACL.hasAccessPermission(site)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            SiteEntity siteEntity = EntityBuilder.buildSiteEntity(site, httpServletRequest, expandNavigations, visibilityNames, excludeEmptyNavigationSites, temporalCheck, excludeGroupNodesWithoutPageChildNodes, this.getLocale(lang));
            EntityTag eTag = new EntityTag(String.valueOf(Objects.hash(siteId, siteEntity, expandNavigations, visibilityNames, excludeEmptyNavigationSites, temporalCheck, excludeGroupNodesWithoutPageChildNodes, this.getLocale(lang))));
            Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
            if (builder == null) {
                builder = Response.ok((Object)siteEntity);
                builder.tag(eTag);
            }
            builder.cacheControl(SITE_CACHE_CONTROL);
            return builder.build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while retrieving site", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @PATCH
    @Path(value="{siteId}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Updates a specific site attribute by id", description="Updates a specific site attribute by id", method="PATCH")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Not found")})
    public Response updateSiteById(@Parameter(description="site Id", required=true) @PathParam(value="siteId") String siteId, @Parameter(description="Site attribute name", required=true) @FormParam(value="name") String name, @Parameter(description="Site attribute value", required=true) @FormParam(value="value") String value) {
        try {
            PortalConfig site = this.layoutService.getPortalConfig(Long.parseLong(siteId));
            if (site == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (!this.userACL.hasEditPermission(site)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            if (StringUtils.equals((String)name, (String)"accessPermissions")) {
                site.setAccessPermissions(StringUtils.split((String)value, (String)","));
                this.layoutService.save(site);
                return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (Exception e) {
            LOG.warn("Error while saving site attribute {} with value {}", new Object[]{name, value, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="{siteName}/banner")
    @RolesAllowed(value={"users"})
    @Produces(value={"image/png"})
    @Operation(summary="Gets a site banner", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="403", description="Forbidden request"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getSiteBanner(@Context Request request, @Parameter(description="site name", required=true) @PathParam(value="siteName") String siteName, @Parameter(description="site banner id", required=false) @QueryParam(value="bannerId") long bannerId) {
        try {
            boolean isDefault = bannerId == 0L;
            EntityTag eTag = !isDefault ? new EntityTag(String.valueOf(bannerId)) : new EntityTag(siteName);
            Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
            if (builder == null) {
                InputStream stream = isDefault ? this.layoutService.getDefaultSiteBannerStream(siteName) : this.layoutService.getSiteBannerStream(siteName);
                builder = Response.ok((Object)stream, (String)"image/png");
                builder.tag(eTag);
            }
            builder.cacheControl(BANNER_CACHE_CONTROL);
            builder.lastModified(new Date(System.currentTimeMillis()));
            builder.expires(new Date(System.currentTimeMillis() + 604800000L));
            return builder.build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (IOException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Locale getLocale(String lang) {
        return StringUtils.isBlank((String)lang) ? null : Locale.forLanguageTag(lang);
    }

    static {
        SITES_CACHE_CONTROL.setMaxAge(604800);
        SITE_CACHE_CONTROL.setMaxAge(604800);
        BANNER_CACHE_CONTROL.setMaxAge(604800);
        BANNER_CACHE_CONTROL.setPrivate(false);
    }
}

