/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.rest.builder;

import io.meeds.gamification.constant.IdentityType;
import io.meeds.gamification.model.PiechartLeaderboard;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.StandardLeaderboard;
import io.meeds.gamification.rest.model.LeaderboardInfo;
import io.meeds.gamification.service.ProgramService;
import io.meeds.gamification.service.RealizationService;
import io.meeds.gamification.utils.Utils;
import io.meeds.social.translation.service.TranslationService;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class LeaderboardBuilder {
    private static final String MONTH_PERIOD_NAME = "MONTH";
    private static final String WEEK_PERIOD_NAME = "WEEK";

    private LeaderboardBuilder() {
    }

    public static List<LeaderboardInfo> buildLeaderboardInfos(RealizationService realizationService, IdentityManager identityManager, SpaceService spaceService, int offset, List<StandardLeaderboard> standardLeaderboards, IdentityType identityType, Long identityId, Long programId, String period, boolean isAnonymous) {
        LeaderboardInfo leader;
        ArrayList<LeaderboardInfo> leaderboardList = new ArrayList<LeaderboardInfo>();
        int rank = offset + 1;
        for (StandardLeaderboard element : standardLeaderboards) {
            Identity identity = identityManager.getIdentity(element.getEarnerId());
            if (identity == null) continue;
            leaderboardList.add(LeaderboardBuilder.toLeaderboardInfo(spaceService, element, identity, isAnonymous, rank++));
        }
        if (identityId != null && identityId > 0L && identityType.isUser() && (leader = LeaderboardBuilder.buildRank(realizationService, identityManager, spaceService, leaderboardList, period, programId, identityId, isAnonymous)) != null) {
            leaderboardList.add(leader);
        }
        return leaderboardList;
    }

    public static List<PiechartLeaderboard> buildPiechartLeaderboards(ProgramService programService, TranslationService translationService, List<PiechartLeaderboard> userStats, String currentUser, Locale locale) {
        boolean rewardingManager = Utils.isRewardingManager(currentUser);
        userStats.forEach(stat -> {
            long programId = stat.getProgramId();
            if (rewardingManager || programService.canViewProgram(programId, currentUser)) {
                ProgramDTO program = programService.getProgramById(programId);
                String programdTitle = translationService.getTranslationLabel("program", program.getId(), "title", locale);
                stat.setLabel(StringUtils.isBlank((CharSequence)programdTitle) ? program.getTitle() : programdTitle);
            }
        });
        return userStats;
    }

    public static LeaderboardInfo buildRank(RealizationService realizationService, IdentityManager identityManager, SpaceService spaceService, List<LeaderboardInfo> leaderboardList, String period, Long programId, long identityId, boolean isAnonymous) {
        if (!LeaderboardBuilder.isEarnerInTopTen(identityId, leaderboardList)) {
            Date fromDate = LeaderboardBuilder.getCurrentPeriodStartDate(period);
            int rank = realizationService.getLeaderboardRank(String.valueOf(identityId), fromDate, programId);
            if (rank > 0) {
                Identity identity = identityManager.getIdentity(String.valueOf(identityId));
                LeaderboardInfo leaderboardInfo = new LeaderboardInfo();
                leaderboardInfo.setIdentityId(Long.parseLong(identity.getId()));
                leaderboardInfo.setFullname(identity.getProfile().getFullName());
                leaderboardInfo.setAvatarUrl(identity.getProfile().getAvatarUrl());
                leaderboardInfo.setScore(realizationService.getScoreByIdentityIdAndBetweenDates(identity.getId(), fromDate, new Date()));
                leaderboardInfo.setRank(rank);
                if (!isAnonymous) {
                    leaderboardInfo.setRemoteId(identity.getRemoteId());
                    String technicalId = LeaderboardBuilder.computeTechnicalId(spaceService, identity);
                    leaderboardInfo.setTechnicalId(technicalId);
                    leaderboardInfo.setProfileUrl(identity.getProfile().getUrl());
                }
                return leaderboardInfo;
            }
        }
        return null;
    }

    public static Date getCurrentPeriodStartDate(String period) {
        return switch (period) {
            case WEEK_PERIOD_NAME -> Date.from(LocalDate.now().with(DayOfWeek.MONDAY).atStartOfDay(ZoneId.systemDefault()).toInstant());
            case MONTH_PERIOD_NAME -> Date.from(LocalDate.now().with(TemporalAdjusters.firstDayOfMonth()).atStartOfDay(ZoneId.systemDefault()).toInstant());
            default -> null;
        };
    }

    public static LeaderboardInfo toLeaderboardInfo(SpaceService spaceService, StandardLeaderboard element, Identity identity, boolean isAnonymous, int index) {
        LeaderboardInfo leaderboardInfo = new LeaderboardInfo();
        leaderboardInfo.setIdentityId(Long.parseLong(identity.getId()));
        leaderboardInfo.setFullname(identity.getProfile().getFullName());
        leaderboardInfo.setAvatarUrl(identity.getProfile().getAvatarUrl());
        leaderboardInfo.setScore(element.getReputationScore());
        leaderboardInfo.setRank(index);
        if (!isAnonymous) {
            leaderboardInfo.setRemoteId(identity.getRemoteId());
            String technicalId = LeaderboardBuilder.computeTechnicalId(spaceService, identity);
            leaderboardInfo.setTechnicalId(technicalId);
            leaderboardInfo.setProfileUrl(identity.getProfile().getUrl());
        }
        return leaderboardInfo;
    }

    private static boolean isEarnerInTopTen(long identityId, List<LeaderboardInfo> leaderboard) {
        if (leaderboard.isEmpty()) {
            return false;
        }
        return leaderboard.stream().anyMatch(l -> identityId == l.getIdentityId());
    }

    private static String computeTechnicalId(SpaceService spaceService, Identity identity) {
        if (!"space".equals(identity.getProviderId())) {
            return null;
        }
        Space space = spaceService.getSpaceByPrettyName(identity.getRemoteId());
        return space == null ? null : space.getId();
    }
}

