/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.twitter.storage.cached;

import io.meeds.gamification.twitter.model.RemoteTwitterAccount;
import io.meeds.gamification.twitter.model.TwitterAccount;
import io.meeds.gamification.twitter.storage.TwitterConsumerStorage;
import io.meeds.gamification.twitter.storage.cached.model.CacheKey;
import java.io.Serializable;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;

public class TwitterConsumerCachedStorage
extends TwitterConsumerStorage {
    public static final String TWITTER_CACHE_NAME = "twitter.connector";
    private static final int ACCOUNT_BY_ID_CONTEXT = 1;
    private final FutureExoCache<Serializable, Object, CacheKey> twitterFutureCache;

    public TwitterConsumerCachedStorage(CacheService cacheService) {
        ExoCache cacheInstance = cacheService.getCacheInstance(TWITTER_CACHE_NAME);
        this.twitterFutureCache = new FutureExoCache((context, key) -> {
            if (1 == context.getContext()) {
                return TwitterConsumerCachedStorage.super.retrieveTwitterAccount(context.getRemoteId(), context.getBearerToken());
            }
            throw new UnsupportedOperationException();
        }, cacheInstance);
    }

    @Override
    public RemoteTwitterAccount retrieveTwitterAccount(long twitterRemoteId, String bearerToken) {
        CacheKey cacheKey = new CacheKey((Integer)1, twitterRemoteId, bearerToken);
        return (RemoteTwitterAccount)this.twitterFutureCache.get((Object)cacheKey, (Object)cacheKey.hashCode());
    }

    @Override
    public void clearCache() {
        this.twitterFutureCache.clear();
    }

    @Override
    public void clearCache(TwitterAccount twitterAccount, String bearerToken) {
        this.twitterFutureCache.remove((Serializable)Integer.valueOf(new CacheKey((Integer)1, twitterAccount.getRemoteId(), bearerToken).hashCode()));
    }
}

