/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import org.hsqldb.lib.ArraySort;
import org.hsqldb.lib.BaseList;
import org.hsqldb.lib.List;

public class HsqlArrayList<E>
extends BaseList<E>
implements List<E> {
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final float DEFAULT_RESIZE_FACTOR = 2.0f;
    E[] elementData;
    E[] reserveElementData;
    private boolean minimizeOnClear;

    public HsqlArrayList(E[] EArray, int n) {
        this.elementData = EArray;
        this.elementCount = n;
    }

    public HsqlArrayList() {
        this.elementData = new Object[8];
    }

    public HsqlArrayList(int n, boolean bl) {
        if (n < 8) {
            n = 8;
        }
        this.elementData = new Object[n];
        this.minimizeOnClear = bl;
    }

    public HsqlArrayList(int n) {
        if (n < 0) {
            throw new NegativeArraySizeException("Invalid initial capacity given");
        }
        if (n < 8) {
            n = 8;
        }
        this.elementData = new Object[n];
    }

    @Override
    public void add(int n, E e) {
        if (n > this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n + ">" + this.elementCount);
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n + " < 0");
        }
        if (this.elementCount >= this.elementData.length) {
            this.increaseCapacity();
        }
        if (n < this.elementCount) {
            System.arraycopy(this.elementData, n, this.elementData, n + 1, this.elementCount - n);
        }
        this.elementData[n] = e;
        ++this.elementCount;
    }

    @Override
    public boolean add(E e) {
        if (this.elementCount >= this.elementData.length) {
            this.increaseCapacity();
        }
        this.elementData[this.elementCount] = e;
        ++this.elementCount;
        return true;
    }

    @Override
    public E get(int n) {
        if (n >= this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n + " >= " + this.elementCount);
        }
        return this.elementData[n];
    }

    @Override
    public int indexOf(Object object) {
        if (object == null) {
            for (int i = 0; i < this.elementCount; ++i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
            return -1;
        }
        for (int i = 0; i < this.elementCount; ++i) {
            if (!this.comparator.equals(object, this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public E remove(int n) {
        if (n >= this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n + " >= " + this.elementCount);
        }
        E e = this.elementData[n];
        if (n < this.elementCount - 1) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, this.elementCount - 1 - n);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
        if (this.elementCount == 0) {
            this.clear();
        }
        return e;
    }

    @Override
    public E set(int n, E e) {
        if (n >= this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n + " >= " + this.elementCount);
        }
        E e2 = this.elementData[n];
        this.elementData[n] = e;
        return e2;
    }

    @Override
    public final int size() {
        return this.elementCount;
    }

    private void increaseCapacity() {
        int n = this.elementData.length == 0 ? 1 : this.elementData.length;
        n = (int)((float)n * 2.0f);
        this.resize(n);
    }

    private void resize(int n) {
        if (n == this.elementData.length) {
            return;
        }
        Object[] objectArray = (Object[])Array.newInstance(this.elementData.getClass().getComponentType(), n);
        int n2 = this.elementData.length > objectArray.length ? objectArray.length : this.elementData.length;
        System.arraycopy(this.elementData, 0, objectArray, 0, n2);
        if (this.minimizeOnClear && this.reserveElementData == null) {
            Arrays.fill(this.elementData, (Object)0);
            this.reserveElementData = this.elementData;
        }
        this.elementData = objectArray;
    }

    public void trim() {
        this.resize(this.elementCount);
    }

    @Override
    public void clear() {
        if (this.minimizeOnClear && this.reserveElementData != null) {
            this.elementData = this.reserveElementData;
            this.reserveElementData = null;
            this.elementCount = 0;
            return;
        }
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = null;
        }
        this.elementCount = 0;
    }

    public void setSize(int n) {
        if (n == 0) {
            this.clear();
            return;
        }
        if (n <= this.elementCount) {
            for (int i = n; i < this.elementCount; ++i) {
                this.elementData[i] = null;
            }
            this.elementCount = n;
            return;
        }
        while (n > this.elementData.length) {
            this.increaseCapacity();
        }
        this.elementCount = n;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.elementCount];
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
        return objectArray;
    }

    public <T> T[] toArray(T[] objectArray) {
        if (objectArray.length < this.elementCount) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.elementCount);
        }
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
        return objectArray;
    }

    public void toArraySlice(E[] EArray, int n, int n2) {
        System.arraycopy(this.elementData, n, EArray, 0, n2 - n);
    }

    public E[] getArray() {
        return this.elementData;
    }

    public void sort(Comparator<? super E> comparator) {
        if (this.elementCount < 2) {
            return;
        }
        ArraySort.sort(this.elementData, this.elementCount, comparator);
    }

    public int lastIndexOf(Object object) {
        if (object == null) {
            for (int i = this.elementCount - 1; i >= 0; --i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
            return -1;
        }
        for (int i = this.elementCount - 1; i >= 0; --i) {
            if (!this.comparator.equals(object, this.elementData[i])) continue;
            return i;
        }
        return -1;
    }
}

