/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.resolver;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletContext;
import javax.servlet.ServletContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.resolver.ResourceKey;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class PortletResourceResolver
extends ResourceResolver {
    protected static Log log = ExoLogger.getLogger(PortletResourceResolver.class);
    private ServletContext portalContext;
    private PortletContext portletContext;
    private String scheme;

    public PortletResourceResolver(PortletContext context, String scheme) {
        this.portletContext = context;
        this.scheme = scheme;
    }

    @Override
    public URL getResource(String url) throws Exception {
        String relativePath;
        URL res;
        ServletContext portalContextResolver = this.getPortalContext();
        if (portalContextResolver != null && (res = portalContextResolver.getResource(relativePath = this.removeScheme(url))) != null) {
            return res;
        }
        return this.getPortletResource(url);
    }

    @Override
    public InputStream getInputStream(String url) throws Exception {
        String relativePath;
        InputStream inputStream;
        ServletContext portalContextResolver = this.getPortalContext();
        if (portalContextResolver != null && (inputStream = portalContextResolver.getResourceAsStream(relativePath = this.removeScheme(url))) != null) {
            return inputStream;
        }
        return this.getPortletInputStream(url);
    }

    @Override
    public String getRealPath(String url) {
        String relativePath;
        String path;
        ServletContext portalContextResolver = this.getPortalContext();
        if (portalContextResolver != null && (path = portalContextResolver.getRealPath(relativePath = this.removeScheme(url))) != null) {
            return path;
        }
        return this.getPortletRealPath(url);
    }

    @Override
    public List<URL> getResources(String url) throws Exception {
        ArrayList<URL> urlList = new ArrayList<URL>();
        urlList.add(this.getResource(url));
        return urlList;
    }

    @Override
    public List<InputStream> getInputStreams(String url) throws Exception {
        ArrayList<InputStream> inputStreams = new ArrayList<InputStream>();
        inputStreams.add(this.getInputStream(url));
        return inputStreams;
    }

    @Override
    public boolean isModified(String url, long lastAccess) {
        try {
            URL uri = this.getResource(url);
            URLConnection con = uri.openConnection();
            if (log.isDebugEnabled()) {
                log.debug((Object)(url + ": " + con.getLastModified() + " " + lastAccess));
            }
            if (con.getLastModified() > lastAccess) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    @Override
    public String getWebAccessPath(String url) {
        return "/" + this.portletContext.getPortletContextName() + this.removeScheme(url);
    }

    @Override
    public String getResourceScheme() {
        return this.scheme;
    }

    @Override
    public ResourceKey createResourceKey(String url) {
        String portletContextName = this.portletContext.getPortletContextName();
        int resolverId = portletContextName != null ? portletContextName.hashCode() : this.hashCode();
        return new ResourceKey(resolverId, url);
    }

    private URL getPortletResource(String url) throws MalformedURLException {
        String path = this.removeScheme(url);
        return this.portletContext.getResource(path);
    }

    private InputStream getPortletInputStream(String url) {
        String path = this.removeScheme(url);
        return this.portletContext.getResourceAsStream(path);
    }

    private String getPortletRealPath(String url) {
        String path = this.removeScheme(url);
        return this.portletContext.getRealPath(path);
    }

    private ServletContext getPortalContext() {
        PortalContainer container;
        if (this.portalContext == null && (container = PortalContainer.getInstanceIfPresent()) != null) {
            this.portalContext = container.getPortalContext();
        }
        return this.portalContext;
    }
}

