/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.site;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.pom.data.PortalData;
import org.gatein.api.ApiException;
import org.gatein.api.EntityAlreadyExistsException;
import org.gatein.api.Util;
import org.gatein.api.common.Attributes;
import org.gatein.api.internal.ObjectToStringBuilder;
import org.gatein.api.internal.Parameters;
import org.gatein.api.security.Permission;
import org.gatein.api.site.Site;
import org.gatein.api.site.SiteId;
import org.gatein.api.site.SiteType;

public class SiteImpl
implements Site {
    private static final long serialVersionUID = -5352376442491205465L;
    private final SiteId id;
    private transient PortalConfig portalConfig;
    private Attributes attributes;
    private boolean create;
    private String templateName;
    private Set<String> changed = new HashSet<String>();

    public SiteImpl(SiteId id, String templateName) {
        this.id = id;
        SiteKey siteKey = Util.from(id);
        this.portalConfig = new PortalConfig(siteKey.getTypeName(), siteKey.getName());
        this.attributes = new Attributes();
        this.create = true;
        this.templateName = templateName;
    }

    public SiteImpl(PortalConfig portalConfig) {
        this.portalConfig = portalConfig;
        SiteKey siteKey = new SiteKey(portalConfig.getType(), portalConfig.getName());
        this.id = Util.from(siteKey);
        this.attributes = Util.from(portalConfig.getProperties());
    }

    public SiteId getId() {
        return this.id;
    }

    public SiteType getType() {
        return this.id.getType();
    }

    public String getName() {
        return this.id.getName();
    }

    public String getDescription() {
        return this.portalConfig.getDescription();
    }

    public void setDescription(String description) {
        if (this.create) {
            this.changed.add("description");
        }
        this.portalConfig.setDescription(description);
    }

    public void setDisplayName(String displayName) {
        if (this.create) {
            this.changed.add("displayName");
        }
        this.portalConfig.setLabel(displayName);
    }

    public String getDisplayName() {
        return this.portalConfig.getLabel();
    }

    public Locale getLocale() {
        return Util.toLocale(this.portalConfig.getLocale());
    }

    public void setLocale(Locale locale) {
        if (this.create) {
            this.changed.add("locale");
        }
        Parameters.requireNonNull((Object)locale, (String)"locale");
        this.portalConfig.setLocale(Util.fromLocale(locale));
    }

    public String getSkin() {
        return this.portalConfig.getSkin();
    }

    public void setSkin(String skin) {
        if (this.create) {
            this.changed.add("skin");
        }
        this.portalConfig.setSkin(skin);
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public Permission getAccessPermission() {
        return Util.from(this.portalConfig.getAccessPermissions());
    }

    public void setAccessPermission(Permission permission) {
        if (this.create) {
            this.changed.add("access");
        }
        this.portalConfig.setAccessPermissions(Util.from(permission));
    }

    public Permission getEditPermission() {
        return Util.from(this.portalConfig.getEditPermission());
    }

    public void setEditPermission(Permission permission) {
        Parameters.requireNonNull((Object)permission, (String)"permission", (String)"To allow edit for everyone use Permission.everyone()");
        String[] permissions = Util.from(permission);
        if (permissions.length != 1) {
            throw new IllegalArgumentException("Invalid permission. Only one membership is allowed for an edit permission");
        }
        if (this.create) {
            this.changed.add("edit");
        }
        this.portalConfig.setEditPermission(permissions[0]);
    }

    public void save(LayoutService storage, UserPortalConfigService service) {
        if (this.create) {
            PortalConfig created;
            try {
                PortalConfig existing = storage.getPortalConfig(this.portalConfig.getType(), this.portalConfig.getName());
                if (existing != null) {
                    throw new EntityAlreadyExistsException("Cannot create site. Site " + this.id + " already exists.");
                }
            }
            catch (Exception e) {
                throw new ApiException("Exception occurred checking if site already existed before creating site " + this.id, (Throwable)e);
            }
            try {
                switch (this.id.getType()) {
                    case SITE: {
                        service.createUserPortalConfig(this.portalConfig.getType(), this.portalConfig.getName(), this.templateName);
                        break;
                    }
                    case SPACE: {
                        service.createGroupSite(this.portalConfig.getName());
                    }
                }
            }
            catch (Exception e) {
                throw new ApiException("Could not create site " + this.id, (Throwable)e);
            }
            try {
                created = storage.getPortalConfig(this.portalConfig.getType(), this.portalConfig.getName());
                if (created == null) {
                    throw new ApiException("Could not find site after we successfully created it.");
                }
            }
            catch (Exception e) {
                throw new ApiException("Exception occurred retrieving previously created site " + this.id);
            }
            SiteImpl createdSite = new SiteImpl(created);
            if (this.changed.contains("access")) {
                createdSite.setAccessPermission(this.getAccessPermission());
            }
            if (this.changed.contains("edit")) {
                createdSite.setEditPermission(this.getEditPermission());
            }
            if (this.changed.contains("skin")) {
                createdSite.setSkin(this.getSkin());
            }
            if (this.changed.contains("locale")) {
                createdSite.setLocale(this.getLocale());
            }
            if (this.changed.contains("description")) {
                createdSite.setDescription(this.getDescription());
            }
            if (this.changed.contains("displayName")) {
                createdSite.setDisplayName(this.getDisplayName());
            }
            createdSite.getAttributes().putAll((Map)this.getAttributes());
            this.attributes = createdSite.getAttributes();
            this.portalConfig = createdSite.portalConfig;
        }
        this.portalConfig.setProperties(Util.from(this.attributes));
        try {
            storage.save(this.portalConfig);
            this.changed = null;
            this.create = false;
            this.templateName = null;
        }
        catch (Exception e) {
            throw new ApiException("Exception occurred trying to save site " + this.id, (Throwable)e);
        }
    }

    public int compareTo(Site other) {
        return this.getName().compareTo(other.getName());
    }

    public String toString() {
        return ObjectToStringBuilder.toStringBuilder(this.getClass()).add("type", (Object)this.getType().getName()).add("name", (Object)this.getName()).add("displayName", (Object)this.getDisplayName()).add("description", (Object)this.getDescription()).add("locale", (Object)this.getLocale()).add("skin", (Object)this.getSkin()).add("attributes", (Object)this.getAttributes()).add("editPermission", (Object)this.getEditPermission()).add("accessPermission", (Object)this.getAccessPermission()).toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        PortalData data = (PortalData)in.readObject();
        this.portalConfig = new PortalConfig(data);
    }

    private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
        out.defaultWriteObject();
        out.writeObject(this.portalConfig.build());
    }
}

