/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form.input;

import java.io.Writer;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;

@Serialized
public class UICheckBoxInput
extends UIFormInputBase<Boolean> {
    private String onchange_;
    private String componentEvent_ = null;

    public UICheckBoxInput() {
        this(null, null, false);
    }

    public UICheckBoxInput(String name, String bindingExpression, Boolean value) {
        super(name, bindingExpression, Boolean.class);
        this.setValue(value);
    }

    @Override
    public UIFormInput<Boolean> setValue(Boolean value) {
        if (value == null) {
            value = false;
        }
        return super.setValue(value);
    }

    public boolean isChecked() {
        return this.getValue() == null ? false : (Boolean)this.getValue();
    }

    public UICheckBoxInput setChecked(boolean check) {
        return (UICheckBoxInput)this.setValue(check);
    }

    public void setOnChange(String onchange) {
        this.onchange_ = onchange;
    }

    public void setComponentEvent(String com) {
        this.componentEvent_ = com;
    }

    public void setOnChange(String event, String com) {
        this.onchange_ = event;
        this.componentEvent_ = com;
    }

    public String renderOnChangeEvent(UIForm uiForm) throws Exception {
        if (this.componentEvent_ == null) {
            return uiForm.event(this.onchange_, null);
        }
        return uiForm.event(this.onchange_, this.componentEvent_, null);
    }

    @Override
    public void decode(Object input, WebuiRequestContext context) {
        if (this.isDisabled()) {
            return;
        }
        if (input == null || "false".equals(input.toString())) {
            this.setValue(false);
        } else {
            this.setValue(true);
        }
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        ResourceBundle res = context.getApplicationResourceBundle();
        Object label = this.getId() + ".label";
        try {
            label = res.getString((String)label);
        }
        catch (MissingResourceException e) {
            label = null;
        }
        Writer w = context.getWriter();
        if (label != null) {
            w.write("<label class=\"uiCheckbox\">");
        } else {
            w.write("<span class=\"uiCheckbox\">");
        }
        w.append("<input id=\"").append(this.getId()).append("\" type=\"checkbox\" class=\"checkbox\" name=\"");
        w.write(this.name);
        w.write("\"");
        if (this.onchange_ != null) {
            UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
            w.append(" onclick=\"").append(this.renderOnChangeEvent(uiForm)).append("\"");
        }
        if (this.isChecked()) {
            w.write(" checked");
        }
        if (this.isDisabled()) {
            w.write(" disabled");
        }
        this.renderHTMLAttributes(w);
        w.write("/><span>");
        if (label != null) {
            w.write((String)label);
            w.write("</span></label>");
        } else {
            w.write("</span></span>");
        }
        if (this.isMandatory()) {
            w.write(" *");
        }
    }
}

