/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.service.impl;

import io.meeds.gamification.constant.DateFilterType;
import io.meeds.gamification.constant.EntityFilterType;
import io.meeds.gamification.constant.EntityStatusType;
import io.meeds.gamification.constant.IdentityType;
import io.meeds.gamification.constant.Period;
import io.meeds.gamification.constant.RealizationStatus;
import io.meeds.gamification.constant.RecurrenceType;
import io.meeds.gamification.model.PiechartLeaderboard;
import io.meeds.gamification.model.ProfileReputation;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.RealizationDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.model.StandardLeaderboard;
import io.meeds.gamification.model.filter.LeaderboardFilter;
import io.meeds.gamification.model.filter.RealizationFilter;
import io.meeds.gamification.model.filter.RuleFilter;
import io.meeds.gamification.rest.model.RealizationValidityContext;
import io.meeds.gamification.service.ProgramService;
import io.meeds.gamification.service.RealizationService;
import io.meeds.gamification.service.RuleService;
import io.meeds.gamification.service.impl.RealizationServiceImpl$AjcClosure1;
import io.meeds.gamification.storage.RealizationStorage;
import io.meeds.gamification.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.picocontainer.Startable;

public class RealizationServiceImpl
implements RealizationService,
Startable {
    private static final String REALIZATION_NOT_EXIST_MESSAGE = "Realization with id %s doesn't exist";
    private static final Log LOG;
    private static final String[] COLUMNS;
    private static final String SHEETNAME = "Achivements Report";
    private ExecutorService executorService;
    private ProgramService programService;
    private RuleService ruleService;
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private ResourceBundleService resourceBundleService;
    private ListenerService listenerService;
    private RealizationStorage realizationStorage;
    private String blacklistMembershipExpression = "/leaderboard-blacklist-users";
    private MembershipEntry blacklistMembership;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public RealizationServiceImpl(ProgramService programService, RuleService ruleService, ResourceBundleService resourceBundleService, IdentityManager identityManager, SpaceService spaceService, RealizationStorage realizationStorage, ListenerService listenerService, InitParams initParams) {
        this.programService = programService;
        this.ruleService = ruleService;
        this.resourceBundleService = resourceBundleService;
        this.spaceService = spaceService;
        this.realizationStorage = realizationStorage;
        this.identityManager = identityManager;
        this.listenerService = listenerService;
        if (initParams != null && initParams.containsKey((Object)"blacklist.group")) {
            this.blacklistMembershipExpression = initParams.getValueParam("blacklist.group").getValue();
        }
        this.blacklistMembership = MembershipEntry.parse((String)this.blacklistMembershipExpression);
        if (this.blacklistMembership == null) {
            this.blacklistMembership = new MembershipEntry(this.blacklistMembershipExpression);
        }
    }

    public void start() {
        QueuedThreadPool threadFactory = new QueuedThreadPool(5, 1, 1);
        threadFactory.setName("Gamification - Realization");
        this.executorService = Executors.newCachedThreadPool((ThreadFactory)threadFactory);
    }

    public void stop() {
        this.executorService.shutdown();
    }

    @Override
    public List<RealizationDTO> getRealizationsByFilter(RealizationFilter realizationFilter, Identity userAclIdentity, int offset, int limit) throws IllegalAccessException {
        if ((realizationFilter = this.computeProgramFilter(realizationFilter, userAclIdentity)) == null) {
            return Collections.emptyList();
        }
        return this.getRealizationsByFilter(realizationFilter, offset, limit);
    }

    @Override
    public List<RealizationDTO> getRealizationsByFilter(RealizationFilter realizationFilter, int offset, int limit) {
        return this.realizationStorage.getRealizationsByFilter(realizationFilter, offset, limit);
    }

    @Override
    public int countRealizationsByFilter(RealizationFilter realizationFilter, Identity userAclIdentity) throws IllegalAccessException {
        if ((realizationFilter = this.computeProgramFilter(realizationFilter, userAclIdentity)) == null) {
            return 0;
        }
        return this.countRealizationsByFilter(realizationFilter);
    }

    @Override
    public int countRealizationsByFilter(RealizationFilter realizationFilter) {
        return this.realizationStorage.countRealizationsByFilter(realizationFilter);
    }

    @Override
    public int getLeaderboardRank(String earnerIdentityId, Date fromDate, Long programId) {
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getIdentity(earnerIdentityId);
        IdentityType identityType = IdentityType.getType(identity.getProviderId());
        if (fromDate != null) {
            if (programId == null || programId <= 0L) {
                return this.realizationStorage.getLeaderboardRankByDate(identityType, earnerIdentityId, fromDate);
            }
            return this.realizationStorage.getLeaderboardRankByDateAndProgramId(identityType, earnerIdentityId, fromDate, programId);
        }
        if (programId == null || programId <= 0L) {
            return this.realizationStorage.getLeaderboardRank(identityType, earnerIdentityId);
        }
        return this.realizationStorage.getLeaderboardRankByProgramId(identityType, earnerIdentityId, programId);
    }

    @Override
    public long getScoreByIdentityId(String earnerIdentityId) {
        return this.realizationStorage.getScoreByIdentityId(earnerIdentityId);
    }

    @Override
    public List<ProfileReputation> getScorePerProgramByIdentityId(String earnerIdentityId) {
        return this.realizationStorage.getScorePerProgramByIdentityId(earnerIdentityId);
    }

    @Override
    public void createRealizationsAsync(String event, String earnerIdentityId, String receiverIdentityId, String objectId, String objectType) {
        this.executorService.execute(() -> this.createRealizationsAsyncInternal(event, earnerIdentityId, receiverIdentityId, objectId, objectType));
    }

    @Override
    public List<RealizationDTO> createRealizations(String event, String earnerIdentityId, String receiverIdentityId, String objectId, String objectType) {
        org.exoplatform.social.core.identity.model.Identity earnerIdentity = this.identityManager.getIdentity(earnerIdentityId);
        if (earnerIdentity == null || earnerIdentity.isDeleted() || !earnerIdentity.isEnable()) {
            return Collections.emptyList();
        }
        List<RuleDTO> rules = this.findActiveRulesByEventAndEarner(event, earnerIdentity);
        if (CollectionUtils.isEmpty(rules)) {
            return Collections.emptyList();
        }
        return rules.stream().distinct().filter(rule -> this.getRealizationValidityContext((RuleDTO)rule, earnerIdentity.getId()).isValidForIdentity()).map(rule -> this.toRealization((RuleDTO)rule, earnerIdentity, receiverIdentityId, objectId, objectType)).filter(Objects::nonNull).map(r -> {
            r = this.realizationStorage.createRealization((RealizationDTO)r);
            Utils.broadcastEvent(this.listenerService, "realization.created", r, null);
            return r;
        }).toList();
    }

    @Override
    public void updateRealizationStatus(long realizationId, RealizationStatus status) throws ObjectNotFoundException {
        RealizationDTO realization = this.getRealizationById(realizationId);
        if (realization == null) {
            throw new ObjectNotFoundException(String.format(REALIZATION_NOT_EXIST_MESSAGE, realizationId));
        }
        if (status == null) {
            throw new IllegalArgumentException("status is mandatory");
        }
        this.updateRealizationStatus(realization, status);
    }

    @Override
    public void updateRealizationStatus(long realizationId, RealizationStatus status, String username) throws IllegalAccessException, ObjectNotFoundException {
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new IllegalAccessException("username is mandatory");
        }
        if (status == null) {
            throw new IllegalArgumentException("status is mandatory");
        }
        if (status != RealizationStatus.ACCEPTED && status != RealizationStatus.REJECTED) {
            throw new IllegalArgumentException("Allowed manual status can be either ACCEPTED or REJECTED");
        }
        RealizationDTO realization = this.getRealizationById(realizationId);
        if (realization == null) {
            throw new ObjectNotFoundException(String.format(REALIZATION_NOT_EXIST_MESSAGE, realizationId));
        }
        if (!Utils.isRewardingManager(username) && !this.programService.isProgramOwner(realization.getProgram().getId(), username)) {
            throw new IllegalAccessException("User doesn't have enough privileges to update achievements of user" + realization.getEarnerId());
        }
        this.updateRealizationStatus(realization, status);
    }

    @Override
    public List<RealizationDTO> cancelRealizations(String event, String earnerIdentityId, String receiverIdentityId, String objectId, String objectType) {
        List<RuleDTO> rules = this.findActiveRulesByEvent(event);
        if (CollectionUtils.isEmpty(rules)) {
            return Collections.emptyList();
        }
        return rules.stream().map(rule -> this.realizationStorage.findLastReadlizationByRuleIdAndEarnerIdAndReceiverAndObjectId(rule.getId(), earnerIdentityId, receiverIdentityId, objectId, objectType)).filter(Objects::nonNull).filter(realization -> !RealizationStatus.CANCELED.name().equals(realization.getStatus())).map(realization -> {
            realization.setStatus(RealizationStatus.CANCELED.name());
            realization.setActivityId(null);
            realization.setObjectId(null);
            try {
                RealizationDTO realizationDTO = this.realizationStorage.updateRealization((RealizationDTO)realization);
                return realizationDTO;
            }
            catch (Exception e) {
                LOG.warn("Error canceling realization with id {}", new Object[]{realization.getId(), e});
                RealizationDTO realizationDTO = null;
                return realizationDTO;
            }
            finally {
                Utils.broadcastEvent(this.listenerService, "realization.canceled", realization, null);
            }
        }).filter(Objects::nonNull).toList();
    }

    @Override
    public List<RealizationDTO> deleteRealizations(String objectId, String objectType) {
        List<RealizationDTO> realizations = this.findRealizationsByObjectIdAndObjectType(objectId, objectType);
        realizations.forEach(realization -> {
            if (!RealizationStatus.DELETED.name().equals(realization.getStatus()) && !RealizationStatus.CANCELED.name().equals(realization.getStatus())) {
                realization.setStatus(RealizationStatus.DELETED.name());
                realization.setActivityId(null);
                realization.setObjectId(null);
                try {
                    this.realizationStorage.updateRealization((RealizationDTO)realization);
                }
                catch (Exception e) {
                    LOG.warn("Error deleting realization with id {}", new Object[]{realization.getId(), e});
                }
                finally {
                    Utils.broadcastEvent(this.listenerService, "realization.canceled", realization, null);
                }
            }
        });
        return realizations;
    }

    @Override
    public RealizationValidityContext getRealizationValidityContext(RuleDTO rule, String earnerIdentityId) {
        boolean anonymous;
        RealizationValidityContext realizationRestriction = new RealizationValidityContext();
        if (rule == null || rule.isDeleted() || !rule.isEnabled()) {
            realizationRestriction.setValidRule(false);
            return realizationRestriction;
        }
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getIdentity(earnerIdentityId);
        boolean bl = anonymous = identity == null || identity.isDeleted() || !identity.isEnable();
        if (anonymous || identity.isUser() && !this.programService.isProgramMember(rule.getProgram().getId(), identity.getRemoteId()) || identity.isSpace() && !rule.isOpen() && rule.getSpaceId() != this.getSpaceId(identity.getRemoteId())) {
            realizationRestriction.setValidIdentity(false);
        }
        if (!this.isValidProgram(rule.getProgram())) {
            realizationRestriction.setValidProgram(false);
            return realizationRestriction;
        }
        if (!this.isValidDates(rule)) {
            realizationRestriction.setValidDates(false);
        }
        if (!anonymous && !this.isRecurrenceValid(rule, earnerIdentityId)) {
            realizationRestriction.setValidRecurrence(false);
            RecurrenceType recurrence = rule.getRecurrence();
            if (recurrence == RecurrenceType.DAILY || recurrence == RecurrenceType.WEEKLY || recurrence == RecurrenceType.MONTHLY) {
                Date endDate = Utils.parseSimpleDate(rule.getEndDate());
                Instant nextDate = recurrence.getNextPeriodStartDate().toInstant();
                if (endDate == null || endDate.toInstant().isAfter(nextDate)) {
                    Instant now = Instant.now();
                    realizationRestriction.setNextOccurenceMillis(ChronoUnit.MILLIS.between(now, nextDate));
                }
            }
        }
        if (!anonymous && CollectionUtils.isNotEmpty(rule.getPrerequisiteRuleIds())) {
            realizationRestriction.setValidPrerequisites(new HashMap<String, Boolean>());
            rule.getPrerequisiteRuleIds().forEach(prerequisiteRuleId -> {
                boolean prerequisiteRealized = this.realizationStorage.countRealizationsByRuleIdAndEarnerId(earnerIdentityId, (long)prerequisiteRuleId) > 0;
                realizationRestriction.getValidPrerequisites().put(String.valueOf(prerequisiteRuleId), prerequisiteRealized);
            });
        }
        if (!anonymous && realizationRestriction.isValidForIdentity()) {
            Space space;
            if (!rule.isOpen() && (space = this.spaceService.getSpaceById(String.valueOf(rule.getSpaceId()))) == null) {
                realizationRestriction.setValidAudience(false);
            }
            if (identity.isUser() && this.isUserBlacklisted(identity.getRemoteId())) {
                realizationRestriction.setValidWhitelist(false);
            }
        }
        return realizationRestriction;
    }

    @Override
    public List<StandardLeaderboard> getLeaderboard(LeaderboardFilter filter, String currentUser) throws IllegalAccessException {
        int limit = filter.getLimit();
        IdentityType identityType = filter.getIdentityType();
        if (identityType.isSpace()) {
            if (StringUtils.isBlank((CharSequence)currentUser)) {
                throw new IllegalAccessException("Anonymous user can't access spaces board");
            }
            limit *= 3;
        }
        String period = filter.getPeriod();
        long programId = filter.getProgramId() == null ? 0L : filter.getProgramId();
        List<StandardLeaderboard> leaderboardItems = null;
        Date fromDate = this.getFromDate(period);
        leaderboardItems = programId <= 0L ? (period.equals(Period.ALL.name()) ? this.realizationStorage.getLeaderboard(identityType, filter.getOffset(), limit) : this.realizationStorage.getLeaderboardByDate(fromDate, identityType, filter.getOffset(), limit)) : (period.equals(Period.ALL.name()) ? this.realizationStorage.getLeaderboardByProgramId(programId, identityType, filter.getOffset(), limit) : this.realizationStorage.getLeaderboardByDateByProgramId(fromDate, identityType, programId, filter.getOffset(), limit));
        if (identityType.isSpace() && leaderboardItems != null && !leaderboardItems.isEmpty()) {
            leaderboardItems = this.filterAuthorizedSpaces(leaderboardItems, currentUser, filter.getLimit());
        }
        return leaderboardItems;
    }

    @Override
    public List<PiechartLeaderboard> getLeaderboardStatsByIdentityId(String earnerIdentityId, Date startDate, Date endDate) {
        return this.realizationStorage.getLeaderboardStatsByIdentityId(earnerIdentityId, startDate, endDate);
    }

    @Override
    public long getScoreByIdentityIdAndBetweenDates(String earnerIdentityId, Date fromDate, Date toDate) {
        return this.realizationStorage.getScoreByIdentityIdAndBetweenDates(earnerIdentityId, fromDate, toDate);
    }

    @Override
    public Map<Long, Long> getScoresByIdentityIdsAndBetweenDates(List<String> earnersId, Date fromDate, Date toDate) {
        return this.realizationStorage.getScoresByIdentityIdsAndBetweenDates(earnersId, fromDate, toDate);
    }

    @Override
    public RealizationDTO getRealizationById(long realizationId) {
        if (realizationId <= 0L) {
            throw new IllegalArgumentException("realization id is mandatory");
        }
        return this.realizationStorage.getRealizationById(realizationId);
    }

    @Override
    public boolean isRealizationManager(String username) {
        if (Utils.isRewardingManager(username)) {
            return true;
        }
        return this.programService.countOwnedPrograms(username) > 0;
    }

    @Override
    public RealizationDTO getRealizationById(long realizationId, Identity userAclIdentity) throws IllegalAccessException, ObjectNotFoundException {
        if (realizationId <= 0L) {
            throw new IllegalArgumentException("realization id is mandatory");
        }
        if (userAclIdentity == null) {
            throw new IllegalArgumentException("identity is mandatory");
        }
        String username = userAclIdentity.getUserId();
        org.exoplatform.social.core.identity.model.Identity userIdentity = this.identityManager.getOrCreateUserIdentity(username);
        RealizationDTO realization = this.realizationStorage.getRealizationById(realizationId);
        if (realization == null) {
            throw new ObjectNotFoundException(String.format(REALIZATION_NOT_EXIST_MESSAGE, realizationId));
        }
        if (this.programService.canViewProgram(realization.getProgram().getId(), userAclIdentity.getUserId()) || realization.getEarnerId().equals(userIdentity.getId())) {
            return realization;
        }
        throw new IllegalAccessException("User doesn't have enough privileges to access achievement");
    }

    @Override
    public List<RealizationDTO> findRealizationsByObjectIdAndObjectType(String objectId, String objectType) {
        return this.realizationStorage.findRealizationsByObjectIdAndObjectType(objectId, objectType);
    }

    @Override
    public InputStream exportXlsx(RealizationFilter filter, Identity identity, String fileName, Locale locale) throws IllegalAccessException {
        File temp = null;
        try {
            temp = this.createTempFile(fileName);
            List<RealizationDTO> realizations = this.getRealizationsByFilter(filter, identity, 0, -1);
            try (XSSFWorkbook workbook = new XSSFWorkbook();
                 FileOutputStream outputStream = new FileOutputStream(temp);){
                int rowIndex = 0;
                XSSFCreationHelper helper = workbook.getCreationHelper();
                XSSFSheet sheet = workbook.createSheet(SHEETNAME);
                this.appendRealizationHeaderRow((Sheet)sheet, rowIndex++, (CreationHelper)helper, locale);
                for (RealizationDTO realization : realizations) {
                    this.appendRealizationRow((Sheet)sheet, rowIndex++, (CreationHelper)helper, realization);
                }
                workbook.write((OutputStream)outputStream);
            }
            FileInputStream fileInputStream = new FileInputStream(temp);
            return fileInputStream;
        }
        catch (IOException e) {
            throw new IllegalStateException("Error exporting XLSX file for achievements with filter " + filter, e);
        }
        finally {
            if (temp != null && temp.exists()) {
                temp.deleteOnExit();
            }
        }
    }

    @ExoTransactional
    public void createRealizationsAsyncInternal(String event, String earnerIdentityId, String receiverIdentityId, String objectId, String objectType) {
        String string = event;
        String string2 = earnerIdentityId;
        String string3 = receiverIdentityId;
        String string4 = objectId;
        String string5 = objectType;
        Object[] objectArray = new Object[]{string, string2, string3, string4, string5};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, string2, string3, string4, string5, joinPoint};
        RealizationServiceImpl$AjcClosure1 realizationServiceImpl$AjcClosure1 = new RealizationServiceImpl$AjcClosure1(objectArray2);
        ExoTransactionalAspect.aspectOf().around(realizationServiceImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private RealizationFilter computeProgramFilter(RealizationFilter realizationFilter, Identity userAclIdentity) throws IllegalAccessException {
        String username;
        if (realizationFilter == null) {
            throw new IllegalArgumentException("filter is mandatory");
        }
        realizationFilter = realizationFilter.clone();
        this.checkDates(realizationFilter.getFromDate(), realizationFilter.getToDate());
        String string = username = userAclIdentity == null ? null : userAclIdentity.getUserId();
        if (Utils.isRewardingManager(username) || realizationFilter.isAllPrograms()) {
            return realizationFilter;
        }
        List<Long> filterProgramIds = this.computeFilteredPrograms(realizationFilter);
        boolean isFilterByPrograms = CollectionUtils.isNotEmpty(filterProgramIds);
        if (realizationFilter.isOwned()) {
            if (isFilterByPrograms && !this.isProgramsOwner(filterProgramIds, username)) {
                throw new IllegalAccessException("User is not owner of one or several selected programs :" + filterProgramIds);
            }
            if (!isFilterByPrograms) {
                List<Long> ownedProgramIds = this.programService.getOwnedProgramIds(username, 0, -1);
                if (CollectionUtils.isEmpty(ownedProgramIds)) {
                    return null;
                }
                realizationFilter.setProgramIds(ownedProgramIds);
            }
        } else {
            if (isFilterByPrograms && !this.canViewPrograms(filterProgramIds, username)) {
                throw new IllegalAccessException("User is not member of one or several selected programs :" + filterProgramIds);
            }
            if (!isFilterByPrograms && !this.isSelfFilter(realizationFilter, username)) {
                List<Long> memberProgramIds = this.programService.getMemberProgramIds(username, 0, -1);
                if (CollectionUtils.isEmpty(memberProgramIds)) {
                    return null;
                }
                realizationFilter.setProgramIds(memberProgramIds);
            }
        }
        return realizationFilter;
    }

    private boolean isSelfFilter(RealizationFilter realizationFilter, String username) {
        org.exoplatform.social.core.identity.model.Identity userIdentity = this.identityManager.getOrCreateUserIdentity(username);
        boolean filterByEarner = CollectionUtils.isNotEmpty(realizationFilter.getEarnerIds());
        return filterByEarner && realizationFilter.getEarnerIds().size() == 1 && userIdentity != null && realizationFilter.getEarnerIds().get(0).equals(userIdentity.getId());
    }

    private List<Long> computeFilteredPrograms(RealizationFilter realizationFilter) {
        List<Long> filterProgramIds = realizationFilter.getProgramIds();
        List<Long> ruleIds = realizationFilter.getRuleIds();
        if (CollectionUtils.isNotEmpty(ruleIds)) {
            Set programIds = ruleIds.stream().map(ruleId -> {
                RuleDTO rule = this.ruleService.findRuleById((long)ruleId);
                return rule == null || rule.getProgramId() == 0L ? null : Long.valueOf(rule.getProgramId());
            }).filter(Objects::nonNull).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(filterProgramIds)) {
                return programIds.stream().toList();
            }
            return CollectionUtils.intersection(filterProgramIds, programIds).stream().toList();
        }
        return filterProgramIds;
    }

    private boolean isProgramsOwner(List<Long> programIds, String username) {
        return programIds.stream().allMatch(programId -> this.programService.isProgramOwner((long)programId, username));
    }

    private boolean canViewPrograms(List<Long> programIds, String username) {
        return programIds.stream().allMatch(programId -> this.programService.canViewProgram((long)programId, username));
    }

    private List<StandardLeaderboard> filterAuthorizedSpaces(List<StandardLeaderboard> result, String currentUser, int limit) {
        result = result.stream().filter(spacePoint -> {
            String spaceIdentityId = spacePoint.getEarnerId();
            org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getIdentity(spaceIdentityId);
            if (identity == null) {
                LOG.debug("Space Identity with id {} was deleted, ignore it", new Object[]{spaceIdentityId});
                return false;
            }
            Space space = this.spaceService.getSpaceByPrettyName(identity.getRemoteId());
            return space != null && (!"hidden".equals(space.getVisibility()) || this.spaceService.isMember(space, currentUser));
        }).limit(limit).toList();
        return result;
    }

    private void checkDates(Date fromDate, Date toDate) {
        if (fromDate != null && toDate != null && fromDate.after(toDate)) {
            throw new IllegalArgumentException("Dates parameters are not set correctly");
        }
    }

    private boolean isRecurrenceValid(RuleDTO rule, String earnerIdentityId) {
        return rule.getRecurrence() == null || rule.getRecurrence() == RecurrenceType.NONE || this.hasNoRealizationInPeriod(earnerIdentityId, rule.getId(), rule.getRecurrence().getPeriodStartDate());
    }

    private boolean hasNoRealizationInPeriod(String earnerIdentityId, Long ruleId, Date sinceDate) {
        return this.realizationStorage.countRealizationsByRuleIdAndEarnerIdSinceDate(earnerIdentityId, ruleId, sinceDate) == 0;
    }

    private RealizationDTO toRealization(RuleDTO ruleDto, org.exoplatform.social.core.identity.model.Identity earnerIdentity, String receiverIdentityId, String objectId, String objectType) {
        RealizationDTO realization = new RealizationDTO();
        realization.setActionScore(ruleDto.getScore());
        realization.setGlobalScore(this.getScoreByIdentityId(earnerIdentity.getId()) + (long)ruleDto.getScore());
        realization.setEarnerId(earnerIdentity.getId());
        realization.setEarnerType(earnerIdentity.getProviderId());
        realization.setActionTitle(ruleDto.getTitle());
        realization.setRuleId(ruleDto.getId());
        realization.setProgram(ruleDto.getProgram());
        realization.setReceiver(receiverIdentityId);
        realization.setObjectId(objectId);
        realization.setObjectType(objectType);
        realization.setStatus(RealizationStatus.ACCEPTED.name());
        realization.setType(ruleDto.getType());
        return realization;
    }

    private boolean isValidProgram(ProgramDTO program) {
        return program != null && program.isEnabled() && !program.isDeleted();
    }

    private boolean isValidDates(RuleDTO rule) {
        Date startDate = Utils.parseSimpleDate(rule.getStartDate());
        Date endDate = Utils.parseSimpleDate(rule.getEndDate());
        return !(startDate != null && startDate.getTime() >= System.currentTimeMillis() || endDate != null && endDate.getTime() <= System.currentTimeMillis());
    }

    private List<RuleDTO> findActiveRulesByEvent(String eventName) {
        return this.findActiveRulesByEventAndEarner(eventName, null);
    }

    private List<RuleDTO> findActiveRulesByEventAndEarner(String eventName, org.exoplatform.social.core.identity.model.Identity earnerIdentity) {
        RuleFilter ruleFilter = new RuleFilter();
        ruleFilter.setDateFilterType(DateFilterType.STARTED);
        ruleFilter.setType(EntityFilterType.AUTOMATIC);
        ruleFilter.setStatus(EntityStatusType.ENABLED);
        ruleFilter.setProgramStatus(EntityStatusType.ENABLED);
        ruleFilter.setEventName(eventName);
        if (earnerIdentity != null && earnerIdentity.isUser()) {
            return this.ruleService.getRules(ruleFilter, earnerIdentity.getRemoteId(), 0, -1);
        }
        ruleFilter.setAllSpaces(true);
        return this.ruleService.getRules(ruleFilter, 0, -1);
    }

    private boolean isUserBlacklisted(String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            return false;
        }
        Identity identity = Utils.getUserAclIdentity(username);
        if (identity == null) {
            return false;
        }
        return identity.isMemberOf(this.blacklistMembership);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRealizationStatus(RealizationDTO realization, RealizationStatus status) {
        realization.setStatus(status.name());
        try {
            this.realizationStorage.updateRealization(realization);
        }
        catch (Exception e) {
            try {
                LOG.warn("Error deleting realization with id {}", new Object[]{realization.getId(), e});
            }
            catch (Throwable throwable) {
                String eventName = switch (status) {
                    case RealizationStatus.CANCELED, RealizationStatus.DELETED, RealizationStatus.REJECTED -> "realization.canceled";
                    default -> "realization.updated";
                };
                Utils.broadcastEvent(this.listenerService, eventName, realization, null);
                throw throwable;
            }
            String eventName = switch (status) {
                case RealizationStatus.CANCELED, RealizationStatus.DELETED, RealizationStatus.REJECTED -> "realization.canceled";
                default -> "realization.updated";
            };
            Utils.broadcastEvent(this.listenerService, eventName, realization, null);
        }
        String eventName = switch (status) {
            case RealizationStatus.CANCELED, RealizationStatus.DELETED, RealizationStatus.REJECTED -> "realization.canceled";
            default -> "realization.updated";
        };
        Utils.broadcastEvent(this.listenerService, eventName, realization, null);
    }

    private void appendRealizationHeaderRow(Sheet sheet, int rowIndex, CreationHelper helper, Locale locale) {
        Row row = sheet.createRow(rowIndex);
        ResourceBundle resourceBundle = this.resourceBundleService.getResourceBundle("locale.addon.Gamification", locale);
        for (int i = 0; i < COLUMNS.length; ++i) {
            row.createCell(i).setCellValue(helper.createRichTextString(resourceBundle.getString("realization.label." + COLUMNS[i])));
        }
    }

    private void appendRealizationRow(Sheet sheet, int rowIndex, CreationHelper helper, RealizationDTO realization) {
        Row row = sheet.createRow(rowIndex);
        try {
            RuleDTO rule = realization.getRuleId() != null && realization.getRuleId() != 0L ? this.ruleService.findRuleById(realization.getRuleId()) : this.ruleService.findRuleByTitle(realization.getActionTitle());
            String ruleTitle = rule == null ? null : rule.getEvent();
            String actionLabel = realization.getActionTitle() != null ? realization.getActionTitle() : ruleTitle;
            String programTitle = Utils.escapeIllegalCharacterInMessage(realization.getProgramLabel());
            int cellIndex = 0;
            row.createCell(cellIndex++).setCellValue(helper.createRichTextString(realization.getCreatedDate()));
            row.createCell(cellIndex++).setCellValue(Utils.getUserFullName(realization.getEarnerId()));
            row.createCell(cellIndex++).setCellValue(rule != null ? rule.getType().name() : "-");
            row.createCell(cellIndex++).setCellValue(programTitle);
            row.createCell(cellIndex++).setCellValue(actionLabel);
            row.createCell(cellIndex++).setCellValue((double)realization.getActionScore());
            row.createCell(cellIndex).setCellValue(realization.getStatus());
        }
        catch (Exception e) {
            LOG.error((Object)"Error when computing to XLSX ", (Throwable)e);
        }
    }

    private File createTempFile(String fileName) throws IOException {
        SimpleDateFormat formatter = new SimpleDateFormat("yy-MM-dd_HH-mm-ss");
        fileName = (String)fileName + formatter.format(new Date());
        if (SystemUtils.IS_OS_UNIX) {
            FileAttribute<Set<PosixFilePermission>> tempFileAttributes = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-------"));
            return Files.createTempFile((String)fileName, ".xlsx", tempFileAttributes).toFile();
        }
        File temp = Files.createTempFile((String)fileName, ".xlsx", new FileAttribute[0]).toFile();
        if (!temp.setReadable(true, true) || !temp.setWritable(true, true)) {
            throw new IllegalStateException("Can't write a temp file to export XLS achievements file");
        }
        return temp;
    }

    private Date getFromDate(String period) {
        Date fromDate = null;
        if (Period.WEEK.name().equals(period)) {
            fromDate = Date.from(LocalDate.now().with(DayOfWeek.MONDAY).atStartOfDay(ZoneId.systemDefault()).toInstant());
        } else if (Period.MONTH.name().equals(period)) {
            fromDate = Date.from(LocalDate.now().with(TemporalAdjusters.firstDayOfMonth()).atStartOfDay(ZoneId.systemDefault()).toInstant());
        }
        return fromDate;
    }

    private long getSpaceId(String spacePrettyName) {
        Space space = this.spaceService.getSpaceByPrettyName(spacePrettyName);
        return space == null ? 0L : Long.parseLong(space.getId());
    }

    static {
        RealizationServiceImpl.ajc$preClinit();
        LOG = ExoLogger.getLogger(RealizationServiceImpl.class);
        COLUMNS = new String[]{"date", "grantee", "actionType", "programLabel", "actionLabel", "points", "status"};
    }

    static /* synthetic */ void createRealizationsAsyncInternal_aroundBody0(RealizationServiceImpl ajc$this, String event, String earnerIdentityId, String receiverIdentityId, String objectId, String objectType, JoinPoint joinPoint) {
        ajc$this.createRealizations(event, earnerIdentityId, receiverIdentityId, objectId, objectType);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RealizationServiceImpl.java", RealizationServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createRealizationsAsyncInternal", "io.meeds.gamification.service.impl.RealizationServiceImpl", "java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String", "event:earnerIdentityId:receiverIdentityId:objectId:objectType", "", "void"), 567);
    }
}

